/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.client;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_ConnectionStateListener;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.test.MsgInterceptor;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.dispatch.ConnectionStateEnum;
import org.xmlBlaster.util.qos.address.Address;

public class TestFailSafePing
extends TestCase
implements I_ConnectionStateListener {
    private static String ME = "TestFailSafePing";
    private Global glob;
    private LogChannel log;
    private int serverPort = 7604;
    private EmbeddedXmlBlaster serverThread;
    private MsgInterceptor updateInterceptor;
    private I_XmlBlasterAccess con;
    private String senderName;
    private MsgUnit[] msgUnitArr;
    private int counter;
    private final String contentMime = "text/plain";

    public TestFailSafePing(String testName) {
        this(null, testName);
    }

    public TestFailSafePing(Global glob, String testName) {
        super(testName);
        this.glob = glob;
    }

    protected void setUp() {
        this.glob = this.glob == null ? new Global() : this.glob;
        this.log = this.glob.getLog("test");
        this.senderName = "TestFailSafePing-joe/97";
        this.glob.init(Util.getOtherServerPorts(this.serverPort));
        try {
            this.con = this.glob.getXmlBlasterAccess();
            String passwd = "secret";
            ConnectQos connectQos = new ConnectQos(this.glob, this.senderName, passwd);
            Address addressProp = new Address(this.glob);
            addressProp.setDelay(1000L);
            addressProp.setRetries(-1);
            addressProp.setPingInterval(1000L);
            this.con.registerConnectionListener(this);
            connectQos.setAddress(addressProp);
            this.updateInterceptor = new MsgInterceptor(this.glob, this.log, null);
            this.con.connect(connectQos, this.updateInterceptor);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "setUp() - login failed");
        }
        catch (Exception e) {
            this.log.error(ME, "setUp() - login failed: " + e.toString());
            e.printStackTrace();
        }
    }

    protected void tearDown() {
        this.log.info(ME, "Entering tearDown(), test is finished");
        String xmlKey = "<key oid='' queryType='XPATH'>\n   //TestFailSafe-AGENT</key>";
        String qos = "<qos><forceDestroy>true</forceDestroy></qos>";
        try {
            EraseReturnQos[] arr = this.con.erase(xmlKey, qos);
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "XmlBlasterException: " + e.getMessage());
        }
        this.con.disconnect(null);
        this.con = null;
        Util.resetPorts(this.glob);
        Global.instance().shutdown();
        this.glob = null;
        this.log = null;
        this.serverThread = null;
        this.updateInterceptor = null;
        this.msgUnitArr = null;
    }

    public void doSubscribe() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Subscribing using EXACT oid syntax ...");
        }
        String xmlKey = "<key oid='' queryType='XPATH'>\n   //TestFailSafePing-AGENT</key>";
        String qos = "<qos><initialUpdate>false</initialUpdate></qos>";
        try {
            String subscribeOid = this.con.subscribe(xmlKey, qos).getSubscriptionId();
            this.log.info(ME, "Success: Subscribe on " + subscribeOid + " done");
            Assert.assertTrue("returned null subscribeOid", subscribeOid != null);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    public void doPublish() throws XmlBlasterException {
        ++this.counter;
        if (this.log.TRACE) {
            this.log.trace(ME, "Publishing a message " + this.counter + " ...");
        }
        String oid = "MyMessage-" + this.counter;
        String xmlKey = "<key oid='" + oid + "' contentMime='" + "text/plain" + "'>\n" + "   <TestFailSafePing-AGENT id='192.168.124.10' subId='1' type='generic'>" + "   </TestFailSafePing-AGENT>" + "</key>";
        String content = "" + this.counter;
        PublishQos qosWrapper = new PublishQos(this.glob);
        MsgUnit msgUnit = new MsgUnit(xmlKey, content.getBytes(), qosWrapper.toXml());
        this.msgUnitArr = new MsgUnit[]{msgUnit};
        this.con.publish(msgUnit);
        this.log.info(ME, "Success: Publishing of " + oid + " done");
    }

    public void testFailSafe() {
        int i = 0;
        while (i < 3) {
            this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.serverPort);
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            Assert.assertEquals("", 1, this.updateInterceptor.waitOnUpdate(2000L, 1));
            this.updateInterceptor.compareToReceived(this.msgUnitArr, null);
            this.updateInterceptor.clear();
            EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
            this.serverThread = null;
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
    }

    public void reachedAlive(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        this.log.info(ME, "I_ConnectionStateListener: We were lucky, reconnected to xmlBlaster");
        this.doSubscribe();
        try {
            this.doPublish();
        }
        catch (XmlBlasterException e) {
            if (e.getErrorCode() == ErrorCode.COMMUNICATION_NOCONNECTION_POLLING) {
                this.log.warn(ME, "Lost connection, my connection layer is polling: " + e.getMessage());
            }
            if (e.getErrorCode() == ErrorCode.COMMUNICATION_NOCONNECTION_DEAD) {
                Assert.assertTrue("Lost connection, my connection layer is not polling", false);
            }
            Assert.assertTrue("Publishing problems: " + e.getMessage(), false);
        }
    }

    public void reachedPolling(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        this.log.warn(ME, "I_ConnectionStateListener: Lost connection to xmlBlaster");
    }

    public void reachedDead(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        this.log.error(ME, "DEBUG ONLY: Changed from connection state " + oldState + " to " + ConnectionStateEnum.DEAD);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new TestFailSafePing(null, "testFailSafe"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.err.println(ME + ": Init failed");
            System.exit(1);
        }
        TestFailSafePing testSub = new TestFailSafePing(glob, "TestFailSafePing");
        testSub.setUp();
        testSub.testFailSafe();
        testSub.tearDown();
    }
}

