/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.client;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.key.GetKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.GetQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.test.MsgInterceptor;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.property.PropString;
import org.xmlBlaster.util.qos.HistoryQos;
import org.xmlBlaster.util.qos.TopicProperty;
import org.xmlBlaster.util.qos.storage.HistoryQueueProperty;

public class TestHistoryZero
extends TestCase {
    private static String ME = "TestHistoryZero";
    private Global glob;
    private Global serverGlobal;
    private LogChannel log;
    private int serverPort = 7604;
    private EmbeddedXmlBlaster serverThread;
    private MsgInterceptor updateInterceptor;
    private String senderName;
    private final String contentMime = "text/plain";

    public TestHistoryZero(String testName) {
        this(null, testName);
    }

    public TestHistoryZero(Global glob, String testName) {
        super(testName);
        this.glob = glob;
        this.senderName = testName;
    }

    protected void setUp() {
        this.glob = this.glob == null ? Global.instance() : this.glob;
        this.log = this.glob.getLog("test");
        this.glob.init(Util.getOtherServerPorts(this.serverPort));
        String[] args = new String[]{"-queue/history/maxEntriesCache", "0", "-queue/history/maxEntries", "0"};
        this.serverGlobal = this.glob.getClone(args);
        this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.serverGlobal);
        this.log.info(ME, "XmlBlaster is ready for testing on bootstrapPort " + this.serverPort);
        try {
            I_XmlBlasterAccess con = this.glob.getXmlBlasterAccess();
            String passwd = "secret";
            ConnectQos connectQos = new ConnectQos(this.glob, this.senderName, passwd);
            connectQos.setPersistent(false);
            this.updateInterceptor = new MsgInterceptor(this.glob, this.log, null);
            con.connect(connectQos, this.updateInterceptor);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "setUp() - login failed: " + e.getMessage());
            Assert.fail("setUp() - login fail: " + e.getMessage());
        }
        catch (Exception e) {
            this.log.error(ME, "setUp() - login failed: " + e.toString());
            e.printStackTrace();
            Assert.fail("setUp() - login fail: " + e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void tearDown() {
        this.log.info(ME, "Entering tearDown(), test is finished");
        String xmlKey = "<key oid='' queryType='XPATH'>\n   //TestHistoryZero-AGENT</key>";
        String qos = "<qos><forceDestroy>true</forceDestroy></qos>";
        I_XmlBlasterAccess con = this.glob.getXmlBlasterAccess();
        try {
            try {
                EraseReturnQos[] arr = con.erase(xmlKey, qos);
                PropString defaultPlugin = new PropString("CACHE,1.0");
                String propName = defaultPlugin.setFromEnv(this.glob, this.glob.getStrippedId(), null, "persistence", "topicStore", "defaultPlugin");
                this.log.info(ME, "Lookup of propName=" + propName + " defaultValue=" + defaultPlugin.getValue());
            }
            catch (XmlBlasterException e) {
                this.log.error(ME, "XmlBlasterException: " + e.getMessage());
                Object var8_9 = null;
                con.disconnect(null);
                EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
                this.serverThread = null;
                Util.resetPorts(this.serverGlobal);
                Util.resetPorts(this.glob);
                this.glob = null;
                con = null;
                Global.instance().shutdown();
                return;
            }
            Object var8_8 = null;
            con.disconnect(null);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            con.disconnect(null);
            EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
            this.serverThread = null;
            Util.resetPorts(this.serverGlobal);
            Util.resetPorts(this.glob);
            this.glob = null;
            con = null;
            Global.instance().shutdown();
            throw throwable;
        }
        EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
        this.serverThread = null;
        Util.resetPorts(this.serverGlobal);
        Util.resetPorts(this.glob);
        this.glob = null;
        con = null;
        Global.instance().shutdown();
    }

    public void doPublish(String oid, int counter, long numHistory) throws XmlBlasterException {
        this.log.info(ME, "Publishing a message " + oid + " ...");
        String xmlKey = "<key oid='" + oid + "' contentMime='" + "text/plain" + "'>\n" + "   <TestHistoryZero-AGENT id='192.168.124.10' subId='1' type='generic'>" + "   </TestHistoryZero-AGENT>" + "</key>";
        String content = "" + counter;
        PublishQos qosWrapper = new PublishQos(this.glob);
        if (numHistory > -1L) {
            TopicProperty topicProp = new TopicProperty(this.glob);
            HistoryQueueProperty historyQueueProp = topicProp.getHistoryQueueProperty();
            historyQueueProp.setMaxEntries(numHistory);
            historyQueueProp.setMaxEntriesCache(numHistory);
            qosWrapper.setTopicProperty(topicProp);
        }
        MsgUnit msgUnit = new MsgUnit(xmlKey, content.getBytes(), qosWrapper.toXml());
        this.glob.getXmlBlasterAccess().publish(msgUnit);
        this.log.info(ME, "Success: Publishing of " + oid + " done");
    }

    private void doGet(String oid, int expect) {
        GetKey key = new GetKey(this.glob, oid);
        GetQos qos = new GetQos(this.glob);
        HistoryQos histQos = new HistoryQos(this.glob, 2);
        qos.setHistoryQos(histQos);
        try {
            MsgUnit[] msg = this.glob.getXmlBlasterAccess().get(key, qos);
            Assert.assertNotNull("should not be null", msg);
            Assert.assertEquals("the number of returned values is wrong", expect, msg.length);
        }
        catch (XmlBlasterException ex) {
            ex.printStackTrace();
            Assert.assertTrue("no exception should take place here", false);
        }
    }

    public void testHistoryZero() {
        int numPublish = 5;
        int i = 0;
        while (i < numPublish) {
            try {
                this.doPublish("historyZeroA", i + 1, -1L);
                this.doPublish("historyZeroB", i + 1, 0L);
                this.doPublish("historyZeroC", i + 1, 1L);
                this.doPublish("historyZeroD", i + 1, 2L);
                this.doPublish("historyZeroE", i + 1, 5L);
            }
            catch (XmlBlasterException ex) {
                ex.printStackTrace();
                Assert.assertTrue("an exception should not occur here", false);
            }
            ++i;
        }
        this.doGet("historyZeroA", 0);
        this.doGet("historyZeroB", 0);
        this.doGet("historyZeroC", 1);
        this.doGet("historyZeroD", 2);
        this.doGet("historyZeroE", 2);
        try {
            EraseKey eraseKey = new EraseKey(this.glob, "//TestHistoryZero-AGENT", "XPATH");
            EraseQos eraseQos = new EraseQos(this.glob);
            this.glob.getXmlBlasterAccess().erase(eraseKey, eraseQos);
        }
        catch (XmlBlasterException e) {
            e.printStackTrace();
            Assert.assertTrue("exception should not occur here " + e.getMessage(), false);
        }
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.out.println(ME + ": Init failed");
            System.exit(1);
        }
        TestHistoryZero test = new TestHistoryZero(glob, "TestHistoryZero/1");
        test.setUp();
        test.testHistoryZero();
        test.tearDown();
    }
}

