/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.client;

import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.j2ee.util.GlobalUtil;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class TestLocalProtocol
extends TestCase
implements I_Callback {
    private static String ME = "TestLocalProtocol";
    private final Global glob;
    private GlobalUtil globalUtil;
    private final LogChannel log;
    private I_XmlBlasterAccess con = null;
    private String name;
    private String passwd = "secret";
    private int numReceived = 0;
    private EmbeddedXmlBlaster serverThread;
    private int serverPort = 7624;
    private HashMap subscriberTable = new HashMap();
    private int[] subRec = new int[2];
    String subscribeOid;
    String subscribeOid2;

    public TestLocalProtocol() {
        this(null, "TestLocalProtocol", "TestLocalProtocol");
    }

    public TestLocalProtocol(Global glob, String testName, String name) {
        super(testName);
        this.glob = glob == null ? Global.instance() : glob;
        this.log = this.glob.getLog("test");
        this.name = name;
    }

    protected void setUp() {
        String[] args = new String[]{"-bootstrapPort", "" + this.serverPort, "-plugin/socket/port", "" + (this.serverPort - 1), "-plugin/rmi/registryPort", "" + (this.serverPort - 2), "-plugin/xmlrpc/port", "" + (this.serverPort - 3), "-ClientProtocolPlugin[LOCAL][1.0]", "org.xmlBlaster.client.protocol.local.LocalConnection", "-ClientCbServerProtocolPlugin[LOCAL][1.0]", "org.xmlBlaster.client.protocol.local.LocalCallbackImpl", "-CbProtocolPlugin[LOCAL][1.0]", "org.xmlBlaster.protocol.local.CallbackLocalDriver", "-protocol", "LOCAL", "-admin.remoteconsole.port", "0"};
        this.glob.init(args);
        this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(args);
        this.globalUtil = new GlobalUtil(this.serverThread.getMain().getGlobal());
        Global runglob = this.globalUtil.getClone(this.glob);
        this.log.info(ME, "XmlBlaster is ready for testing subscribe MIME filter");
        try {
            this.log.info(ME, "Connecting ...");
            this.con = runglob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(runglob, this.name, this.passwd);
            this.con.connect(qos, this);
        }
        catch (Exception e) {
            Thread.currentThread();
            Thread.dumpStack();
            this.log.error(ME, "Can't connect to xmlBlaster: " + e.toString());
        }
        try {
            String xmlKey = "<key oid='' queryType='XPATH'>\n//TestLocalProtocol-AGENT</key>";
            String qos = "<qos><notify>false</notify></qos>";
            this.subscribeOid = this.con.subscribe(xmlKey, qos).getSubscriptionId();
            this.log.info(ME, "Success: Subscribe on subscriptionId=" + this.subscribeOid + " done");
            Assert.assertTrue("returned null subscriptionId", this.subscribeOid != null);
            this.subscriberTable.put(this.subscribeOid, new Integer(0));
            xmlKey = "<key oid='' queryType='XPATH'>\n//TestLocalProtocol-AGENT[@id='3']</key>";
            this.subscribeOid2 = this.con.subscribe(xmlKey, qos).getSubscriptionId();
            this.log.info(ME, "Success: Subscribe on subscriptionId=" + this.subscribeOid2 + " done");
            Assert.assertTrue("returned null subscriptionId", this.subscribeOid2 != null);
            this.subscriberTable.put(this.subscribeOid2, new Integer(1));
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    protected void tearDown() {
        this.log.info(ME, "TEST: tearing down");
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        try {
            this.con.unSubscribe("<key oid='" + this.subscribeOid + "'/>", "<qos/>");
            this.con.unSubscribe("<key oid='" + this.subscribeOid2 + "'/>", "<qos/>");
            EraseReturnQos[] arr = this.con.erase("<key oid='' queryType='XPATH'>\n   /xmlBlaster/key/TestLocalProtocol-AGENT</key>", "<qos/>");
            Assert.assertEquals("Erase", 5, arr.length);
        }
        catch (XmlBlasterException e) {
            Assert.fail("Erase XmlBlasterException: " + e.getMessage());
        }
        this.con.disconnect(null);
        this.con = null;
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
        this.serverThread = null;
        Util.resetPorts();
    }

    public void testPublish() {
        this.log.info(ME, "testPublish...");
        this.log.info(ME, "TEST 1");
        try {
            int i = 0;
            while (i < 5) {
                String c = "<content>" + i + "</content>";
                String k = "<key oid='" + i + "' contentMime='text/xml'><TestLocalProtocol-AGENT id='" + i + "' type='generic'/></key>";
                this.log.info(ME, "Key: " + k);
                this.con.publish(new MsgUnit(k, c.getBytes(), null));
                ++i;
            }
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
        this.waitOnUpdate(this.subscribeOid, 10000L, 5);
        this.waitOnUpdate(this.subscribeOid2, 10000L, 1);
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.log.info(ME, "Receiving update of a message " + updateKey.getOid() + " for subId: " + updateQos.getSubscriptionId());
        int ii = (Integer)this.subscriberTable.get(updateQos.getSubscriptionId());
        this.log.trace(ME, "Got message " + new String(content));
        int n = ii;
        this.subRec[n] = this.subRec[n] + 1;
        ++this.numReceived;
        return "";
    }

    private void waitOnUpdate(String subId, long timeout, int numWait) {
        long pollingInterval = 50L;
        if (timeout < 50L) {
            pollingInterval = timeout / 10L;
        }
        long sum = 0L;
        int ii = (Integer)this.subscriberTable.get(subId);
        while (this.subRec[ii] < numWait) {
            try {
                Thread.currentThread();
                Thread.sleep(pollingInterval);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            Assert.assertTrue("Timeout of " + timeout + " occurred without update", (sum += pollingInterval) <= timeout);
        }
        try {
            Thread.currentThread();
            Thread.sleep(timeout);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assert.assertEquals("Wrong number of messages arrived", numWait, this.subRec[ii]);
        this.log.info(ME, "Found correct rec messages for: " + subId);
        this.subRec[ii] = 0;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "Tim";
        suite.addTest(new TestLocalProtocol(new Global(), "testPublish", "Tim"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.err.println(ME + ": Init failed");
            System.exit(1);
        }
        TestLocalProtocol testSub = new TestLocalProtocol(glob, "TestLocalProtocol", "Tim");
        testSub.setUp();
        try {
            testSub.testPublish();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        testSub.tearDown();
    }
}

