/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.client;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_ConnectionStateListener;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UnSubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.DisconnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UnSubscribeQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.test.MsgInterceptor;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.dispatch.ConnectionStateEnum;
import org.xmlBlaster.util.property.PropString;
import org.xmlBlaster.util.qos.address.Address;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public class TestPersistentSession
extends TestCase
implements I_ConnectionStateListener,
I_Callback {
    private static String ME = "TestPersistentSession";
    private static final boolean TRANSIENT = false;
    private static final boolean PERSISTENT = true;
    private Global glob;
    private Global origGlobal;
    private Global serverGlobal;
    private LogChannel log;
    private int serverPort = 7604;
    private EmbeddedXmlBlaster serverThread;
    private MsgInterceptor[] updateInterceptors;
    private String senderName;
    private int numPublish = 8;
    private int numStop = 3;
    private int numStart = 5;
    private final String contentMime = "text/plain";
    private final long reconnectDelay = 2000L;
    private boolean failsafeCallback = true;
    private boolean persistent = true;
    private boolean exactSubscription = false;
    private boolean initialUpdates = true;
    private int numSubscribers = 4;

    public TestPersistentSession(String testName) {
        this(null, testName);
    }

    public TestPersistentSession(Global glob, String testName) {
        super(testName);
        this.origGlobal = glob;
        this.senderName = testName;
        this.updateInterceptors = new MsgInterceptor[this.numSubscribers];
    }

    protected void setUp() {
        this.setup(false);
    }

    private void setup(boolean restrictedEntries) {
        this.origGlobal = this.origGlobal == null ? Global.instance() : this.origGlobal;
        this.log = this.origGlobal.getLog("test");
        this.origGlobal.init(Util.getOtherServerPorts(this.serverPort));
        this.glob = this.origGlobal.getClone(null);
        String[] args = null;
        if (restrictedEntries) {
            args = new String[]{"-persistence/session/maxEntriesCache", "1", "-persistence/session/maxEntries", "2", "-persistence/subscribe/maxEntriesCache", "2", "-persistence/subscribe/maxEntries", "3"};
        }
        this.serverGlobal = this.origGlobal.getClone(args);
        this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.serverGlobal);
        this.log.info(ME, "XmlBlaster is ready for testing on bootstrapPort " + this.serverPort);
        try {
            I_XmlBlasterAccess con = this.glob.getXmlBlasterAccess();
            String passwd = "secret";
            ConnectQos connectQos = new ConnectQos(this.glob, this.senderName, passwd);
            connectQos.setSessionName(new SessionName(this.glob, "general/1"));
            connectQos.setPersistent(this.persistent);
            Address addressProp = new Address(this.glob);
            addressProp.setDelay(2000L);
            addressProp.setRetries(-1);
            addressProp.setPingInterval(-1L);
            con.registerConnectionListener(this);
            connectQos.setAddress(addressProp);
            if (this.failsafeCallback) {
                CallbackAddress cbAddress = new CallbackAddress(this.glob);
                cbAddress.setRetries(-1);
                cbAddress.setPingInterval(-1L);
                cbAddress.setDelay(1000L);
                cbAddress.setSecretCbSessionId("someSecredSessionId");
                connectQos.addCallbackAddress(cbAddress);
            }
            con.connect(connectQos, this);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "setUp() - login failed: " + e.getMessage());
            Assert.fail("setUp() - login fail: " + e.getMessage());
        }
        catch (Exception e) {
            this.log.error(ME, "setUp() - login failed: " + e.toString());
            e.printStackTrace();
            Assert.fail("setUp() - login fail: " + e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void tearDown() {
        this.log.info(ME, "Entering tearDown(), test is finished");
        String xmlKey = "<key oid='' queryType='XPATH'>\n   //TestPersistentSession-AGENT</key>";
        String qos = "<qos><forceDestroy>true</forceDestroy></qos>";
        I_XmlBlasterAccess con = this.glob.getXmlBlasterAccess();
        try {
            try {
                EraseReturnQos[] arr = con.erase(xmlKey, qos);
                PropString defaultPlugin = new PropString("CACHE,1.0");
                String propName = defaultPlugin.setFromEnv(this.glob, this.glob.getStrippedId(), null, "persistence", "topicStore", "defaultPlugin");
                this.log.info(ME, "Lookup of propName=" + propName + " defaultValue=" + defaultPlugin.getValue());
            }
            catch (XmlBlasterException e) {
                this.log.error(ME, "XmlBlasterException: " + e.getMessage());
                Object var8_9 = null;
                con.disconnect(null);
                EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
                this.serverThread = null;
                Util.resetPorts(this.serverGlobal);
                Util.resetPorts(this.glob);
                Util.resetPorts(this.origGlobal);
                this.glob = null;
                this.serverGlobal = null;
                con = null;
                Global.instance().shutdown();
                return;
            }
            Object var8_8 = null;
            con.disconnect(null);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            con.disconnect(null);
            EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
            this.serverThread = null;
            Util.resetPorts(this.serverGlobal);
            Util.resetPorts(this.glob);
            Util.resetPorts(this.origGlobal);
            this.glob = null;
            this.serverGlobal = null;
            con = null;
            Global.instance().shutdown();
            throw throwable;
        }
        EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
        this.serverThread = null;
        Util.resetPorts(this.serverGlobal);
        Util.resetPorts(this.glob);
        Util.resetPorts(this.origGlobal);
        this.glob = null;
        this.serverGlobal = null;
        con = null;
        Global.instance().shutdown();
    }

    private void doSubscribe(int num, boolean isExact, boolean isPersistent) {
        try {
            SubscribeKey key = null;
            key = isExact ? new SubscribeKey(this.glob, "Message-1") : new SubscribeKey(this.glob, "//TestPersistentSession-AGENT", "XPATH");
            SubscribeQos qos = new SubscribeQos(this.glob);
            qos.setPersistent(isPersistent);
            qos.setWantInitialUpdate(this.initialUpdates);
            qos.setWantNotify(false);
            this.updateInterceptors[num] = new MsgInterceptor(this.glob, this.log, null);
            this.updateInterceptors[num].setLogPrefix("interceptor-" + num);
            SubscribeReturnQos subscriptionId = this.glob.getXmlBlasterAccess().subscribe(key, qos, (I_Callback)this.updateInterceptors[num]);
            this.log.info(ME, "Success: Subscribe on subscriptionId=" + subscriptionId.getSubscriptionId() + " done");
            Assert.assertTrue("returned null subscriptionId", subscriptionId != null);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    private void doUnSubscribe(int num, boolean isExact, boolean isPersistent) {
        try {
            UnSubscribeKey key = null;
            key = isExact ? new UnSubscribeKey(this.glob, "Message-1") : new UnSubscribeKey(this.glob, "//TestPersistentSession-AGENT", "XPATH");
            UnSubscribeQos qos = new UnSubscribeQos(this.glob);
            this.glob.getXmlBlasterAccess().unSubscribe(key, qos);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    public void doPublish(int counter) throws XmlBlasterException {
        String oid = "Message-" + counter;
        this.log.info(ME, "Publishing a message " + oid + " ...");
        String xmlKey = "<key oid='" + oid + "' contentMime='" + "text/plain" + "'>\n" + "   <TestPersistentSession-AGENT id='192.168.124.10' subId='1' type='generic'>" + "   </TestPersistentSession-AGENT>" + "</key>";
        String content = "" + counter;
        PublishQos qosWrapper = new PublishQos(this.glob);
        MsgUnit msgUnit = new MsgUnit(xmlKey, content.getBytes(), qosWrapper.toXml());
        this.glob.getXmlBlasterAccess().publish(msgUnit);
        this.log.info(ME, "Success: Publishing of " + oid + " done");
    }

    public void persistentSession(boolean doStop) {
        this.log.info(ME, "Going to publish " + this.numPublish + " messages, xmlBlaster will be down for message 3 and 4");
        this.doSubscribe(0, this.exactSubscription, false);
        this.doSubscribe(1, this.exactSubscription, true);
        int i = 0;
        while (i < this.numPublish) {
            try {
                int j;
                if (i == this.numStop) {
                    if (doStop) {
                        this.log.info(ME, "Stopping xmlBlaster, but continue with publishing ...");
                        EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
                        this.serverThread = null;
                    } else {
                        this.log.info(ME, "changing run level but continue with publishing ...");
                        this.serverThread.changeRunlevel(0, true);
                    }
                }
                if (i == this.numStart) {
                    if (doStop) {
                        this.log.info(ME, "Starting xmlBlaster again, expecting the previous published two messages ...");
                        this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.serverGlobal);
                        this.log.info(ME, "xmlBlaster started, waiting on tail back messsages");
                    } else {
                        this.log.info(ME, "changing runlevel again to runlevel 9. Expecting the previous published two messages ...");
                        this.serverThread.changeRunlevel(9, true);
                        this.log.info(ME, "xmlBlaster runlevel 9 reached, waiting on tail back messsages");
                    }
                    Assert.assertEquals("", 2, this.updateInterceptors[1].waitOnUpdate(4000L, 2));
                    Assert.assertEquals("", 2, this.updateInterceptors[3].waitOnUpdate(4000L, 2));
                    j = 0;
                    while (j < this.numSubscribers) {
                        this.updateInterceptors[j].clear();
                        ++j;
                    }
                }
                this.doPublish(i + 1);
                if (i == 0) {
                    this.doSubscribe(2, this.exactSubscription, false);
                    this.doSubscribe(3, this.exactSubscription, true);
                }
                if (i < this.numStop || i >= this.numStart) {
                    int n = 1;
                    if (i == 0 && !this.initialUpdates) {
                        n = 0;
                    }
                    Assert.assertEquals("Message nr. " + (i + 1), 1, this.updateInterceptors[1].waitOnUpdate(4000L, 1));
                    Assert.assertEquals("Message nr. " + (i + 1), n, this.updateInterceptors[3].waitOnUpdate(4000L, n));
                }
                j = 0;
                while (j < this.numSubscribers) {
                    this.updateInterceptors[j].clear();
                    ++j;
                }
            }
            catch (XmlBlasterException e) {
                if (e.getErrorCode() == ErrorCode.COMMUNICATION_NOCONNECTION_POLLING) {
                    this.log.warn(ME, "Lost connection, my connection layer is polling: " + e.getMessage());
                }
                if (e.getErrorCode() == ErrorCode.COMMUNICATION_NOCONNECTION_DEAD) {
                    Assert.assertTrue("Lost connection, my connection layer is NOT polling", false);
                }
                Assert.assertTrue("Publishing problems: " + e.getMessage(), false);
            }
            ++i;
        }
        this.doSubscribe(0, this.exactSubscription, false);
        this.doSubscribe(1, this.exactSubscription, true);
    }

    public void reachedAlive(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        this.log.info(ME, "I_ConnectionStateListener: We were lucky, reconnected to xmlBlaster");
    }

    public void reachedPolling(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        this.log.warn(ME, "DEBUG ONLY: Changed from connection state " + oldState + " to " + ConnectionStateEnum.POLLING);
    }

    public void reachedDead(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        this.log.error(ME, "DEBUG ONLY: Changed from connection state " + oldState + " to " + ConnectionStateEnum.DEAD);
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) throws XmlBlasterException {
        String contentStr = new String(content);
        String cont = contentStr.length() > 10 ? contentStr.substring(0, 10) + "..." : contentStr;
        this.log.info(ME, "Receiving update of a message oid=" + updateKey.getOid() + " priority=" + updateQos.getPriority() + " state=" + updateQos.getState() + " content=" + cont);
        this.log.info(ME, "further log for receiving update of a message cbSessionId=" + cbSessionId + updateKey.toXml() + "\n" + new String(content) + updateQos.toXml());
        this.log.error(ME, "update: should never be invoked (msgInterceptors take care of it since they are passed on subscriptions)");
        return "OK";
    }

    public void testXPathInitialStop() {
        this.exactSubscription = false;
        this.initialUpdates = true;
        this.persistentSession(true);
    }

    public void testXPathNoInitialStop() {
        this.exactSubscription = false;
        this.initialUpdates = false;
        this.persistentSession(true);
    }

    public void testXPathInitialRunlevelChange() {
        this.persistent = true;
        this.exactSubscription = false;
        this.initialUpdates = true;
        this.persistentSession(false);
    }

    private Global createConnection(Global parentGlobal, String sessionName, boolean isPersistent, boolean expectEx) {
        try {
            Global ret = parentGlobal.getClone(null);
            I_XmlBlasterAccess con = ret.getXmlBlasterAccess();
            String passwd = "secret";
            ConnectQos connectQos = new ConnectQos(this.glob);
            connectQos.setSessionName(new SessionName(ret, sessionName));
            connectQos.setPersistent(isPersistent);
            Address addressProp = new Address(this.glob);
            addressProp.setDelay(2000L);
            addressProp.setRetries(-1);
            addressProp.setPingInterval(-1L);
            connectQos.setAddress(addressProp);
            if (this.failsafeCallback) {
                CallbackAddress cbAddress = new CallbackAddress(this.glob);
                cbAddress.setRetries(-1);
                cbAddress.setPingInterval(-1L);
                cbAddress.setDelay(1000L);
                connectQos.addCallbackAddress(cbAddress);
            }
            con.connect(connectQos, this);
            if (expectEx) {
                Assert.assertTrue("an exception was expected here because of overflow: Configuration of session queue probably not working", false);
            }
            return ret;
        }
        catch (XmlBlasterException ex) {
            if (expectEx) {
                this.log.info(ME, "createConnection: exception was OK since overflow was expected");
            } else {
                Assert.assertTrue("an exception should not occur here", false);
            }
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void testOverflow() {
        block4: {
            this.tearDown();
            this.setup(true);
            globals = new Global[5];
            try {
                globals[0] = this.createConnection(this.origGlobal, "bjoern/1", true, false);
                globals[1] = this.createConnection(this.origGlobal, "fritz/2", false, false);
                globals[3] = this.createConnection(this.origGlobal, "dimitri/3", true, true);
                globals[2] = this.createConnection(this.origGlobal, "pandora/4", false, false);
                globals[4] = this.createConnection(this.origGlobal, "jonny/5", true, true);
                var3_2 = null;
                i = 0;
                ** while (i < 3)
            }
            catch (Throwable var2_6) {
                var3_3 = null;
                i = 0;
                ** while (i < 3)
            }
lbl-1000:
            // 1 sources

            {
                globals[i].getXmlBlasterAccess().disconnect(new DisconnectQos(globals[i]));
                ++i;
                continue;
lbl18:
                // 1 sources

                break block4;
            }
lbl-1000:
            // 1 sources

            {
                globals[i].getXmlBlasterAccess().disconnect(new DisconnectQos(globals[i]));
                ++i;
                continue;
            }
lbl28:
            // 1 sources

            throw var2_6;
        }
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.out.println(ME + ": Init failed");
            System.exit(1);
        }
        TestPersistentSession testSub = new TestPersistentSession(glob, "TestPersistentSession/1");
        testSub.setUp();
        testSub.testXPathInitialStop();
        testSub.tearDown();
        testSub.setUp();
        testSub.testXPathNoInitialStop();
        testSub.tearDown();
        testSub.setUp();
        testSub.testXPathInitialRunlevelChange();
        testSub.tearDown();
        testSub.setUp();
        testSub.testOverflow();
        testSub.tearDown();
    }
}

