/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.client;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.test.util.PtPDestination;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.address.Destination;

public class TestPtPDispatch
extends TestCase {
    private static String ME = "TestPtPDispatch";
    private static final long TIMEOUT = 5000L;
    private Global glob;
    private LogChannel log;
    private PtPDestination[] destinations;
    private int numDestinations = 4;
    private int counter = 0;
    private String subjectName;

    public TestPtPDispatch(String testName) {
        this(null, testName);
    }

    public TestPtPDispatch(Global glob, String testName) {
        super(testName);
        this.glob = glob;
        this.subjectName = testName;
    }

    protected void setUp() {
        this.glob = this.glob == null ? Global.instance() : this.glob;
        this.log = this.glob.getLog("test");
        this.destinations = new PtPDestination[this.numDestinations];
        int i = 0;
        while (i < this.numDestinations) {
            this.destinations[i] = new PtPDestination(this.glob, this.subjectName + "/" + (i + 1));
            ++i;
        }
        this.log.info(ME, "XmlBlaster is ready for testing");
        try {
            I_XmlBlasterAccess con = this.glob.getXmlBlasterAccess();
            String passwd = "secret";
            ConnectQos connectQos = new ConnectQos(this.glob, "src_" + this.subjectName, passwd);
            if (this.log.TRACE) {
                this.log.trace(ME, "setUp: connectQos '" + connectQos.toXml() + "'");
            }
            con.connect(connectQos, null);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "setUp() - login failed: " + e.getMessage());
            Assert.fail("setUp() - login fail: " + e.getMessage());
        }
        catch (Exception e) {
            this.log.error(ME, "setUp() - login failed: " + e.toString());
            e.printStackTrace();
            Assert.fail("setUp() - login fail: " + e.toString());
        }
    }

    private void prepare(boolean shutdownCb) {
        try {
            this.destinations[0].init(true, shutdownCb, 1L, 1L, 3L, 1L);
            this.destinations[1].init(false, shutdownCb, 1L, 1L, 3L, 1L);
        }
        catch (XmlBlasterException ex) {
            ex.printStackTrace();
            Assert.assertTrue(false);
        }
    }

    private void cleanup() {
        int i = 0;
        while (i < this.numDestinations - 2) {
            this.destinations[i].shutdown(true);
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void tearDown() {
        this.log.info(ME, "Entering tearDown(), test is finished");
        I_XmlBlasterAccess con = this.glob.getXmlBlasterAccess();
        try {
            try {
                EraseKey key = new EraseKey(this.glob, "testPtPDispatch");
                EraseQos qos = new EraseQos(this.glob);
                con.erase(key, qos);
            }
            catch (XmlBlasterException ex) {
                ex.printStackTrace();
                Object var5_6 = null;
                con.disconnect(null);
                this.glob.shutdown();
                this.glob = null;
                return;
            }
            Object var5_5 = null;
            con.disconnect(null);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            con.disconnect(null);
            this.glob.shutdown();
            this.glob = null;
            throw throwable;
        }
        this.glob.shutdown();
        this.glob = null;
    }

    private void doPublish(int destNum, boolean forceQueuing, boolean expectEx, int[] counts, long timeout, boolean persistent, String contentPrefix) {
        SessionName toSessionName = null;
        toSessionName = destNum < 0 ? new SessionName(this.glob, this.subjectName) : this.destinations[destNum].getSessionName();
        this.log.info(ME, "Publishing a message " + toSessionName.getRelativeName() + " ...");
        PublishKey key = new PublishKey(this.glob, "testPtPDispatch");
        Destination destination = new Destination(this.glob, toSessionName);
        destination.forceQueuing(forceQueuing);
        PublishQos qos = new PublishQos(this.glob, destination);
        qos.setPersistent(persistent);
        String content = contentPrefix + "-" + this.counter;
        ++this.counter;
        MsgUnit msgUnit = new MsgUnit(key, content.getBytes(), qos);
        try {
            this.glob.getXmlBlasterAccess().publish(msgUnit);
            Assert.assertTrue("did expect an exception after publishing to " + toSessionName.getRelativeName() + " here but got none", !expectEx);
        }
        catch (XmlBlasterException ex) {
            if (!expectEx) {
                ex.printStackTrace();
            }
            Assert.assertTrue("did'nt expect an exception after publishing to " + toSessionName.getRelativeName() + " here but got one: " + ex.getMessage(), expectEx);
        }
        this.log.info(ME, "Success: Publishing of message for " + toSessionName.getRelativeName() + " done");
        int i = 0;
        while (i < this.destinations.length) {
            this.destinations[i].check(timeout, counts[i]);
            ++i;
        }
    }

    private void checkWithReconnect(int dest, boolean wantsPtP, int expected, long delay) {
        try {
            this.destinations[dest].shutdown(false);
            String sessionName = this.destinations[dest].getSessionName().getRelativeName();
            this.destinations[dest] = new PtPDestination(this.glob, sessionName);
            this.destinations[dest].init(wantsPtP, false, 1L, 1L, 3L, 1L);
            this.destinations[dest].check(delay, expected);
        }
        catch (XmlBlasterException ex) {
            ex.printStackTrace();
            Assert.assertTrue(false);
        }
    }

    private void checkWithoutPublish(PtPDestination dest, boolean wantsPtP, int expected, long delay) {
        try {
            dest.init(wantsPtP, false, 1L, 1L, 3L, 1L);
            dest.check(delay, expected);
            dest.shutdown(true);
        }
        catch (XmlBlasterException ex) {
            ex.printStackTrace();
            Assert.assertTrue(false);
        }
    }

    private void noQueuingNoOverflow(boolean isPersistent, String msgPrefix) {
        boolean forceQueuing = false;
        boolean shutdownCb = false;
        this.prepare(shutdownCb);
        this.doPublish(-1, forceQueuing, false, new int[]{1, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(0, forceQueuing, false, new int[]{1, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(1, forceQueuing, true, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(2, forceQueuing, true, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(3, forceQueuing, true, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.checkWithoutPublish(this.destinations[2], true, 0, 5000L);
        this.checkWithoutPublish(this.destinations[3], false, 0, 5000L);
        this.cleanup();
    }

    public void testNoQueuingNoOverflowTransient() {
        this.noQueuingNoOverflow(false, "NoQueuingNoOverflowTransient");
    }

    public void testNoQueuingNoOverflowPersistent() {
        this.noQueuingNoOverflow(true, "NoQueuingNoOverflowPersistent");
    }

    private void noQueuingOverflow(boolean isPersistent, String msgPrefix) {
        boolean forceQueuing = false;
        boolean shutdownCb = true;
        this.prepare(shutdownCb);
        this.doPublish(0, forceQueuing, false, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(0, forceQueuing, false, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(0, forceQueuing, true, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(0, forceQueuing, true, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(1, forceQueuing, true, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(1, forceQueuing, true, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(1, forceQueuing, true, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(1, forceQueuing, true, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(2, forceQueuing, true, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(2, forceQueuing, true, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(2, forceQueuing, true, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(2, forceQueuing, true, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.cleanup();
    }

    public void testNoQueuingOverflowTransient() {
        this.noQueuingOverflow(false, "NoQueuingOverflowTransient");
    }

    public void testNoQueuingOverflowPersistent() {
        this.noQueuingOverflow(true, "NoQueuingOverflowPersistent");
    }

    private void queuingNoOverflow(boolean isPersistent, String msgPrefix) {
        boolean forceQueuing = true;
        boolean shutdownCb = false;
        this.prepare(shutdownCb);
        this.doPublish(-1, forceQueuing, false, new int[]{1, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(0, forceQueuing, false, new int[]{1, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(1, forceQueuing, true, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(2, forceQueuing, false, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(3, forceQueuing, false, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.checkWithoutPublish(this.destinations[2], true, 1, 5000L);
        this.checkWithoutPublish(this.destinations[3], false, 0, 5000L);
        this.cleanup();
    }

    public void testQueuingNoOverflowTransient() {
        this.queuingNoOverflow(false, "QueuingNoOverflowTransient");
    }

    public void testQueuingNoOverflowPersistent() {
        this.queuingNoOverflow(true, "QueuingNoOverflowPersistent");
    }

    private void queuingOverflow(boolean isPersistent, String msgPrefix) {
        boolean forceQueuing = true;
        boolean shutdownCb = true;
        this.prepare(shutdownCb);
        this.doPublish(0, forceQueuing, false, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(0, forceQueuing, false, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(0, forceQueuing, true, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(0, forceQueuing, true, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(1, forceQueuing, true, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(1, forceQueuing, true, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(1, forceQueuing, true, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(1, forceQueuing, true, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.checkWithReconnect(0, true, 2, 5000L);
        this.cleanup();
    }

    public void testQueuingOverflowTransient() {
        this.queuingOverflow(false, "QueuingOverflowTransient");
    }

    public void testQueuingOverflowPersistent() {
        this.queuingOverflow(true, "QueuingOverflowPersistent");
    }

    private void subjectQueueNoOverflow(boolean isPersistent, String msgPrefix) {
        boolean forceQueuing = false;
        boolean shutdownCb = false;
        this.prepare(shutdownCb);
        this.doPublish(-1, forceQueuing, false, new int[]{1, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(-1, forceQueuing, false, new int[]{1, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.cleanup();
    }

    public void testSubjectQueueNoOverflowTransient() {
        this.subjectQueueNoOverflow(false, "SubjectQueueNoOverflowTransient");
    }

    public void testSubjectQueueNoOverflowPersistent() {
        this.subjectQueueNoOverflow(true, "SubjectQueueNoOverflowPersistent");
    }

    private void subjectQueueOverflow(boolean isPersistent, String msgPrefix) {
        boolean shutdownCb = true;
        this.prepare(shutdownCb);
        boolean forceQueuing = false;
        this.doPublish(-1, forceQueuing, true, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        forceQueuing = true;
        this.doPublish(-1, forceQueuing, false, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(-1, forceQueuing, false, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(-1, forceQueuing, false, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(-1, forceQueuing, false, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(-1, forceQueuing, true, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.doPublish(-1, forceQueuing, true, new int[]{0, 0, 0, 0}, 5000L, isPersistent, msgPrefix);
        this.cleanup();
    }

    public void testSubjectQueueOverflowTransient() {
        this.subjectQueueNoOverflow(false, "SubjectQueueNoOverflowTransient");
    }

    public void testSubjectQueueOverflowPersistent() {
        this.subjectQueueNoOverflow(true, "SubjectQueueNoOverflowPersistent");
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.out.println(ME + ": Init failed");
            System.exit(1);
        }
        TestPtPDispatch testSub = new TestPtPDispatch(glob, "TestPtPDispatch");
        testSub.setUp();
        testSub.testNoQueuingNoOverflowPersistent();
        testSub.tearDown();
        testSub.setUp();
        testSub.testNoQueuingNoOverflowTransient();
        testSub.tearDown();
        testSub.setUp();
        testSub.testQueuingNoOverflowPersistent();
        testSub.tearDown();
        testSub.setUp();
        testSub.testQueuingNoOverflowTransient();
        testSub.tearDown();
        testSub.setUp();
        testSub.testNoQueuingOverflowPersistent();
        testSub.tearDown();
        testSub.setUp();
        testSub.testNoQueuingOverflowTransient();
        testSub.tearDown();
        testSub.setUp();
        testSub.testQueuingOverflowPersistent();
        testSub.tearDown();
        testSub.setUp();
        testSub.testQueuingOverflowTransient();
        testSub.tearDown();
        testSub.setUp();
        testSub.testSubjectQueueNoOverflowPersistent();
        testSub.tearDown();
        testSub.setUp();
        testSub.testSubjectQueueNoOverflowTransient();
        testSub.tearDown();
        testSub.setUp();
        testSub.testSubjectQueueOverflowPersistent();
        testSub.tearDown();
        testSub.setUp();
        testSub.testSubjectQueueOverflowTransient();
        testSub.tearDown();
    }
}

