/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.client;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.key.GetKey;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.client.qos.GetQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.test.Msg;
import org.xmlBlaster.test.MsgInterceptor;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.test.util.PtPDestination;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.property.PropString;
import org.xmlBlaster.util.qos.address.Address;
import org.xmlBlaster.util.qos.address.Destination;

public class TestPtPPersistent
extends TestCase {
    private static String ME = "TestPtPPersistent";
    private static final long PUB_DELAY = 250L;
    private Global glob;
    private LogChannel log;
    private int serverPort = 7604;
    private EmbeddedXmlBlaster serverThread;
    private MsgInterceptor updateInterceptor;
    private String senderName;
    private final long reconnectDelay = 500L;
    private PtPDestination destination;

    public TestPtPPersistent(String testName) {
        this(null, testName);
    }

    public TestPtPPersistent(Global glob, String testName) {
        super(testName);
        this.glob = glob;
        this.senderName = testName;
    }

    protected void setUp() {
        this.glob = this.glob == null ? Global.instance() : this.glob;
        this.log = this.glob.getLog("test");
        this.glob.init(Util.getOtherServerPorts(this.serverPort));
        this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.glob);
        this.log.info(ME, "XmlBlaster is ready for testing on bootstrapPort " + this.serverPort);
        try {
            I_XmlBlasterAccess con = this.glob.getXmlBlasterAccess();
            String passwd = "secret";
            ConnectQos connectQos = new ConnectQos(this.glob, this.senderName, passwd);
            Address addressProp = new Address(this.glob);
            addressProp.setDelay(500L);
            addressProp.setRetries(-1);
            addressProp.setPingInterval(500L);
            connectQos.setAddress(addressProp);
            con.connect(connectQos, null);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "setUp() - login failed: " + e.getMessage());
            Assert.fail("setUp() - login fail: " + e.getMessage());
        }
        catch (Exception e) {
            this.log.error(ME, "setUp() - login failed: " + e.toString());
            e.printStackTrace();
            Assert.fail("setUp() - login fail: " + e.toString());
        }
    }

    /*
     * Loose catch block
     */
    protected void tearDown() {
        block9: {
            I_XmlBlasterAccess con = this.glob.getXmlBlasterAccess();
            this.log.info(ME, "Entering tearDown(), test is finished");
            PropString defaultPlugin = new PropString("CACHE,1.0");
            String propName = defaultPlugin.setFromEnv(this.glob, this.glob.getStrippedId(), null, "persistence", "topicStore", "defaultPlugin");
            this.log.info(ME, "Lookup of propName=" + propName + " defaultValue=" + defaultPlugin.getValue());
            EraseKey eraseKey = new EraseKey(this.glob, "//airport", "XPATH");
            EraseQos eraseQos = new EraseQos(this.glob);
            con.erase(eraseKey, eraseQos);
            Object var7_7 = null;
            con.disconnect(null);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ex2) {
                // empty catch block
            }
            EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
            this.serverThread = null;
            Util.resetPorts(this.glob);
            this.glob = null;
            con = null;
            Global.instance().shutdown();
            {
                break block9;
                catch (XmlBlasterException ex) {
                    ex.printStackTrace();
                    Object var7_8 = null;
                    con.disconnect(null);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                    EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
                    this.serverThread = null;
                    Util.resetPorts(this.glob);
                    this.glob = null;
                    con = null;
                    Global.instance().shutdown();
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                con.disconnect(null);
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
                this.serverThread = null;
                Util.resetPorts(this.glob);
                this.glob = null;
                con = null;
                Global.instance().shutdown();
                throw throwable;
            }
        }
    }

    public void doPublish(int counter, String oid, boolean doGc, long sleep) throws XmlBlasterException {
        String content = "" + counter;
        this.log.info(ME, "Publishing message " + content);
        PublishKey key = new PublishKey(this.glob);
        if (oid != null) {
            key.setOid(oid);
        }
        key.setClientTags("<airport/>");
        PublishQos qos = new PublishQos(this.glob);
        qos.setPersistent(true);
        qos.setVolatile(true);
        qos.addDestination(new Destination(new SessionName(this.glob, "joe")));
        MsgUnit msgUnit = new MsgUnit(key, content, qos);
        this.glob.getXmlBlasterAccess().publish(msgUnit);
        if (doGc) {
            Util.gc(2);
        }
        try {
            Thread.sleep(sleep);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.log.info(ME, "Success: Publishing of " + content + " done");
    }

    public void testPersistentPtPOneOidWithGc() {
        this.persistentPtP("persistentPtP", true);
    }

    public void testPersistentPtPOneOidNoGc() {
        this.persistentPtP("persistentPtP", false);
    }

    public void testPersistentPtPNoOidWithGc() {
        this.persistentPtP(null, true);
    }

    public void testPersistentPtPNoOidNoGc() {
        this.persistentPtP(null, false);
    }

    public void persistentPtP(String oid, boolean doGc) {
        long cbMaxEntries = 3L;
        long cbMaxEntriesCache = 2L;
        long subjMaxEntries = 3L;
        long subjMaxEntriesCache = 2L;
        long exLimit = cbMaxEntries + subjMaxEntries + 2L;
        this.destination = new PtPDestination(this.glob, "joe/1");
        boolean wantsPtP = true;
        boolean shutdownCB = false;
        try {
            this.destination.init(wantsPtP, shutdownCB, cbMaxEntries, cbMaxEntriesCache, subjMaxEntries, subjMaxEntriesCache);
        }
        catch (XmlBlasterException ex) {
            Assert.assertTrue("an exception while initing the destination should not occur " + ex.getMessage(), false);
        }
        int i = 0;
        while ((long)i < exLimit) {
            try {
                this.doPublish(i, oid, doGc, 250L);
            }
            catch (Exception ex) {
                Assert.assertTrue("an exception on publish '" + i + "' should not occur " + ex.getMessage(), false);
            }
            ++i;
        }
        int ret = this.destination.getUpdateInterceptor().waitOnUpdate(300L * exLimit, (int)exLimit);
        Assert.assertEquals("wrong number of entries arrived", (int)exLimit, ret);
        ret = this.destination.getUpdateInterceptor().waitOnUpdate(500L, (int)exLimit + 1);
        Assert.assertEquals("wrong number of entries arrived", (int)exLimit, ret);
        Msg[] msg = this.destination.getUpdateInterceptor().getMsgs();
        Assert.assertEquals("wrong number of messages", exLimit, (long)msg.length);
        int i2 = 0;
        while ((long)i2 < exLimit) {
            Assert.assertEquals("wrong message sequence at ", i2, msg[i2].getContentInt());
            ++i2;
        }
        this.destination.getUpdateInterceptor().clear();
        this.destination.getConnection().leaveServer(null);
        long i3 = exLimit;
        while (i3 < 2L * exLimit) {
            try {
                this.doPublish((int)i3, oid, doGc, 250L);
            }
            catch (XmlBlasterException ex) {
                Assert.assertTrue("an exception on publish '" + i3 + "' should not occur " + ex.getMessage(), false);
            }
            ++i3;
        }
        this.destination.check(250L, 0);
        long i4 = 2L * exLimit;
        while (i4 < 2L * exLimit + 2L) {
            try {
                this.doPublish((int)i4, oid, doGc, 250L);
                Assert.assertTrue("an exception on publish '" + i4 + "' should have occurred ", false);
            }
            catch (XmlBlasterException ex) {
                this.log.info(ME, "this is an allowed exception since queues are overflown");
            }
            ++i4;
        }
        this.destination.check(250L, 0);
        EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
        this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.serverPort);
        this.destination = new PtPDestination(this.glob, "joe/1");
        try {
            this.destination.init(true, false, cbMaxEntries, cbMaxEntriesCache, subjMaxEntries, subjMaxEntriesCache);
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            Assert.assertTrue("an exception while initing the destination should not occur " + ex.getMessage(), false);
        }
        long i5 = 2L * exLimit;
        while (i5 < 3L * exLimit) {
            try {
                this.doPublish((int)i5, oid, doGc, 250L);
            }
            catch (Exception ex) {
                Assert.assertTrue("an exception on publish '" + i5 + "' should not occur " + ex.getMessage(), false);
            }
            ++i5;
        }
        ret = this.destination.getUpdateInterceptor().waitOnUpdate(3000L * exLimit, (int)(2L * exLimit));
        Assert.assertEquals("wrong number of messages arrived", 2L * exLimit, (long)ret);
        ret = this.destination.getUpdateInterceptor().waitOnUpdate(1000L, (int)(2L * exLimit));
        Assert.assertEquals("wrong number of messages arrived", (int)(2L * exLimit), ret);
        msg = this.destination.getUpdateInterceptor().getMsgs();
        if (oid != null) {
            int i6 = 0;
            while (i6 < msg.length) {
                Assert.assertEquals("wrong message sequence (number of entries arrived: " + msg.length + ") ", i6 + (int)exLimit, msg[i6].getContentInt());
                ++i6;
            }
        }
        if ((long)msg.length != exLimit * 2L) {
            try {
                GetKey getKey = new GetKey(this.glob, "__cmd?dump");
                GetQos getQos = new GetQos(this.glob);
                MsgUnit[] tmp = this.glob.getXmlBlasterAccess().get(getKey, getQos);
                if (tmp.length > 0) {
                    this.log.info(ME, tmp[0].getContentStr());
                }
            }
            catch (XmlBlasterException ex) {
                ex.printStackTrace();
            }
        }
        Assert.assertEquals("wrong number of entries arrived", exLimit * 2L, (long)msg.length);
        this.destination.getUpdateInterceptor().clear();
        this.destination.shutdown(true);
        this.destination = null;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.out.println(ME + ": Init failed");
            System.exit(1);
        }
        TestPtPPersistent test = new TestPtPPersistent(glob, "TestPtPPersistent/1");
        test.setUp();
        test.testPersistentPtPOneOidWithGc();
        test.tearDown();
        test.setUp();
        test.testPersistentPtPOneOidNoGc();
        test.tearDown();
        test.setUp();
        test.testPersistentPtPNoOidWithGc();
        test.tearDown();
        test.setUp();
        test.testPersistentPtPNoOidNoGc();
        test.tearDown();
    }
}

