/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.client;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.SynchronousCache;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.key.GetKey;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.GetQos;
import org.xmlBlaster.client.qos.GetReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.test.MsgInterceptor;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class TestSynchronousCache
extends TestCase {
    private String ME = "TestSynchronousCache";
    private Global glob;
    private LogChannel log;
    private I_XmlBlasterAccess con = null;
    private MsgInterceptor updateInterceptor;
    private EmbeddedXmlBlaster serverThread;
    private int serverPort = 34576;
    private boolean startEmbedded = true;
    private SynchronousCache synchronousCache;
    private String[] publishOidArr = new String[]{"oid-0", "oid-1", "xx-oid-2"};
    private String[] contentArr = new String[]{"content-oid-0", "content-oid-1", "content-oid-2"};
    private int numReceived = 0;

    public TestSynchronousCache(Global glob, String testName) {
        super(testName);
        this.glob = glob;
        this.log = this.glob.getLog("test");
    }

    protected void setUp() {
        this.startEmbedded = this.glob.getProperty().get("startEmbedded", this.startEmbedded);
        if (this.startEmbedded) {
            this.glob.init(Util.getOtherServerPorts(this.serverPort));
            String[] args = new String[]{};
            this.glob.init(args);
            this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.glob);
            this.log.info(this.ME, "XmlBlaster is ready for testing the client cache");
        }
        try {
            this.con = this.glob.getXmlBlasterAccess();
            this.synchronousCache = this.con.createSynchronousCache(100);
            ConnectQos connectQos = new ConnectQos(this.glob);
            this.updateInterceptor = new MsgInterceptor(this.glob, this.log, null);
            this.con.connect(connectQos, this.updateInterceptor);
        }
        catch (Exception e) {
            this.log.error(this.ME, e.toString());
            e.printStackTrace();
        }
    }

    protected void tearDown() {
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        int i = 0;
        while (i < this.publishOidArr.length) {
            EraseReturnQos[] arr = this.sendErase(this.publishOidArr[i]);
            ++i;
        }
        this.con.disconnect(null);
        this.con = null;
        if (this.startEmbedded) {
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
            this.serverThread = null;
        }
        Util.resetPorts(this.glob);
        this.glob = null;
        this.log = null;
        this.updateInterceptor = null;
        this.synchronousCache = null;
    }

    public EraseReturnQos[] sendErase(String publishOid) {
        this.log.info(this.ME, "Erasing topic '" + publishOid + "'");
        try {
            EraseQos eq = new EraseQos(this.glob);
            eq.setForceDestroy(false);
            EraseKey ek = new EraseKey(this.glob, publishOid);
            EraseReturnQos[] er = this.con.erase(ek, eq);
            try {
                Thread.currentThread();
                Thread.sleep(200L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            return er;
        }
        catch (XmlBlasterException e) {
            Assert.fail("Erase XmlBlasterException: " + e.getMessage());
            return null;
        }
    }

    public PublishReturnQos publishMsg(String publishOid, String content) {
        this.log.info(this.ME, "Sending a message '" + content + "'");
        try {
            PublishKey pk = new PublishKey(this.glob, publishOid, "text/xml", "1.0");
            PublishQos pq = new PublishQos(this.glob);
            MsgUnit msgUnit = new MsgUnit(pk, content, pq);
            PublishReturnQos publishReturnQos = this.con.publish(msgUnit);
            Assert.assertEquals("Retunred oid is invalid", publishOid, publishReturnQos.getKeyOid());
            this.log.info(this.ME, "Sending of '" + content + "' done, returned oid=" + publishOid + " " + msgUnit.toXml());
            return publishReturnQos;
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "publish() XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
            return null;
        }
    }

    public void testCachedAccess() {
        this.ME = "TestSynchronousCache-testCachedAccess";
        this.log.info(this.ME, "Entering testCachedAccess ...");
        try {
            this.publishMsg(this.publishOidArr[0], this.contentArr[0]);
            this.publishMsg(this.publishOidArr[2], this.contentArr[2]);
            try {
                Thread.currentThread();
                Thread.sleep(200L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            GetKey gk = new GetKey(this.glob, this.publishOidArr[0]);
            GetQos gq = new GetQos(this.glob);
            int i = 0;
            while (i < 10) {
                MsgUnit[] msgs = this.con.getCached(gk, gq);
                Assert.assertEquals(this.synchronousCache.toXml(""), 1, msgs.length);
                GetReturnQos grq = new GetReturnQos(this.glob, msgs[0].getQos());
                Assert.assertEquals("", 1, this.synchronousCache.getNumQueriesCached());
                this.log.info("", "Accessed xmlBlaster message with content '" + new String(msgs[0].getContent()) + "' and status=" + grq.getState());
                ++i;
            }
            EraseReturnQos[] arr0 = this.sendErase(this.publishOidArr[0]);
            Assert.assertEquals("", 0, this.synchronousCache.getNumQueriesCached());
            EraseReturnQos[] arr2 = this.sendErase(this.publishOidArr[2]);
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "testCachedAccess() failed: " + e.getMessage());
            Assert.fail(e.getMessage());
        }
        Assert.assertEquals("Unexpected update arrived", 0, this.updateInterceptor.waitOnUpdate(1000L, 0));
        this.log.info(this.ME, "Entering testCachedAccess with updated MsgUnit ...");
        try {
            PublishReturnQos publishReturnQos = this.publishMsg(this.publishOidArr[0], this.contentArr[0]);
            GetKey gk = new GetKey(this.glob, this.publishOidArr[0]);
            GetQos gq = new GetQos(this.glob);
            int i = 0;
            while (i < 5) {
                MsgUnit[] msgs = this.con.getCached(gk, gq);
                GetReturnQos grq = new GetReturnQos(this.glob, msgs[0].getQos());
                Assert.assertEquals(this.synchronousCache.toXml(""), 1, msgs.length);
                Assert.assertEquals("", 1, this.synchronousCache.getNumQueriesCached());
                Assert.assertEquals("", publishReturnQos.getRcvTimestamp(), grq.getRcvTimestamp());
                Assert.assertEquals("", this.contentArr[0], msgs[0].getContentStr());
                this.log.info("", "Accessed xmlBlaster message with content '" + new String(msgs[0].getContent()) + "' and status=" + grq.getState() + " rcv=" + grq.getRcvTimestamp());
                ++i;
            }
            String contentNew = this.contentArr[0] + "-NEW";
            publishReturnQos = this.publishMsg(this.publishOidArr[0], contentNew);
            try {
                Thread.currentThread();
                Thread.sleep(200L);
            }
            catch (InterruptedException i2) {
                // empty catch block
            }
            int i3 = 0;
            while (i3 < 5) {
                MsgUnit[] msgs = this.con.getCached(gk, gq);
                GetReturnQos grq = new GetReturnQos(this.glob, msgs[0].getQos());
                Assert.assertEquals(this.synchronousCache.toXml(""), 1, msgs.length);
                Assert.assertEquals("", 1, this.synchronousCache.getNumQueriesCached());
                Assert.assertEquals("", publishReturnQos.getRcvTimestamp().getTimestamp(), grq.getRcvTimestamp().getTimestamp());
                Assert.assertEquals("", publishReturnQos.getKeyOid(), msgs[0].getKeyOid());
                Assert.assertEquals("", contentNew, msgs[0].getContentStr());
                this.log.info("", "Accessed xmlBlaster message with content '" + new String(msgs[0].getContent()) + "' and status=" + grq.getState() + " rcv=" + grq.getRcvTimestamp());
                ++i3;
            }
            EraseReturnQos[] arr0 = this.sendErase(this.publishOidArr[0]);
            Assert.assertEquals("", 0, this.synchronousCache.getNumQueriesCached());
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "testCachedAccess() failed: " + e.getMessage());
            Assert.fail(e.getMessage());
        }
        Assert.assertEquals("Unexpected update arrived", 0, this.updateInterceptor.waitOnUpdate(1000L, 0));
        this.log.info(this.ME, "Entering testCachedAccess with XPATH ...");
        try {
            PublishReturnQos publishReturnQos0 = this.publishMsg(this.publishOidArr[0], this.contentArr[0]);
            PublishReturnQos publishReturnQos1 = this.publishMsg(this.publishOidArr[1], this.contentArr[1]);
            this.publishMsg(this.publishOidArr[2], this.contentArr[2]);
            try {
                Thread.currentThread();
                Thread.sleep(200L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            GetKey gk = new GetKey(this.glob, "//key[starts-with(@oid,'oid-')]", "XPATH");
            GetQos gq = new GetQos(this.glob);
            int i = 0;
            while (i < 10) {
                MsgUnit[] msgs = this.con.getCached(gk, gq);
                Assert.assertEquals("", 2, msgs.length);
                GetReturnQos grq0 = new GetReturnQos(this.glob, msgs[0].getQos());
                GetReturnQos grq1 = new GetReturnQos(this.glob, msgs[1].getQos());
                Assert.assertEquals(this.synchronousCache.toXml(""), 2, msgs.length);
                Assert.assertEquals(this.synchronousCache.toXml(""), 1, this.synchronousCache.getNumQueriesCached());
                this.log.info(this.ME, " publishReturnQos0.getRcvTimestamp()=" + publishReturnQos0.getRcvTimestamp() + " publishReturnQos1.getRcvTimestamp()=" + publishReturnQos1.getRcvTimestamp() + " grq0.getRcvTimestamp()=" + grq0.getRcvTimestamp() + " grq1.getRcvTimestamp()=" + grq1.getRcvTimestamp());
                Assert.assertTrue("", publishReturnQos0.getRcvTimestamp().equals(grq0.getRcvTimestamp()) || publishReturnQos0.getRcvTimestamp().equals(grq1.getRcvTimestamp()));
                Assert.assertTrue("", publishReturnQos1.getRcvTimestamp().equals(grq0.getRcvTimestamp()) || publishReturnQos1.getRcvTimestamp().equals(grq1.getRcvTimestamp()));
                Assert.assertTrue("", !grq0.getRcvTimestamp().equals(grq1.getRcvTimestamp()));
                this.log.info("", "Accessed xmlBlaster message with content '" + new String(msgs[0].getContent()) + "' and status=" + grq0.getState());
                ++i;
            }
            Assert.assertEquals("", 1, this.synchronousCache.getNumQueriesCached());
            EraseReturnQos[] arr0 = this.sendErase(this.publishOidArr[0]);
            Assert.assertEquals("", 1, this.synchronousCache.getNumQueriesCached());
            EraseReturnQos[] arr1 = this.sendErase(this.publishOidArr[1]);
            Assert.assertEquals("", 0, this.synchronousCache.getNumQueriesCached());
            EraseReturnQos[] arr2 = this.sendErase(this.publishOidArr[2]);
            Assert.assertEquals("", 0, this.synchronousCache.getNumQueriesCached());
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "testCachedAccess() failed: " + e.getMessage());
            Assert.fail(e.getMessage());
        }
        Assert.assertEquals("Unexpected update arrived", 0, this.updateInterceptor.waitOnUpdate(1000L, 0));
        this.log.info(this.ME, "SUCCESS testCachedAccess");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new TestSynchronousCache(new Global(), "testCachedAccess"));
        return suite;
    }

    public static void main(String[] args) {
        TestSynchronousCache testSub = new TestSynchronousCache(new Global(args), "TestSynchronousCache");
        testSub.setUp();
        testSub.testCachedAccess();
        testSub.tearDown();
    }
}

