/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.client;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_ConnectionStateListener;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.test.MsgInterceptor;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.dispatch.ConnectionStateEnum;

public class TestTailback
extends TestCase
implements I_ConnectionStateListener {
    private static String ME = "TestTailback";
    private Global glob;
    private LogChannel log;
    private int serverPort = 7694;
    private EmbeddedXmlBlaster serverThread;
    private String oid = "tailbackMsg";

    public TestTailback(String testName) {
        this(null, testName);
    }

    public TestTailback(Global glob, String testName) {
        super(testName);
        this.glob = glob;
    }

    protected void setUp() {
        this.glob = this.glob == null ? new Global() : this.glob;
        this.log = this.glob.getLog("test");
        this.glob.init(Util.getOtherServerPorts(this.serverPort));
    }

    protected void tearDown() {
        this.log.info(ME, "Entering tearDown(), test is finished");
        if (this.serverThread != null) {
            EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
        }
        Util.resetPorts(this.glob);
        Global.instance().shutdown();
        this.glob = null;
        this.log = null;
        this.serverThread = null;
    }

    private Client doConnect(String loginName, I_Callback cb) {
        try {
            Client client = new Client();
            Global gg = this.glob.getClone(null);
            ConnectQos connectQos = new ConnectQos(gg);
            SessionName sessionName = new SessionName(gg, loginName);
            connectQos.setSessionName(sessionName);
            client.con = gg.getXmlBlasterAccess();
            client.con.registerConnectionListener(this);
            client.updateInterceptor = new MsgInterceptor(gg, this.log, cb);
            client.con.connect(connectQos, client.updateInterceptor);
            return client;
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "doConnect() - login failed: " + e.getMessage());
            Assert.fail(ME + ".doConnect() failed: " + e.getMessage());
            return null;
        }
    }

    private void doSubscribe(I_XmlBlasterAccess con) {
        if (this.log.TRACE) {
            this.log.trace(ME, "Subscribing using EXACT oid syntax ...");
        }
        try {
            SubscribeKey subscribeKey = new SubscribeKey(con.getGlobal(), this.oid);
            SubscribeQos subscribeQos = new SubscribeQos(con.getGlobal());
            String subscribeOid = con.subscribe(subscribeKey, subscribeQos).getSubscriptionId();
            this.log.info(ME, "Success: Subscribe on " + subscribeOid + " done");
            Assert.assertTrue("returned null subscribeOid", subscribeOid != null);
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "XmlBlasterException: " + e.getMessage());
            Assert.fail(ME + ".doSubscribe() failed: " + e.getMessage());
        }
    }

    private void doPublish(I_XmlBlasterAccess con) {
        if (this.log.TRACE) {
            this.log.trace(ME, "Publishing a message");
        }
        try {
            PublishKey publishKey = new PublishKey(con.getGlobal(), this.oid);
            PublishQos publishQos = new PublishQos(con.getGlobal());
            publishQos.setPersistent(true);
            String content = "Hi";
            MsgUnit msgUnit = new MsgUnit(publishKey, content.getBytes(), publishQos);
            con.publish(msgUnit);
            this.log.info(ME, "Success: Publishing of " + this.oid + " done");
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "XmlBlasterException: " + e.getMessage());
            Assert.fail(ME + ".doPublish() failed: " + e.getMessage());
        }
    }

    private void doErase(I_XmlBlasterAccess con) {
        this.log.info(ME, "Erasing " + this.oid + " ...");
        try {
            EraseKey eraseKey = new EraseKey(con.getGlobal(), this.oid);
            EraseQos eraseQos = new EraseQos(con.getGlobal());
            eraseQos.setForceDestroy(true);
            EraseReturnQos[] arr = con.erase(eraseKey, eraseQos);
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "XmlBlasterException: " + e.getMessage());
            Assert.fail(ME + ".doErase() failed: " + e.getMessage());
        }
    }

    public void testTailback() {
        this.log.info(ME, "testTailback START");
        this.log.info(ME, "STEP1: Publish a persistent message twice, will be tailed back as no xmlBlaster runs");
        Client pub = this.doConnect("publisher/2", null);
        this.doPublish(pub.con);
        this.doPublish(pub.con);
        pub.con.disconnect(null);
        this.log.info(ME, "STEP2: Start xmlBlaster server");
        this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.serverPort);
        this.log.info(ME, "STEP3: Start subscriber and subscribe");
        Client sub1 = this.doConnect("subscribe/1", null);
        this.doSubscribe(sub1.con);
        Assert.assertEquals("", 0, sub1.updateInterceptor.waitOnUpdate(1000L));
        sub1.updateInterceptor.clear();
        this.log.info(ME, "STEP4: Start same publisher again");
        pub = this.doConnect("publisher/2", null);
        Assert.assertEquals("", 2, sub1.updateInterceptor.waitOnUpdate(1000L, 2));
        this.log.info(ME, "STEP5: Success, cleanup");
        this.doErase(pub.con);
        pub.con.disconnect(null);
        sub1.con.disconnect(null);
        EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
        this.serverThread = null;
    }

    public void reachedAlive(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        this.log.info(ME, "I_ConnectionStateListener-" + connection.getId() + ": We were lucky, reconnected to xmlBlaster");
    }

    public void reachedPolling(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        if (this.log != null) {
            this.log.warn(ME, "I_ConnectionStateListener-" + connection.getId() + ": Lost connection to xmlBlaster");
        }
    }

    public void reachedDead(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        if (this.log != null) {
            this.log.error(ME, "DEBUG ONLY: Changed from connection state " + oldState + " to " + ConnectionStateEnum.DEAD);
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new TestTailback(null, "testTailback"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.err.println(ME + ": Init failed");
            System.exit(1);
        }
        TestTailback testSub = new TestTailback(glob, "TestTailback");
        testSub.setUp();
        testSub.testTailback();
        testSub.tearDown();
    }

    class Client {
        I_XmlBlasterAccess con;
        MsgInterceptor updateInterceptor;

        Client() {
        }
    }
}

