/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.client;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_ConnectionStateListener;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.test.Msg;
import org.xmlBlaster.test.MsgInterceptor;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.dispatch.ConnectionStateEnum;
import org.xmlBlaster.util.qos.address.Address;

public class TestXmlBlasterAccessMultiThreaded
extends TestCase
implements I_ConnectionStateListener {
    private static String ME = "TestXmlBlasterAccessMultiThreaded";
    private Global glob;
    private LogChannel log;
    private int serverPort = 7404;
    private EmbeddedXmlBlaster serverThread;
    private MsgInterceptor updateInterceptor;
    private I_XmlBlasterAccess con;
    private String senderName;
    private int numPublish = 20;
    private int numStop = 3;
    private int numStart = 5;
    private int iThread = 0;
    private final String contentMime = "text/plain";
    private final long reconnectDelay = 2000L;

    public TestXmlBlasterAccessMultiThreaded(String testName) {
        this(null, testName);
    }

    public TestXmlBlasterAccessMultiThreaded(Global glob, String testName) {
        super(testName);
        this.glob = glob;
        this.senderName = testName;
    }

    protected void setUp() {
        this.glob = this.glob == null ? new Global() : this.glob;
        this.log = this.glob.getLog("test");
        this.glob.init(Util.getOtherServerPorts(this.serverPort));
        this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.glob);
        this.log.info(ME, "XmlBlaster is ready for testing on bootstrapPort " + this.serverPort);
        try {
            this.con = this.glob.getXmlBlasterAccess();
            String passwd = "secret";
            ConnectQos connectQos = new ConnectQos(this.glob, this.senderName, passwd);
            Address addressProp = new Address(this.glob);
            addressProp.setDelay(2000L);
            addressProp.setRetries(-1);
            addressProp.setPingInterval(-1L);
            this.con.registerConnectionListener(this);
            connectQos.setAddress(addressProp);
            this.updateInterceptor = new MsgInterceptor(this.glob, this.log, null);
            this.con.connect(connectQos, this.updateInterceptor);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "setUp() - login failed: " + e.getMessage());
            Assert.fail("setUp() - login fail: " + e.getMessage());
        }
        catch (Exception e) {
            this.log.error(ME, "setUp() - login failed: " + e.toString());
            e.printStackTrace();
            Assert.fail("setUp() - login fail: " + e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void tearDown() {
        this.log.info(ME, "Entering tearDown(), test is finished");
        String xmlKey = "<key oid='' queryType='XPATH'>\n   //TestXmlBlasterAccessMultiThreaded-AGENT</key>";
        String qos = "<qos></qos>";
        try {
            try {
                EraseReturnQos[] arr = this.con.erase(xmlKey, qos);
            }
            catch (XmlBlasterException e) {
                this.log.error(ME, "XmlBlasterException: " + e.getMessage());
                Object var5_6 = null;
                this.con.disconnect(null);
                EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
                this.serverThread = null;
                Util.resetPorts(this.glob);
                this.glob = null;
                this.con = null;
                Global.instance().shutdown();
                return;
            }
            Object var5_5 = null;
            this.con.disconnect(null);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.con.disconnect(null);
            EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
            this.serverThread = null;
            Util.resetPorts(this.glob);
            this.glob = null;
            this.con = null;
            Global.instance().shutdown();
            throw throwable;
        }
        EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
        this.serverThread = null;
        Util.resetPorts(this.glob);
        this.glob = null;
        this.con = null;
        Global.instance().shutdown();
    }

    public void doSubscribe() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Subscribing using EXACT oid syntax ...");
        }
        String xmlKey = "<key oid='' queryType='XPATH'>\n   //TestXmlBlasterAccessMultiThreaded-AGENT</key>";
        String qos = "<qos><notify>false</notify></qos>";
        try {
            SubscribeReturnQos subscriptionId = this.con.subscribe(xmlKey, qos);
            this.log.info(ME, "Success: Subscribe on subscriptionId=" + subscriptionId.getSubscriptionId() + " done");
            Assert.assertTrue("returned null subscriptionId", subscriptionId != null);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    public MsgUnit doPublish(String oid, String content) throws XmlBlasterException {
        this.log.info(ME, "Publishing a message " + oid + " ...");
        String xmlKey = "<key oid='" + oid + "' contentMime='" + "text/plain" + "'>\n" + "   <TestXmlBlasterAccessMultiThreaded-AGENT id='192.168.124.10' subId='1' type='generic'>" + "   </TestXmlBlasterAccessMultiThreaded-AGENT>" + "</key>";
        PublishQos qosWrapper = new PublishQos(this.glob);
        MsgUnit msgUnit = new MsgUnit(xmlKey, content.getBytes(), qosWrapper.toXml());
        this.con.publish(msgUnit);
        this.log.info(ME, "Success: Publishing of " + oid + " content='" + content + "' done");
        return msgUnit;
    }

    public void testPublishThreads() {
        ME = "TestXmlBlasterAccessMultiThreaded.testPublishThreads()";
        String oid = "TestXmlBlasterAccessMultiThreaded";
        int numThreads = 5;
        this.log.info(ME, "Going to publish " + this.numPublish + " messages with each of " + numThreads + " threads");
        Vector sentMsgVec = new Vector(this.numPublish * numThreads);
        PublishThread[] publishThreads = new PublishThread[numThreads];
        this.iThread = 0;
        while (this.iThread < numThreads) {
            publishThreads[this.iThread] = new PublishThread("" + this.iThread, this.numPublish, "TestXmlBlasterAccessMultiThreaded");
            publishThreads[this.iThread].start();
            ++this.iThread;
        }
        this.log.info(ME, "Trying join ...");
        int kk = 0;
        while (kk < numThreads) {
            try {
                publishThreads[kk].join();
            }
            catch (InterruptedException ie) {
                this.log.warn(ME, "Caught join() exception: " + ie.toString());
            }
            ++kk;
        }
        this.log.info(ME, "Threads are joined");
        this.updateInterceptor.waitOnUpdate(3000L, this.numPublish * numThreads);
        Msg[] msgs = this.updateInterceptor.getMsgs("TestXmlBlasterAccessMultiThreaded", "OK");
        try {
            Thread.currentThread();
            Thread.sleep(3000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assert.assertEquals("Too many messages arrived", this.numPublish * numThreads, this.updateInterceptor.count());
        HashSet<String> set = new HashSet<String>();
        int ii = 0;
        while (ii < msgs.length) {
            Assert.assertEquals("Duplicate messages!!! '" + msgs[ii].getContentStr(), true, set.add(msgs[ii].getContentStr()));
            ++ii;
        }
        int[] lastMsg = new int[numThreads];
        int iThread = 0;
        while (iThread < numThreads) {
            lastMsg[iThread] = -1;
            ++iThread;
        }
        int ii2 = 0;
        while (ii2 < msgs.length) {
            String content = msgs[ii2].getContentStr();
            int sepPos = content.indexOf(":");
            int iThread2 = Integer.parseInt(content.substring(0, sepPos));
            int iMsg = Integer.parseInt(content.substring(sepPos + 1));
            if (iMsg <= lastMsg[iThread2]) {
                Assert.fail("Messages are not in ascending order, last=" + lastMsg + " curr=" + iMsg);
            }
            lastMsg[iThread2] = iMsg;
            ++ii2;
        }
        this.log.info(ME, "SUCCESS, all check are OK.");
    }

    public void reachedAlive(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        this.log.info(ME, "I_ConnectionStateListener: We were lucky, reconnected to xmlBlaster");
        this.doSubscribe();
    }

    public void reachedPolling(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        this.log.warn(ME, "DEBUG ONLY: Changed from connection state " + oldState + " to " + ConnectionStateEnum.POLLING);
    }

    public void reachedDead(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        this.log.error(ME, "DEBUG ONLY: Changed from connection state " + oldState + " to " + ConnectionStateEnum.DEAD);
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.out.println(ME + ": Init failed");
            System.exit(1);
        }
        TestXmlBlasterAccessMultiThreaded testSub = new TestXmlBlasterAccessMultiThreaded(glob, "TestXmlBlasterAccessMultiThreaded");
        testSub.setUp();
        testSub.testPublishThreads();
        testSub.tearDown();
    }

    class PublishThread
    extends Thread {
        private final ArrayList sentMsgList;
        private final int numPublish;
        private final String oid;

        public PublishThread(String name, int numPublish, String oid) {
            super(name);
            this.numPublish = numPublish;
            this.oid = oid;
            this.sentMsgList = new ArrayList(numPublish);
        }

        public void run() {
            TestXmlBlasterAccessMultiThreaded.this.log.info(ME, "Started thread " + TestXmlBlasterAccessMultiThreaded.this.iThread + ": " + Thread.currentThread().getName());
            int ii = 0;
            while (ii < this.numPublish) {
                try {
                    MsgUnit msgUnit = TestXmlBlasterAccessMultiThreaded.this.doPublish(this.oid, Thread.currentThread().getName() + ":" + (ii + 1));
                    this.sentMsgList.add(msgUnit);
                }
                catch (XmlBlasterException e) {
                    TestXmlBlasterAccessMultiThreaded.this.log.error(ME, "Fail: " + e.getMessage());
                    Assert.fail(ME + ": " + e.getMessage());
                }
                ++ii;
            }
            TestXmlBlasterAccessMultiThreaded.this.log.info(ME, Thread.currentThread().getName() + ": Published " + this.numPublish + " messages");
        }

        public final ArrayList getSentMsgList() {
            return this.sentMsgList;
        }
    }
}

