/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.cluster;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.test.cluster.ServerHelper;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class DirtyReadTest
extends TestCase {
    private String ME = "DirtyReadTest";
    private Global glob = new Global(null, true, false);
    private LogChannel log;
    private ServerHelper serverHelper;
    private I_XmlBlasterAccess heronCon;
    private I_XmlBlasterAccess avalonCon;
    private I_XmlBlasterAccess golanCon;
    private I_XmlBlasterAccess frodoCon;
    private I_XmlBlasterAccess bilboCon;
    private int updateCounterFrodo = 0;
    private String contentStr = "Lets have another game.";
    private String assertInUpdate = null;

    public DirtyReadTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.log = this.glob.getLog(this.ME);
        this.log.info(this.ME, "Entering setUp(), test starts");
        this.assertInUpdate = null;
        this.updateCounterFrodo = 0;
        this.serverHelper = new ServerHelper(this.glob, this.log, this.ME);
        this.serverHelper.startHeron();
        this.serverHelper.startFrodo();
    }

    protected void tearDown() {
        this.log.info(this.ME, "Entering tearDown(), test is finished");
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.frodoCon != null) {
            this.frodoCon.disconnect(null);
            this.frodoCon = null;
        }
        if (this.heronCon != null) {
            this.heronCon.disconnect(null);
            this.heronCon = null;
        }
        this.serverHelper.tearDown();
    }

    public void testDirtyRead() {
        this.runIt("RUGBY_NEWS");
    }

    public void testNoDirtyRead() {
        this.runIt("SOCCER_NEWS");
    }

    public void runIt(String domain) {
        boolean isDirtyReadTest = domain.equals("RUGBY_NEWS");
        this.ME = "DirtyReadTest domain=" + domain + ": ";
        System.err.println("***DirtyReadTest: Publish a message to a cluster slave isDirtyReadTest=" + isDirtyReadTest + " ...");
        final String oid = isDirtyReadTest ? "PublishToBilbo-DirtyRead" : "PublishToBilbo-NODirtyRead";
        try {
            System.err.println(this.ME + "->Connect to frodo ...");
            this.frodoCon = this.serverHelper.connect(this.serverHelper.getFrodoGlob(), new I_Callback(){

                public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
                    DirtyReadTest.this.assertInUpdate = DirtyReadTest.this.serverHelper.getFrodoGlob().getId() + ": Receive unexpected message '" + updateKey.getOid() + "'";
                    return "";
                }
            });
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            Assert.assertTrue(this.assertInUpdate, this.assertInUpdate == null);
            System.err.println(this.ME + "->Subscribe '" + oid + "' from frodo ...");
            SubscribeKey sk = new SubscribeKey(this.glob, oid);
            sk.setDomain(domain);
            SubscribeQos sq = new SubscribeQos(this.glob);
            SubscribeReturnQos srq = this.frodoCon.subscribe(sk.toXml(), sq.toXml(), new I_Callback(){

                public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
                    DirtyReadTest.this.log.info(DirtyReadTest.this.ME + ":" + DirtyReadTest.this.serverHelper.getFrodoGlob().getId(), "Reveiving asynchronous message '" + updateKey.getOid() + "' in " + oid + " handler");
                    DirtyReadTest.this.updateCounterFrodo++;
                    DirtyReadTest.this.assertInUpdate = null;
                    return "";
                }
            });
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            Assert.assertTrue(this.assertInUpdate, this.assertInUpdate == null);
            this.assertInUpdate = null;
            System.err.println(this.ME + "->Check publish '" + oid + "', frodo should get it ...");
            PublishKey pk = new PublishKey(this.glob, oid, "text/plain", "1.0", domain);
            PublishQos pq = new PublishQos(this.glob);
            MsgUnit msgUnit = new MsgUnit(pk, this.contentStr.getBytes(), pq);
            PublishReturnQos prq = this.frodoCon.publish(msgUnit);
            this.log.info(this.ME + ":" + this.serverHelper.getFrodoGlob().getId(), "Published message of domain='" + pk.getDomain() + "' and content='" + this.contentStr + "' to xmlBlaster node with IP=" + this.serverHelper.getFrodoGlob().getProperty().get("bootstrapPort", 0) + ", the returned QoS is: " + prq.getKeyOid());
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            Assert.assertEquals("frodo has not received message", 1, this.updateCounterFrodo);
            System.err.println("Query heron if he did not send any update message ...");
            System.err.println("->Connect to heron ...");
            this.heronCon = this.serverHelper.connect(this.serverHelper.getHeronGlob(), null);
            String cmd = "__cmd:client/frodo/?sessionList";
            System.err.println(this.ME + "->Find out the public session Id of slave frodo at heron with '" + cmd + "' ...");
            MsgUnit[] msgs = this.heronCon.get("<key oid='" + cmd + "'/>", null);
            Assert.assertEquals("Command failed", 1, msgs.length);
            String pubSessionId = msgs[0].getContentStr();
            cmd = "__cmd:client/frodo/" + pubSessionId + "/?numUpdates";
            System.err.println("->Query numUpdates with '" + cmd + "' ...");
            msgs = this.heronCon.get("<key oid='" + cmd + "'/>", null);
            Assert.assertEquals("Command failed", 1, msgs.length);
            if (isDirtyReadTest) {
                Assert.assertEquals("frodo has received updates from heron but should not because of dirty read", "0", msgs[0].getContentStr());
                this.log.info(this.ME, "Success, the update was a dirty read as heron did not send it!");
            } else {
                Assert.assertEquals("frodo has not received updates from its master heron", "1", msgs[0].getContentStr());
                this.log.info(this.ME, "Success, the update was NO dirty read as heron did send it!");
            }
            System.err.println(this.ME + "Check if heron has got the message ...");
            msgs = this.heronCon.get("<key oid='" + oid + "'/>", null);
            Assert.assertEquals("The master never got the message", 1, msgs.length);
        }
        catch (XmlBlasterException e) {
            e.printStackTrace();
            Assert.fail("PublishToBilbo-DirtyRead-Exception: " + e.toString());
        }
        System.err.println("***DirtyReadTest: testDirtyRead [SUCCESS]");
    }
}

