/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.cluster;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.test.cluster.ServerHelper;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.address.Destination;

public class PtPTest
extends TestCase {
    private String ME = "PtPTest";
    private Global glob = new Global(null, true, false);
    private LogChannel log;
    private ServerHelper serverHelper;
    private I_XmlBlasterAccess heronCon;
    private I_XmlBlasterAccess avalonCon;
    private I_XmlBlasterAccess golanCon;
    private I_XmlBlasterAccess frodoCon;
    private I_XmlBlasterAccess bilboCon;
    private int updateCounterHeron = 0;
    private int updateCounterFrodo = 0;
    private int updateCounterBilbo = 0;
    private String oid = "PublishToBilbo";
    private String domain = "RUGBY_NEWS";
    private String contentStr = "We win";
    private String assertInUpdateHeron = null;
    private String assertInUpdateBilbo = null;

    public PtPTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.log = this.glob.getLog(this.ME);
        this.log.info(this.ME, "Entering setUp(), test starts");
        this.serverHelper = new ServerHelper(this.glob, this.log, this.ME);
        this.serverHelper.startHeron();
        this.serverHelper.startFrodo();
        this.serverHelper.startBilbo();
    }

    protected void tearDown() {
        this.log.info(this.ME, "Entering tearDown(), test is finished");
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.bilboCon != null) {
            this.bilboCon.disconnect(null);
            this.bilboCon = null;
        }
        if (this.frodoCon != null) {
            this.frodoCon.disconnect(null);
            this.frodoCon = null;
        }
        if (this.golanCon != null) {
            this.golanCon.disconnect(null);
            this.golanCon = null;
        }
        if (this.avalonCon != null) {
            this.avalonCon.disconnect(null);
            this.avalonCon = null;
        }
        if (this.heronCon != null) {
            this.heronCon.disconnect(null);
            this.heronCon = null;
        }
        this.serverHelper.tearDown();
    }

    public void testPublishPtP() {
        System.err.println("***PtPTest: Publish a message to a cluster slave ...");
        try {
            this.log.info(this.ME, "Login to heron and wait for PtP message ...");
            this.heronCon = this.serverHelper.connect(this.serverHelper.getHeronGlob(), new I_Callback(){

                public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
                    PtPTest.this.log.info(PtPTest.this.ME + ":" + PtPTest.this.serverHelper.getHeronGlob().getId(), "Received message '" + updateKey.getOid() + "' state=" + updateQos.getState() + " from '" + updateQos.getSender() + "'");
                    if (!updateQos.getSender().equalsAbsolute(PtPTest.this.bilboCon.getConnectReturnQos().getSessionName())) {
                        PtPTest.this.assertInUpdateHeron = PtPTest.this.serverHelper.getHeronGlob().getId() + ": Did not expect message update in default handler";
                    }
                    PtPTest.this.updateCounterHeron++;
                    return "";
                }
            });
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            Assert.assertTrue(this.assertInUpdateHeron, this.assertInUpdateHeron == null);
            this.assertInUpdateHeron = null;
            this.log.info(this.ME, "Login to bilbo to send PtP message ...");
            this.bilboCon = this.serverHelper.connect(this.serverHelper.getBilboGlob(), new I_Callback(){

                public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
                    PtPTest.this.assertInUpdateBilbo = PtPTest.this.serverHelper.getBilboGlob().getId() + ": Should not receive the message '" + updateKey.getOid() + "'";
                    Assert.fail(PtPTest.this.assertInUpdateBilbo);
                    return "";
                }
            });
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            Assert.assertTrue(this.assertInUpdateBilbo, this.assertInUpdateBilbo == null);
            this.assertInUpdateBilbo = null;
            int num = 5;
            int i = 0;
            while (i < num) {
                PublishKey pk = new PublishKey(this.glob, this.oid, "text/plain", "1.0");
                PublishQos pq = new PublishQos(this.glob);
                SessionName sessionName = this.heronCon.getConnectReturnQos().getSessionName();
                Destination destination = new Destination(sessionName);
                destination.forceQueuing(true);
                pq.addDestination(destination);
                this.log.info(this.ME, "Sending PtP message '" + this.oid + "' from bilbo to '" + sessionName + "' :" + pq.toXml());
                MsgUnit msgUnit = new MsgUnit(pk, (this.contentStr + "-" + i).getBytes(), pq);
                PublishReturnQos prq = this.bilboCon.publish(msgUnit);
                this.log.info(this.ME + ":" + this.serverHelper.getBilboGlob().getId(), "Published message to destination='" + sessionName + "' content='" + this.contentStr + "-" + i + "' to xmlBlaster node with IP=" + this.serverHelper.getBilboGlob().getProperty().get("bootstrapPort", 0) + ", the returned QoS is: " + prq.getKeyOid());
                ++i;
            }
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assert.assertTrue(this.assertInUpdateHeron, this.assertInUpdateHeron == null);
            Assert.assertEquals("Heron client did not receive PtP message", num, this.updateCounterHeron);
        }
        catch (XmlBlasterException e) {
            e.printStackTrace();
            Assert.fail("PublishToBilbo-Exception: " + e.getMessage());
        }
        System.err.println("***PtPTest: testPublishPtP [SUCCESS]");
    }

    public static void main(String[] args) {
        Global glob = new Global(null, true, false);
        if (glob.init(args) != 0) {
            System.exit(0);
        }
        PtPTest testSub = new PtPTest("PtPTest");
        testSub.setUp();
        testSub.testPublishPtP();
        testSub.tearDown();
    }
}

