/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.cluster;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.key.GetKey;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UnSubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UnSubscribeQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.test.cluster.ServerHelper;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class PublishTest
extends TestCase {
    private String ME = "PublishTest";
    private Global glob = new Global(null, true, false);
    private LogChannel log;
    private ServerHelper serverHelper;
    private I_XmlBlasterAccess heronCon;
    private I_XmlBlasterAccess avalonCon;
    private I_XmlBlasterAccess golanCon;
    private I_XmlBlasterAccess frodoCon;
    private I_XmlBlasterAccess bilboCon;
    private int updateCounterHeron = 0;
    private int updateCounterFrodo = 0;
    private int updateCounterBilbo = 0;
    private String oid = "PublishToBilbo";
    private String domain = "RUGBY_NEWS";
    private String contentStr = "We win";
    private String assertInUpdate = null;

    public PublishTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.log = this.glob.getLog(this.ME);
        this.log.info(this.ME, "Entering setUp(), test starts");
        this.serverHelper = new ServerHelper(this.glob, this.log, this.ME);
        this.serverHelper.startHeron();
        this.serverHelper.startFrodo();
        this.serverHelper.startBilbo();
    }

    protected void tearDown() {
        this.log.info(this.ME, "Entering tearDown(), test is finished");
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.bilboCon != null) {
            this.bilboCon.disconnect(null);
            this.bilboCon = null;
        }
        if (this.frodoCon != null) {
            this.frodoCon.disconnect(null);
            this.frodoCon = null;
        }
        if (this.golanCon != null) {
            this.golanCon.disconnect(null);
            this.golanCon = null;
        }
        if (this.avalonCon != null) {
            this.avalonCon.disconnect(null);
            this.avalonCon = null;
        }
        if (this.heronCon != null) {
            this.heronCon.disconnect(null);
            this.heronCon = null;
        }
        this.serverHelper.tearDown();
    }

    public void testPublish() {
        System.err.println("***PublishTest: Publish a message to a cluster slave ...");
        try {
            this.bilboCon = this.serverHelper.connect(this.serverHelper.getBilboGlob(), new I_Callback(){

                public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
                    PublishTest.this.assertInUpdate = PublishTest.this.serverHelper.getBilboGlob().getId() + ": Should not receive the message '" + updateKey.getOid() + "'";
                    Assert.fail(PublishTest.this.assertInUpdate);
                    return "";
                }
            });
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            Assert.assertTrue(this.assertInUpdate, this.assertInUpdate == null);
            this.assertInUpdate = null;
            PublishKey pk = new PublishKey(this.glob, this.oid, "text/plain", "1.0");
            pk.setDomain(this.domain);
            PublishQos pq = new PublishQos(this.glob);
            MsgUnit msgUnit = new MsgUnit(pk, this.contentStr, pq);
            PublishReturnQos prq = this.bilboCon.publish(msgUnit);
            this.log.info(this.ME + ":" + this.serverHelper.getBilboGlob().getId(), "Published message of domain='" + pk.getDomain() + "' and content='" + this.contentStr + "' to xmlBlaster node bilbo with IP=" + this.serverHelper.getBilboGlob().getProperty().get("bootstrapPort", 0) + ", the returned QoS is: " + prq.getKeyOid());
            this.heronCon = this.serverHelper.connect(this.serverHelper.getHeronGlob(), new I_Callback(){

                public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
                    PublishTest.this.log.error(PublishTest.this.ME + ":" + PublishTest.this.serverHelper.getHeronGlob().getId(), "Receive message '" + updateKey.getOid() + "'");
                    PublishTest.this.assertInUpdate = PublishTest.this.serverHelper.getHeronGlob().getId() + ": Did not expect message update in default handler";
                    Assert.fail(PublishTest.this.assertInUpdate);
                    return "";
                }
            });
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            Assert.assertTrue(this.assertInUpdate, this.assertInUpdate == null);
            this.assertInUpdate = null;
            System.err.println("->Check if the message has reached the master node heron ...");
            GetKey gk = new GetKey(this.glob, this.oid);
            MsgUnit[] msgs = this.heronCon.get(gk.toXml(), null);
            Assert.assertTrue("Invalid msgs returned", msgs != null);
            Assert.assertEquals("Invalid number of messages returned", 1, msgs.length);
            Assert.assertTrue("Invalid message oid returned", msgs[0].getKey().indexOf(this.oid) > 0);
            this.log.info(this.ME + ":" + this.serverHelper.getHeronGlob().getId(), "SUCCESS: Got message:" + msgs[0].getKey());
            System.err.println("->Check if the message is available at the slave node bilbo ...");
            gk = new GetKey(this.glob, this.oid);
            gk.setDomain(this.domain);
            msgs = this.bilboCon.get(gk.toXml(), null);
            Assert.assertTrue("Invalid msgs returned", msgs != null);
            Assert.assertEquals("Invalid number of messages returned", 1, msgs.length);
            this.log.info(this.ME + ":" + this.serverHelper.getBilboGlob().getId(), "SUCCESS: Got message:" + msgs[0].getKey());
            System.err.println("->Trying to erase the message at the slave node ...");
            EraseKey ek = new EraseKey(this.glob, this.oid);
            ek.setDomain(this.domain);
            EraseQos eq = new EraseQos(this.glob);
            this.bilboCon.erase(ek.toXml(), eq.toXml());
            gk = new GetKey(this.glob, this.oid);
            msgs = this.heronCon.get(gk.toXml(), null);
            Assert.assertTrue("Invalid msgs returned", msgs != null);
            Assert.assertEquals("Invalid number of messages returned", 0, msgs.length);
            this.log.info(this.ME + ":" + this.serverHelper.getHeronGlob().getId(), "SUCCESS: Got no message after erase");
            System.err.println("***PublishTest: Publish a message to a cluster slave - frodo is offline ...");
            System.err.println("->Subscribe from heron, the message is currently erased ...");
            SubscribeKey sk = new SubscribeKey(this.glob, this.oid);
            sk.setDomain(this.domain);
            SubscribeQos sq = new SubscribeQos(this.glob);
            SubscribeReturnQos srq = this.heronCon.subscribe(sk.toXml(), sq.toXml(), new I_Callback(){

                public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
                    PublishTest.this.assertInUpdate = PublishTest.this.serverHelper.getHeronGlob().getId() + ": Receiving unexpected asynchronous update message";
                    Assert.assertEquals(PublishTest.this.assertInUpdate, PublishTest.this.oid, updateKey.getOid());
                    PublishTest.this.assertInUpdate = PublishTest.this.serverHelper.getHeronGlob().getId() + ": Receiving corrupted asynchronous update message";
                    Assert.assertEquals(PublishTest.this.assertInUpdate, PublishTest.this.contentStr, new String(content));
                    PublishTest.this.log.info(PublishTest.this.ME + ":" + PublishTest.this.serverHelper.getHeronGlob().getId(), "heronCon - Receiving asynchronous message '" + updateKey.getOid() + "' in " + PublishTest.this.oid + " handler, state=" + updateQos.getState());
                    PublishTest.this.updateCounterHeron++;
                    PublishTest.this.assertInUpdate = null;
                    return "";
                }
            });
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            Assert.assertTrue(this.assertInUpdate, this.assertInUpdate == null);
            this.assertInUpdate = null;
            this.serverHelper.stopFrodo();
            System.err.println("->Check: heron hasn't got the message ...");
            gk = new GetKey(this.glob, this.oid);
            msgs = this.heronCon.get(gk.toXml(), null);
            Assert.assertTrue("Invalid msgs returned", msgs != null);
            Assert.assertEquals("Invalid number of messages returned", 0, msgs.length);
            this.log.info(this.ME + ":" + this.serverHelper.getHeronGlob().getId(), "SUCCESS: Got no message after erase");
            pk = new PublishKey(this.glob, this.oid, "text/plain", "1.0");
            pk.setDomain(this.domain);
            pq = new PublishQos(this.glob);
            msgUnit = new MsgUnit(pk.toXml(), this.contentStr.getBytes(), pq.toXml());
            prq = this.bilboCon.publish(msgUnit);
            this.log.info(this.ME + ":" + this.serverHelper.getBilboGlob().getId(), "Published message of domain='" + pk.getDomain() + "' and content='" + this.contentStr + "' to xmlBlaster node bilbo with IP=" + this.serverHelper.getBilboGlob().getProperty().get("bootstrapPort", 0) + ", the returned QoS is: " + prq.getKeyOid());
            Assert.assertEquals("heron is not reachable, publish should not have come through", 0, this.updateCounterHeron);
            this.serverHelper.startFrodo();
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            Assert.assertEquals("heron has not received message", 1, this.updateCounterHeron);
            this.updateCounterHeron = 0;
            System.err.println("->Connect to frodo ...");
            this.frodoCon = this.serverHelper.connect(this.serverHelper.getFrodoGlob(), new I_Callback(){

                public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
                    PublishTest.this.assertInUpdate = PublishTest.this.serverHelper.getFrodoGlob().getId() + ": Receive unexpected message '" + updateKey.getOid() + "'";
                    return "";
                }
            });
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            Assert.assertTrue(this.assertInUpdate, this.assertInUpdate == null);
            this.assertInUpdate = null;
            System.err.println("->Subscribe from frodo, is he able to organize it?");
            sk = new SubscribeKey(this.glob, this.oid);
            sk.setDomain(this.domain);
            sq = new SubscribeQos(this.glob);
            srq = this.frodoCon.subscribe(sk.toXml(), sq.toXml(), new I_Callback(){

                public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
                    PublishTest.this.log.info(PublishTest.this.ME + ":" + PublishTest.this.serverHelper.getFrodoGlob().getId(), "frodoCon - Receiving asynchronous message '" + updateKey.getOid() + "' in " + PublishTest.this.oid + " handler, state=" + updateQos.getState());
                    PublishTest.this.updateCounterFrodo++;
                    PublishTest.this.assertInUpdate = null;
                    return "";
                }
            });
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            Assert.assertTrue(this.assertInUpdate, this.assertInUpdate == null);
            this.assertInUpdate = null;
            try {
                Thread.currentThread();
                Thread.sleep(5000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            Assert.assertEquals("frodo is reachable again, subscribe should work", 1, this.updateCounterFrodo);
            this.updateCounterHeron = 0;
            this.updateCounterFrodo = 0;
            this.updateCounterBilbo = 0;
            System.err.println("->Check unSubscribe from client frodo ...");
            UnSubscribeKey uk = new UnSubscribeKey(this.glob, srq.getSubscriptionId());
            UnSubscribeQos uq = new UnSubscribeQos(this.glob);
            this.frodoCon.unSubscribe(uk.toXml(), uq.toXml());
            System.err.println("->Check publish, frodo should not get it ...");
            pk = new PublishKey(this.glob, this.oid, "text/plain", "1.0", this.domain);
            pq = new PublishQos(this.glob);
            msgUnit = new MsgUnit(pk, this.contentStr, pq);
            prq = this.frodoCon.publish(msgUnit);
            this.log.info(this.ME + ":" + this.serverHelper.getFrodoGlob().getId(), "Published message of domain='" + pk.getDomain() + "' and content='" + this.contentStr + "' to xmlBlaster node frodo with IP=" + this.serverHelper.getFrodoGlob().getProperty().get("bootstrapPort", 0) + ", the returned QoS is: " + prq.getKeyOid());
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            Assert.assertEquals("frodo is unSubscribed and should not receive message", 0, this.updateCounterFrodo);
            Assert.assertEquals("heron has not received message", 1, this.updateCounterHeron);
        }
        catch (XmlBlasterException e) {
            e.printStackTrace();
            Assert.fail("PublishToBilbo-Exception: " + e.toString());
        }
        System.err.println("***PublishTest: testPublish [SUCCESS]");
    }
}

