/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.cluster;

import java.io.File;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_ConnectionStateListener;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.dispatch.ConnectionStateEnum;

public class ServerHelper {
    private String ME = "ServerHelper";
    private Global glob_;
    private LogChannel log;
    public static int heronPort = 7600;
    public static int avalonPort = 7601;
    public static int golanPort = 7602;
    public static int frodoPort = 7603;
    public static int bilboPort = 7604;
    private EmbeddedXmlBlaster heronThread;
    private EmbeddedXmlBlaster avalonThread;
    private EmbeddedXmlBlaster golanThread;
    private EmbeddedXmlBlaster frodoThread;
    private EmbeddedXmlBlaster bilboThread;
    private Global heronGlob;
    private Global avalonGlob;
    private Global golanGlob;
    private Global frodoGlob;
    private Global bilboGlob;

    public ServerHelper(Global glob, LogChannel log, String name) {
        this.ME = "ServerHelper-" + name;
        this.glob_ = glob;
        this.log = log;
        this.setUp();
    }

    private String findPropertyFile(String fn) {
        File f = new File(fn);
        if (f.canRead()) {
            return fn;
        }
        f = new File("cluster" + File.separatorChar + fn);
        if (f.canRead()) {
            return f.getPath();
        }
        this.log.error(this.ME, "Can't locate property file " + fn + ". Please check your current directory or cluster directory");
        throw new IllegalArgumentException("Can't locate property file " + fn + ". Please check your current directory or cluster directory");
    }

    public Global getHeronGlob() {
        return this.heronGlob;
    }

    public Global getAvalonGlob() {
        return this.avalonGlob;
    }

    public Global getGolanGlob() {
        return this.golanGlob;
    }

    public Global getFrodoGlob() {
        return this.frodoGlob;
    }

    public Global getBilboGlob() {
        return this.bilboGlob;
    }

    public void initHeron() {
        String[] args = new String[]{"-propertyFile", this.findPropertyFile("heron.properties"), "-info[heron]", "true", "-call[heron]", "true"};
        this.heronGlob = this.glob_.getClone(args);
    }

    public void initAvalon() {
        String[] args = new String[]{"-propertyFile", this.findPropertyFile("avalon.properties")};
        this.avalonGlob = this.glob_.getClone(args);
    }

    public void initGolan() {
        String[] args = new String[]{"-propertyFile", this.findPropertyFile("golan.properties")};
        this.golanGlob = this.glob_.getClone(args);
    }

    public void initFrodo() {
        String[] args = new String[]{"-propertyFile", this.findPropertyFile("frodo.properties")};
        this.frodoGlob = this.glob_.getClone(args);
    }

    public void initBilbo() {
        String[] args = new String[]{"-propertyFile", this.findPropertyFile("bilbo.properties"), "-call[bilbo]", "false"};
        this.bilboGlob = this.glob_.getClone(args);
        if (!"bilbo".equals(this.bilboGlob.getId())) {
            String tmp = "Invalid cluster node id, check biblo.properties or change to the directory where the property files are!";
            this.log.error(this.ME, tmp);
            throw new IllegalArgumentException(tmp);
        }
    }

    public void startHeron() {
        this.heronThread = EmbeddedXmlBlaster.startXmlBlaster(this.heronGlob);
        this.log.info(this.ME, "'heron' is ready for testing on bootstrapPort " + heronPort);
    }

    public void startAvalon() {
        this.avalonThread = EmbeddedXmlBlaster.startXmlBlaster(this.avalonGlob);
        this.log.info(this.ME, "'avalon' is ready for testing on bootstrapPort " + avalonPort);
    }

    public void startGolan() {
        this.golanThread = EmbeddedXmlBlaster.startXmlBlaster(this.golanGlob);
        this.log.info(this.ME, "'golan' is ready for testing on bootstrapPort " + golanPort);
    }

    public void startFrodo() {
        this.frodoThread = EmbeddedXmlBlaster.startXmlBlaster(this.frodoGlob);
        this.log.info(this.ME, "'frodo' is ready for testing on bootstrapPort " + frodoPort);
    }

    public void startBilbo() {
        this.bilboThread = EmbeddedXmlBlaster.startXmlBlaster(this.bilboGlob);
        this.log.info(this.ME, "'bilbo' is ready for testing on bootstrapPort " + bilboPort);
    }

    public void stopHeron() {
        if (this.heronThread != null) {
            this.heronThread.stopServer(true);
            this.heronThread = null;
        }
    }

    public void stopAvalon() {
        if (this.avalonThread != null) {
            this.avalonThread.stopServer(true);
            this.avalonThread = null;
        }
    }

    public void stopGolan() {
        if (this.golanThread != null) {
            this.golanThread.stopServer(true);
            this.golanThread = null;
        }
    }

    public void stopFrodo() {
        if (this.frodoThread != null) {
            this.frodoThread.stopServer(true);
            this.frodoThread = null;
        }
    }

    public void stopBilbo() {
        if (this.bilboThread != null) {
            this.bilboThread.stopServer(true);
            this.bilboThread = null;
        }
    }

    public I_XmlBlasterAccess connect(Global glob, I_Callback cb) throws XmlBlasterException {
        final String clientName = "ClientTo[" + glob.getId() + "]";
        if (glob.getId() == null || glob.getId().length() < 1) {
            this.log.error(this.ME, "glob.getId() is not set");
        }
        I_XmlBlasterAccess con = glob.getXmlBlasterAccess();
        con.registerConnectionListener(new I_ConnectionStateListener(){

            public void reachedAlive(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
                ServerHelper.this.log.info(clientName, "Changed from connection state " + oldState + " to " + ConnectionStateEnum.ALIVE + " with " + connection.getQueue().getNumOfEntries() + " queue entries pending" + ": We were lucky, reconnected to " + connection.getGlobal().getId());
            }

            public void reachedPolling(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
                ServerHelper.this.log.warn(clientName, "DEBUG ONLY: Changed from connection state " + oldState + " to " + ConnectionStateEnum.POLLING + ": Lost connection to " + connection.getGlobal().getId());
            }

            public void reachedDead(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
                ServerHelper.this.log.error(clientName, "DEBUG ONLY: Changed from connection state " + oldState + " to " + ConnectionStateEnum.DEAD + ": Lost connection to " + connection.getGlobal().getId());
            }
        });
        ConnectQos qos = new ConnectQos(glob, clientName, "secret");
        ConnectReturnQos conRetQos = con.connect(qos, cb);
        this.log.info(clientName, "Connected to xmlBlaster.");
        return con;
    }

    private void setUp() {
        this.log.info(this.ME, "Entering setUp(), test starts");
        this.initHeron();
        this.initAvalon();
        this.initGolan();
        this.initFrodo();
        this.initBilbo();
    }

    public void tearDown() {
        this.log.info(this.ME, "Entering tearDown(), test is finished");
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.stopHeron();
        this.stopAvalon();
        this.stopGolan();
        this.stopFrodo();
        this.stopBilbo();
    }
}

