/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.cluster;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UnSubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UnSubscribeQos;
import org.xmlBlaster.client.qos.UnSubscribeReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.test.cluster.ServerHelper;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class SubscribeTest
extends TestCase {
    private String ME = "SubscribeTest";
    private Global glob = new Global(null, true, false);
    private LogChannel log;
    private ServerHelper serverHelper;
    private I_XmlBlasterAccess heronCon;
    private I_XmlBlasterAccess avalonCon;
    private I_XmlBlasterAccess golanCon;
    private I_XmlBlasterAccess frodoCon;
    private I_XmlBlasterAccess bilboCon;
    private I_XmlBlasterAccess bilboCon2;
    private int updateCounterHeron = 0;
    private int updateCounterFrodo = 0;
    private int updateCounterBilbo = 0;
    private int updateCounterBilbo2 = 0;
    private String oid = "SubscribeToBilbo";
    private String domain = "RUGBY_NEWS";
    private String contentStr = "We win";
    private String assertInUpdate = null;

    public SubscribeTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.log = this.glob.getLog(this.ME);
        this.log.info(this.ME, "Entering setUp(), test starts");
        this.updateCounterHeron = 0;
        this.updateCounterFrodo = 0;
        this.updateCounterBilbo = 0;
        this.updateCounterBilbo2 = 0;
        this.serverHelper = new ServerHelper(this.glob, this.log, this.ME);
        this.serverHelper.startHeron();
        this.serverHelper.startAvalon();
        this.serverHelper.startFrodo();
        this.serverHelper.startBilbo();
    }

    protected void tearDown() {
        this.log.info(this.ME, "Entering tearDown(), test is finished");
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.bilboCon != null) {
            this.bilboCon.disconnect(null);
            this.bilboCon = null;
        }
        if (this.bilboCon2 != null) {
            this.bilboCon2.disconnect(null);
            this.bilboCon2 = null;
        }
        if (this.frodoCon != null) {
            this.frodoCon.disconnect(null);
            this.frodoCon = null;
        }
        if (this.golanCon != null) {
            this.golanCon.disconnect(null);
            this.golanCon = null;
        }
        if (this.avalonCon != null) {
            this.avalonCon.disconnect(null);
            this.avalonCon = null;
        }
        if (this.heronCon != null) {
            this.heronCon.disconnect(null);
            this.heronCon = null;
        }
        this.serverHelper.tearDown();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSubscribeTwice() {
        block20: {
            block21: {
                System.err.println("***SubscribeTest.testSubscribeTwice: Subscribe a message from a cluster slave ...");
                try {
                    try {
                        System.err.println("->Connect to avalon ...");
                        this.avalonCon = this.serverHelper.connect(this.serverHelper.getAvalonGlob(), null);
                        System.err.println("->Connect to bilbo ...");
                        this.bilboCon = this.serverHelper.connect(this.serverHelper.getBilboGlob(), new I_Callback(){

                            public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
                                if (updateQos.isErased()) {
                                    SubscribeTest.this.log.info(SubscribeTest.this.ME, "Ignoring erase message");
                                    return "";
                                }
                                SubscribeTest.this.updateCounterBilbo++;
                                SubscribeTest.this.log.info(SubscribeTest.this.ME + ":" + SubscribeTest.this.serverHelper.getBilboGlob().getId(), "Receiving update '" + updateKey.getOid() + "' " + SubscribeTest.this.updateCounterBilbo + " ...");
                                Assert.assertEquals("Wrong message updated", SubscribeTest.this.oid, updateKey.getOid());
                                return "";
                            }
                        });
                        System.err.println("->Subscribe from bilbo ...");
                        SubscribeKey sk = new SubscribeKey(this.glob, this.oid);
                        sk.setDomain(this.domain);
                        SubscribeQos sq = new SubscribeQos(this.glob);
                        SubscribeReturnQos srq = this.bilboCon.subscribe(sk.toXml(), sq.toXml());
                        System.err.println("->Connect to bilbo 2 ...");
                        final Global bilboGlob2 = this.serverHelper.getBilboGlob().getClone(null);
                        this.bilboCon2 = this.serverHelper.connect(bilboGlob2, new I_Callback(){

                            public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
                                if (updateQos.isErased()) {
                                    SubscribeTest.this.log.info(SubscribeTest.this.ME, "Ignoring erase message");
                                    return "";
                                }
                                SubscribeTest.this.updateCounterBilbo2++;
                                SubscribeTest.this.log.info(SubscribeTest.this.ME + ":" + bilboGlob2.getId() + "#2", "Receiving update '" + updateKey.getOid() + "' " + SubscribeTest.this.updateCounterBilbo2 + " ...");
                                Assert.assertEquals("#2 Wrong message updated", SubscribeTest.this.oid, updateKey.getOid());
                                return "";
                            }
                        });
                        System.err.println("->Subscribe from bilbo 2 ...");
                        SubscribeKey sk2 = new SubscribeKey(this.glob, this.oid);
                        sk2.setDomain(this.domain);
                        SubscribeQos sq2 = new SubscribeQos(this.glob);
                        SubscribeReturnQos srq2 = this.bilboCon2.subscribe(sk2.toXml(), sq2.toXml());
                        System.err.println("->Publish to avalon ...");
                        PublishKey avalon_pk = new PublishKey(this.glob, this.oid, "text/plain", "1.0", this.domain);
                        PublishQos avalon_pq = new PublishQos(this.glob);
                        MsgUnit avalon_msgUnit = new MsgUnit(avalon_pk, this.contentStr, avalon_pq);
                        PublishReturnQos avalon_prq = this.avalonCon.publish(avalon_msgUnit);
                        Assert.assertEquals("oid changed", this.oid, avalon_prq.getKeyOid());
                        try {
                            Thread.currentThread();
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException i) {
                            // empty catch block
                        }
                        if (1 != this.updateCounterBilbo) {
                            this.log.error(this.ME, "Did not expect " + this.updateCounterBilbo + " updates");
                        }
                        Assert.assertEquals("message from avalon", 1, this.updateCounterBilbo);
                        if (1 != this.updateCounterBilbo2) {
                            this.log.error(this.ME, "Did not expect " + this.updateCounterBilbo2 + " updates");
                        }
                        Assert.assertEquals("message from avalon #2", 1, this.updateCounterBilbo2);
                        this.updateCounterBilbo = 0;
                        this.updateCounterBilbo2 = 0;
                        System.err.println("->testSubscribeTwice done, SUCCESS.");
                        System.err.println("->UnSubscribe from bilbo ...");
                        UnSubscribeKey usk = new UnSubscribeKey(this.glob, this.oid);
                        usk.setDomain(this.domain);
                        UnSubscribeQos usq = new UnSubscribeQos(this.glob);
                        UnSubscribeReturnQos[] usrq = this.bilboCon.unSubscribe(usk, usq);
                        Assert.assertEquals("", 1, usrq.length);
                        System.err.println("->Publish to avalon ...");
                        PublishKey avalon_pk2 = new PublishKey(this.glob, this.oid, "text/plain", "1.0", this.domain);
                        PublishQos avalon_pq2 = new PublishQos(this.glob);
                        MsgUnit avalon_msgUnit2 = new MsgUnit(avalon_pk2, this.contentStr, avalon_pq2);
                        PublishReturnQos avalon_prq2 = this.avalonCon.publish(avalon_msgUnit2);
                        Assert.assertEquals("oid changed", this.oid, avalon_prq2.getKeyOid());
                        try {
                            Thread.currentThread();
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException i) {
                            // empty catch block
                        }
                        if (0 != this.updateCounterBilbo) {
                            this.log.error(this.ME, "Did not expect " + this.updateCounterBilbo + " updates");
                        }
                        Assert.assertEquals("message from avalon", 0, this.updateCounterBilbo);
                        if (1 != this.updateCounterBilbo2) {
                            this.log.error(this.ME, "Did not expect " + this.updateCounterBilbo2 + " updates");
                        }
                        Assert.assertEquals("message from avalon #2", 1, this.updateCounterBilbo2);
                        this.updateCounterBilbo = 0;
                        this.updateCounterBilbo2 = 0;
                        System.err.println("->Trying to erase the message at the slave node ...");
                        EraseKey ek = new EraseKey(this.glob, this.oid);
                        ek.setDomain(this.domain);
                        EraseQos eq = new EraseQos(this.glob);
                        EraseReturnQos[] arr = this.avalonCon.erase(ek.toXml(), eq.toXml());
                        Assert.assertEquals("Erase", 1, arr.length);
                    }
                    catch (XmlBlasterException e) {
                        e.printStackTrace();
                        Assert.fail("SubscribeToBilbo-Exception: " + e.toString());
                        Object var10_12 = null;
                        if (this.bilboCon != null) {
                            this.bilboCon.disconnect(null);
                            this.bilboCon = null;
                        }
                        if (this.bilboCon2 != null) {
                            this.bilboCon2.disconnect(null);
                            this.bilboCon2 = null;
                        }
                        if (this.avalonCon != null) {
                            this.avalonCon.disconnect(null);
                            this.avalonCon = null;
                        }
                        break block20;
                    }
                    Object var10_11 = null;
                    if (this.bilboCon == null) break block21;
                    this.bilboCon.disconnect(null);
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    if (this.bilboCon != null) {
                        this.bilboCon.disconnect(null);
                        this.bilboCon = null;
                    }
                    if (this.bilboCon2 != null) {
                        this.bilboCon2.disconnect(null);
                        this.bilboCon2 = null;
                    }
                    if (this.avalonCon != null) {
                        this.avalonCon.disconnect(null);
                        this.avalonCon = null;
                    }
                    throw throwable;
                }
                this.bilboCon = null;
            }
            if (this.bilboCon2 != null) {
                this.bilboCon2.disconnect(null);
                this.bilboCon2 = null;
            }
            if (this.avalonCon != null) {
                this.avalonCon.disconnect(null);
                this.avalonCon = null;
            }
        }
        System.err.println("***SubscribeTest.testSubscribeTwice: testSubscribeTwice [SUCCESS]");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSubscribe() {
        block28: {
            int jj22;
            System.err.println("***SubscribeTest: Subscribe a message from a cluster slave ...");
            int num = 2;
            I_XmlBlasterAccess[] bilboCons = new I_XmlBlasterAccess[num];
            try {
                int jj22;
                block27: {
                    try {
                        System.err.println("->Connect to avalon ...");
                        this.avalonCon = this.serverHelper.connect(this.serverHelper.getAvalonGlob(), null);
                        try {
                            Thread.currentThread();
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException i) {
                            // empty catch block
                        }
                        int ii = 0;
                        while (true) {
                            if (ii >= num) {
                                System.err.println("->testSubscribe done, SUCCESS.");
                                break;
                            }
                            final int counter = ii;
                            System.err.println("->Connect to bilbo #" + ii + " ...");
                            final Global bilboGlobii = this.serverHelper.getBilboGlob().getClone(null);
                            bilboCons[ii] = this.serverHelper.connect(bilboGlobii, new I_Callback(){
                                int bilboConInstanceCounter;
                                {
                                    this.bilboConInstanceCounter = counter;
                                }

                                public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
                                    SubscribeTest.this.log.info(SubscribeTest.this.ME + ":" + bilboGlobii.getId() + "#" + this.bilboConInstanceCounter, "Receiving update '" + updateKey.getOid() + "' state=" + updateQos.getState() + ", " + SubscribeTest.this.updateCounterBilbo + " ...");
                                    if (updateQos.isErased()) {
                                        SubscribeTest.this.log.info(SubscribeTest.this.ME, "Ignoring erase message");
                                        return "";
                                    }
                                    SubscribeTest.this.updateCounterBilbo++;
                                    SubscribeTest.this.log.info(SubscribeTest.this.ME + ":" + bilboGlobii.getId() + "#" + this.bilboConInstanceCounter, "Receiving update '" + updateKey.getOid() + "' " + SubscribeTest.this.updateCounterBilbo + " ...");
                                    Assert.assertEquals("Wrong message updated", SubscribeTest.this.oid, updateKey.getOid());
                                    return "";
                                }
                            });
                            System.err.println("->Publish to avalon #" + ii + " ...");
                            PublishKey avalon_pk = new PublishKey(this.glob, this.oid, "text/plain", "1.0", this.domain);
                            PublishQos avalon_pq = new PublishQos(this.glob);
                            MsgUnit avalon_msgUnit = new MsgUnit(avalon_pk, this.contentStr, avalon_pq);
                            PublishReturnQos avalon_prq = this.avalonCon.publish(avalon_msgUnit);
                            Assert.assertEquals("oid changed", this.oid, avalon_prq.getKeyOid());
                            try {
                                Thread.currentThread();
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException i) {
                                // empty catch block
                            }
                            System.err.println("->Subscribe from bilbo #" + ii + ", the message from avalon should arrive ...");
                            SubscribeKey sk = new SubscribeKey(this.glob, this.oid);
                            sk.setDomain(this.domain);
                            SubscribeQos sq = new SubscribeQos(this.glob);
                            SubscribeReturnQos srq = bilboCons[ii].subscribe(sk.toXml(), sq.toXml());
                            this.waitOnUpdate(2000L, 1);
                            try {
                                Thread.currentThread();
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException i) {
                                // empty catch block
                            }
                            if (1 != this.updateCounterBilbo) {
                                this.log.error(this.ME, "Did not expect " + this.updateCounterBilbo + " updates");
                            }
                            Assert.assertEquals("message from avalon", 1, this.updateCounterBilbo);
                            this.updateCounterBilbo = 0;
                            System.err.println("->Trying to erase the message at the slave node ...");
                            EraseKey ek = new EraseKey(this.glob, this.oid);
                            ek.setDomain(this.domain);
                            EraseQos eq = new EraseQos(this.glob);
                            EraseReturnQos[] arr = this.avalonCon.erase(ek.toXml(), eq.toXml());
                            Assert.assertEquals("Erase", 1, arr.length);
                            try {
                                Thread.currentThread();
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException i) {
                                // empty catch block
                            }
                            this.updateCounterBilbo = 0;
                            this.updateCounterBilbo2 = 0;
                            bilboCons[ii].getCbServer().shutdown();
                            ++ii;
                        }
                    }
                    catch (XmlBlasterException e) {
                        e.printStackTrace();
                        Assert.fail("SubscribeToBilbo-Exception: " + e.toString());
                        Object var18_22 = null;
                        jj22 = 0;
                        break block27;
                    }
                    Object var18_21 = null;
                    int jj22 = 0;
                    while (true) {
                        if (jj22 >= bilboCons.length) {
                            if (this.avalonCon != null) {
                                this.avalonCon.disconnect(null);
                                this.avalonCon = null;
                            }
                            break block28;
                        }
                        if (bilboCons[jj22] != null) {
                            bilboCons[jj22].disconnect(null);
                            bilboCons[jj22] = null;
                        }
                        ++jj22;
                    }
                }
                while (true) {
                    if (jj22 >= bilboCons.length) {
                        if (this.avalonCon == null) break;
                        this.avalonCon.disconnect(null);
                        this.avalonCon = null;
                        break;
                    }
                    if (bilboCons[jj22] != null) {
                        bilboCons[jj22].disconnect(null);
                        bilboCons[jj22] = null;
                    }
                    ++jj22;
                }
                break block28;
            }
            catch (Throwable throwable) {
                Object var18_23 = null;
                jj22 = 0;
            }
            while (true) {
                if (jj22 >= bilboCons.length) {
                    if (this.avalonCon != null) {
                        this.avalonCon.disconnect(null);
                        this.avalonCon = null;
                    }
                    throw throwable;
                }
                if (bilboCons[jj22] != null) {
                    bilboCons[jj22].disconnect(null);
                    bilboCons[jj22] = null;
                }
                ++jj22;
            }
        }
        System.err.println("***SubscribeTest: testSubscribe [SUCCESS]");
    }

    private void waitOnUpdate(long timeout, int numWait) {
        long pollingInterval = 50L;
        if (timeout < 50L) {
            pollingInterval = timeout / 10L;
        }
        long sum = 0L;
        while (this.updateCounterBilbo < numWait) {
            try {
                Thread.currentThread();
                Thread.sleep(pollingInterval);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            if ((sum += pollingInterval) <= timeout) continue;
            this.log.warn(this.ME, "Timeout of " + timeout + " occurred");
            break;
        }
    }
}

