/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.cluster;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.test.cluster.ServerHelper;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class SubscribeXPathTest
extends TestCase {
    private String ME = "SubscribeXPathTest";
    private Global glob = new Global(null, true, false);
    private LogChannel log;
    private ServerHelper serverHelper;
    private I_XmlBlasterAccess heronCon;
    private I_XmlBlasterAccess avalonCon;
    private I_XmlBlasterAccess golanCon;
    private I_XmlBlasterAccess frodoCon;
    private I_XmlBlasterAccess bilboCon;
    private int updateCounterHeron = 0;
    private int updateCounterFrodo = 0;
    private int updateCounterBilbo = 0;
    private String oid = "SubscribeToBilbo";
    private String domain = "RUGBY_NEWS";
    private String contentStr = "We win";
    private String assertInUpdate = null;

    public SubscribeXPathTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.log = this.glob.getLog(this.ME);
        this.log.info(this.ME, "Entering setUp(), test starts");
        this.updateCounterHeron = 0;
        this.updateCounterFrodo = 0;
        this.updateCounterBilbo = 0;
        this.serverHelper = new ServerHelper(this.glob, this.log, this.ME);
        this.serverHelper.startHeron();
        this.serverHelper.startAvalon();
        this.serverHelper.startFrodo();
        this.serverHelper.startBilbo();
    }

    protected void tearDown() {
        this.log.info(this.ME, "Entering tearDown(), test is finished");
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.bilboCon != null) {
            this.bilboCon.disconnect(null);
            this.bilboCon = null;
        }
        if (this.frodoCon != null) {
            this.frodoCon.disconnect(null);
            this.frodoCon = null;
        }
        if (this.golanCon != null) {
            this.golanCon.disconnect(null);
            this.golanCon = null;
        }
        if (this.avalonCon != null) {
            this.avalonCon.disconnect(null);
            this.avalonCon = null;
        }
        if (this.heronCon != null) {
            this.heronCon.disconnect(null);
            this.heronCon = null;
        }
        this.serverHelper.tearDown();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSubscribeXpath() {
        block12: {
            block13: {
                System.err.println("***SubscribeXPathTest.testSubscribeXpath: Subscribe a message from a cluster slave ...");
                try {
                    try {
                        System.err.println("->Connect to avalon ...");
                        this.avalonCon = this.serverHelper.connect(this.serverHelper.getAvalonGlob(), null);
                        System.err.println("->Connect to bilbo ...");
                        this.bilboCon = this.serverHelper.connect(this.serverHelper.getBilboGlob(), new I_Callback(){

                            public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
                                SubscribeXPathTest.this.updateCounterBilbo++;
                                SubscribeXPathTest.this.log.info(SubscribeXPathTest.this.ME + ":" + SubscribeXPathTest.this.serverHelper.getBilboGlob().getId(), "Receiving update '" + updateKey.getOid() + "' " + SubscribeXPathTest.this.updateCounterBilbo + " ...");
                                Assert.assertEquals("Wrong message updated", SubscribeXPathTest.this.oid, updateKey.getOid());
                                return "";
                            }
                        });
                        System.err.println("->Subscribe from bilbo ...");
                        SubscribeKey sk = new SubscribeKey(this.glob, "/xmlBlaster/key[@oid='SubscribeToBilbo']", "XPATH");
                        sk.setDomain(this.domain);
                        SubscribeQos sq = new SubscribeQos(this.glob);
                        SubscribeReturnQos srq = this.bilboCon.subscribe(sk.toXml(), sq.toXml());
                        System.err.println("->Publish to avalon ...");
                        PublishKey avalon_pk = new PublishKey(this.glob, this.oid, "text/plain", "1.0", this.domain);
                        PublishQos avalon_pq = new PublishQos(this.glob);
                        MsgUnit avalon_msgUnit = new MsgUnit(avalon_pk, this.contentStr, avalon_pq);
                        PublishReturnQos avalon_prq = this.avalonCon.publish(avalon_msgUnit);
                        Assert.assertEquals("oid changed", this.oid, avalon_prq.getKeyOid());
                        try {
                            Thread.currentThread();
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException i) {
                            // empty catch block
                        }
                        if (1 != this.updateCounterBilbo) {
                            this.log.error(this.ME, "Did not expect " + this.updateCounterBilbo + " updates");
                        }
                        Assert.assertEquals("message from avalon", 1, this.updateCounterBilbo);
                        this.updateCounterBilbo = 0;
                        System.err.println("->testSubscribeXpath done, SUCCESS.");
                        System.err.println("->Trying to unSubscribe ...");
                        this.bilboCon.unSubscribe("<key oid='" + srq.getSubscriptionId() + "'/>", null);
                        System.err.println("->Trying to erase the message at the slave node ...");
                        EraseKey ek = new EraseKey(this.glob, this.oid);
                        ek.setDomain(this.domain);
                        EraseQos eq = new EraseQos(this.glob);
                        EraseReturnQos[] arr = this.avalonCon.erase(ek.toXml(), eq.toXml());
                        Assert.assertEquals("Erase", 1, arr.length);
                    }
                    catch (XmlBlasterException e) {
                        e.printStackTrace();
                        Assert.fail("SubscribeToBilbo-Exception: " + e.toString());
                        Object var12_14 = null;
                        if (this.bilboCon != null) {
                            this.bilboCon.disconnect(null);
                            this.bilboCon = null;
                        }
                        if (this.avalonCon != null) {
                            this.avalonCon.disconnect(null);
                            this.avalonCon = null;
                        }
                        break block12;
                    }
                    Object var12_13 = null;
                    if (this.bilboCon == null) break block13;
                    this.bilboCon.disconnect(null);
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    if (this.bilboCon != null) {
                        this.bilboCon.disconnect(null);
                        this.bilboCon = null;
                    }
                    if (this.avalonCon != null) {
                        this.avalonCon.disconnect(null);
                        this.avalonCon = null;
                    }
                    throw throwable;
                }
                this.bilboCon = null;
            }
            if (this.avalonCon != null) {
                this.avalonCon.disconnect(null);
                this.avalonCon = null;
            }
        }
        System.err.println("***SubscribeXPathTest.testSubscribeXpath: testSubscribeXpath [SUCCESS]");
    }
}

