/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.dispatch;

import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.dispatch.plugins.prio.ConfigurationParser;
import org.xmlBlaster.util.dispatch.plugins.prio.DispatchAction;
import org.xmlBlaster.util.dispatch.plugins.prio.StatusConfiguration;

public class ConfigurationParserTest
extends TestCase {
    protected Global glob;
    protected LogChannel log;
    int counter = 0;

    public ConfigurationParserTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.glob = Global.instance();
        this.log = this.glob.getLog(null);
    }

    protected void tearDown() {
        this.glob = null;
        this.log = null;
        Global.instance().shutdown();
    }

    public void testParse() {
        System.out.println("***ConfigurationParserTest: testParse ...");
        try {
            String xml = "<msgDispatch defaultStatus='64k' defaultAction='send'>\n  <onStatus oid='_bandwidth.status' content='64k' defaultAction='destroy'>\n    <action do='send'  ifPriority='7-9'/>\n    <action do='queue'  ifPriority='3-6'/>\n    <action do='queue|notifySender'  ifPriority='2'/>\n  </onStatus>\n  <onStatus oid='_bandwidth.status' content='2M'>\n    <action do='send'/>\n  </onStatus>\n  <onStatus oid='_bandwidth.status' content='DOWN' defaultAction='queue' connectionState='polling'>\n    <action do='destroy'/>\n  </onStatus>\n</msgDispatch>\n";
            ConfigurationParser parser = new ConfigurationParser(this.glob, xml);
            Assert.assertEquals("", "send", parser.getDefaultDispatchAction().getAction());
            Assert.assertEquals("", "64k", parser.getDefaultStatus());
            Map confMap = parser.getStatusConfigurationMap();
            Assert.assertEquals("Illegal map size", 3, confMap.size());
            Assert.assertTrue("Missing key", confMap.containsKey("64k"));
            Assert.assertTrue("Missing key", confMap.containsKey("2M"));
            Assert.assertTrue("Missing key", confMap.containsKey("DOWN"));
            StatusConfiguration conf = (StatusConfiguration)confMap.get("64k");
            Assert.assertEquals("", "_bandwidth.status", conf.getOid());
            Assert.assertEquals("", "64k", conf.getContent());
            Assert.assertEquals("", (Object)null, conf.getConnectionState());
            Assert.assertEquals("", "destroy", conf.getDefaultDispatchAction().getAction());
            Assert.assertEquals("", false, conf.defaultActionOnly());
            int i = 7;
            while (i <= 9) {
                DispatchAction action = conf.getDispatchAction(PriorityEnum.toPriorityEnum(i));
                Assert.assertEquals("Wrong action string", "send", action.getAction());
                Assert.assertEquals("Wrong boolean action", true, action.doSend());
                Assert.assertEquals("Wrong boolean action", false, action.doQueue());
                Assert.assertEquals("Wrong boolean action", false, action.doDestroy());
                Assert.assertEquals("Wrong boolean action", false, action.doNotifySender());
                ++i;
            }
            int i2 = 3;
            while (i2 <= 6) {
                DispatchAction action = conf.getDispatchAction(PriorityEnum.toPriorityEnum(i2));
                Assert.assertEquals("Wrong action string", "queue", action.getAction());
                Assert.assertEquals("Wrong boolean action", false, action.doSend());
                Assert.assertEquals("Wrong boolean action", true, action.doQueue());
                Assert.assertEquals("Wrong boolean action", false, action.doDestroy());
                Assert.assertEquals("Wrong boolean action", false, action.doNotifySender());
                ++i2;
            }
            int i3 = 2;
            while (i3 <= 2) {
                DispatchAction action = conf.getDispatchAction(PriorityEnum.toPriorityEnum(i3));
                Assert.assertEquals("Wrong action string", "queue|notifySender", action.getAction());
                Assert.assertEquals("Wrong boolean action", false, action.doSend());
                Assert.assertEquals("Wrong boolean action", true, action.doQueue());
                Assert.assertEquals("Wrong boolean action", false, action.doDestroy());
                Assert.assertEquals("Wrong boolean action", true, action.doNotifySender());
                ++i3;
            }
            int i4 = 0;
            while (i4 <= 1) {
                DispatchAction action = conf.getDispatchAction(PriorityEnum.toPriorityEnum(i4));
                Assert.assertEquals("Wrong action string", "destroy", action.getAction());
                Assert.assertEquals("Wrong boolean action", false, action.doSend());
                Assert.assertEquals("Wrong boolean action", false, action.doQueue());
                Assert.assertEquals("Wrong boolean action", true, action.doDestroy());
                Assert.assertEquals("Wrong boolean action", false, action.doNotifySender());
                ++i4;
            }
            conf = (StatusConfiguration)confMap.get("2M");
            Assert.assertEquals("", "_bandwidth.status", conf.getOid());
            Assert.assertEquals("", "2M", conf.getContent());
            Assert.assertEquals("", (Object)null, conf.getConnectionState());
            Assert.assertEquals("", "send", conf.getDefaultDispatchAction().getAction());
            Assert.assertEquals("", true, conf.defaultActionOnly());
            int i5 = 0;
            while (i5 <= 9) {
                DispatchAction action = conf.getDispatchAction(PriorityEnum.toPriorityEnum(i5));
                Assert.assertEquals("Wrong action string", "send", action.getAction());
                Assert.assertEquals("Wrong boolean action", true, action.doSend());
                Assert.assertEquals("Wrong boolean action", false, action.doQueue());
                Assert.assertEquals("Wrong boolean action", false, action.doDestroy());
                Assert.assertEquals("Wrong boolean action", false, action.doNotifySender());
                ++i5;
            }
            conf = (StatusConfiguration)confMap.get("DOWN");
            Assert.assertEquals("", "_bandwidth.status", conf.getOid());
            Assert.assertEquals("", "DOWN", conf.getContent());
            Assert.assertEquals("", "POLLING", conf.getConnectionState().toString());
            Assert.assertEquals("", "queue", conf.getDefaultDispatchAction().getAction());
            Assert.assertEquals("", false, conf.defaultActionOnly());
            int i6 = 0;
            while (i6 <= 9) {
                DispatchAction action = conf.getDispatchAction(PriorityEnum.toPriorityEnum(i6));
                Assert.assertEquals("Wrong action string", "destroy", action.getAction());
                Assert.assertEquals("Wrong boolean action", false, action.doSend());
                Assert.assertEquals("Wrong boolean action", false, action.doQueue());
                Assert.assertEquals("Wrong boolean action", true, action.doDestroy());
                Assert.assertEquals("Wrong boolean action", false, action.doNotifySender());
                ++i6;
            }
        }
        catch (XmlBlasterException e) {
            Assert.fail("testParse failed: " + e.toString());
        }
        System.out.println("***ConfigurationParserTest: testParse [SUCCESS]");
    }

    public void testInvalidParse() {
        ConfigurationParser parser;
        String xml;
        System.out.println("***ConfigurationParserTest: testInvalidParse ...");
        try {
            xml = "<msgDispatch defaultStatus='64k' defaultAction='sendXXXX'/>";
            parser = new ConfigurationParser(this.glob, xml);
            Assert.fail("testInvalidParse failed, invalid xml should not be parseable");
        }
        catch (XmlBlasterException e) {
            System.out.println("Success: Expected exception: " + e.toString());
        }
        try {
            xml = "<msgDispatch defaultStatus='64k' defaultAction='send'>\n  <onStatus oid='_bandwidth.status' content='64k' defaultAction='destroy'>\n    <action do='send'  ifPriority='7-99'/>\n  </onStatus>\n</msgDispatch>\n";
            parser = new ConfigurationParser(this.glob, xml);
            Assert.fail("testInvalidParse failed, invalid xml should not be parseable, prio is not allowed");
        }
        catch (XmlBlasterException e) {
            System.out.println("Success: Expected exception: " + e.toString());
        }
        try {
            xml = "<msgDispatch defaultStatus='64k' defaultAction='send'>\n  <onStatus oid='_bandwidth.status' content='64k' defaultAction='destroy'>\n    <action do='sendXXX'  ifPriority='7'/>\n  </onStatus>\n</msgDispatch>\n";
            parser = new ConfigurationParser(this.glob, xml);
            Assert.fail("testInvalidParse failed, invalid xml should not be parseable, action is invalid");
        }
        catch (XmlBlasterException e) {
            System.out.println("Success: Expected exception: " + e.toString());
        }
        try {
            xml = "<msgDispatch defaultStatus='64k' defaultAction='send'>\n  <onStatus oid='_bandwidth.status' content='64k' defaultAction='XXXXdestroy'>\n    <action do='send'  ifPriority='7'/>\n  </onStatus>\n</msgDispatch>\n";
            parser = new ConfigurationParser(this.glob, xml);
            Assert.fail("testInvalidParse failed, invalid xml should not be parseable");
        }
        catch (XmlBlasterException e) {
            System.out.println("Success: Expected exception: " + e.toString());
        }
        try {
            xml = "<msgDispatch>\n  <onStatus oid='_bandwidth.status' content='64k'>\n    <action do='send|queue'  ifPriority='7'/>\n  </onStatus>\n</msgDispatch>\n";
            parser = new ConfigurationParser(this.glob, xml);
            Assert.fail("testInvalidParse failed, some combination of actions are invalid");
        }
        catch (XmlBlasterException e) {
            System.out.println("Success: Expected exception: " + e.toString());
        }
        System.out.println("***ConfigurationParserTest: testInvalidParse [SUCCESS]");
    }

    public void testDefault() {
        System.out.println("***ConfigurationParserTest: testDefault ...");
        try {
            ConfigurationParser parser = new ConfigurationParser(this.glob, null);
            Assert.assertEquals("", "send", parser.getDefaultDispatchAction().getAction());
            Assert.assertTrue("", null == parser.getDefaultStatus());
            Map confMap = parser.getStatusConfigurationMap();
            Assert.assertEquals("Illegal map size", 0, confMap.size());
            StatusConfiguration conf = parser.getStatusConfiguration((String)null);
            Assert.assertTrue("", null == conf.getOid());
            Assert.assertTrue("", null == conf.getContent());
            Assert.assertEquals("", (Object)null, conf.getConnectionState());
            Assert.assertEquals("", true, conf.defaultActionOnly());
            Assert.assertEquals("", "send", conf.getDefaultDispatchAction().getAction());
            int i = 0;
            while (i <= 9) {
                DispatchAction action = conf.getDispatchAction(PriorityEnum.toPriorityEnum(i));
                Assert.assertEquals("Wrong action string", "send", action.getAction());
                Assert.assertEquals("Wrong boolean action", true, action.doSend());
                Assert.assertEquals("Wrong boolean action", false, action.doQueue());
                Assert.assertEquals("Wrong boolean action", false, action.doDestroy());
                Assert.assertEquals("Wrong boolean action", false, action.doNotifySender());
                ++i;
            }
        }
        catch (XmlBlasterException e) {
            Assert.fail("testDefault failed: " + e.toString());
        }
        System.out.println("***ConfigurationParserTest: testDefault [SUCCESS]");
    }

    public static void main(String[] args) {
        try {
            ConfigurationParserTest testSub = new ConfigurationParserTest("ConfigurationParserTest");
            testSub.setUp();
            testSub.testDefault();
            testSub.testParse();
            testSub.testInvalidParse();
            testSub.tearDown();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("ERROR: " + e.toString());
        }
    }
}

