/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.dispatch;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.test.Msg;
import org.xmlBlaster.test.MsgInterceptor;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public class TestPriorizedDispatchPlugin
extends TestCase {
    private static String ME = "TestPriorizedDispatchPlugin";
    private Global glob;
    private LogChannel log;
    private I_XmlBlasterAccess con = null;
    private String name;
    private String passwd = "secret";
    private EmbeddedXmlBlaster serverThread;
    private int serverPort = 9560;
    private boolean startEmbedded = true;
    private MsgInterceptor update;
    private final String msgOid = "dispatchTestMessage";
    private int msgSequenceNumber = 0;
    private String statusOid = "_bandwidth.status";
    private String NORMAL_LINE = "2M";
    private String BACKUP_LINE = "64k";
    private String DEAD_LINE = "DOWN";
    private String[] states = new String[]{this.NORMAL_LINE, this.BACKUP_LINE, this.DEAD_LINE};
    private String[][] expectedActions = new String[][]{{"send", "send", "send", "send", "send", "send", "send", "send", "send", "send"}, {"destroy", "destroy", "destroy", "destroy", "queue", "queue", "queue,notifySender", "send", "send", "send"}, {"destroy", "destroy", "destroy", "destroy", "queue", "queue", "queue", "queue", "queue", "queue"}};

    public TestPriorizedDispatchPlugin(Global glob, String testName, String name) {
        super(testName);
        this.glob = glob;
        this.log = glob.getLog("test");
        this.name = name;
    }

    protected void setUp() {
        this.startEmbedded = this.glob.getProperty().get("startEmbedded", this.startEmbedded);
        String[] args = new String[]{"-DispatchPlugin[Priority][1.0]", "org.xmlBlaster.util.dispatch.plugins.prio.PriorizedDispatchPlugin", "-DispatchPlugin/defaultPlugin", "undef", "-PriorizedDispatchPlugin/user", "_PriorizedDispatchPlugin", "-PriorizedDispatchPlugin/config", "<msgDispatch defaultStatus='" + this.BACKUP_LINE + "' defaultAction='send'>\n" + "  <onStatus oid='" + this.statusOid + "' content='" + this.NORMAL_LINE + "' defaultAction='send'>\n" + "  </onStatus>\n" + "  <onStatus oid='" + this.statusOid + "' content='" + this.BACKUP_LINE + "' defaultAction='send'>\n" + "     <action do='send'  ifPriority='7'/>\n" + "     <action do='queue,notifySender'  ifPriority='6'/>\n" + "     <action do='queue'  ifPriority='4-5'/>\n" + "     <action do='destroy'  ifPriority='0-3'/>\n" + "  </onStatus>\n" + "  <onStatus oid='" + this.statusOid + "' content='" + this.DEAD_LINE + "' defaultAction='queue'>\n" + "    <action do='destroy'  ifPriority='0-3'/>\n" + "  </onStatus>\n" + "</msgDispatch>\n"};
        this.glob.init(args);
        if (this.startEmbedded) {
            this.glob.init(Util.getOtherServerPorts(this.serverPort));
            this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.glob);
            this.log.info(ME, "XmlBlaster is ready for testing the priority dispatch plugin");
        }
        try {
            this.log.info(ME, "Connecting ...");
            this.con = this.glob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(this.glob, this.name, this.passwd);
            CallbackAddress cbAddress = new CallbackAddress(this.glob);
            cbAddress.setDispatchPlugin("Priority,1.0");
            qos.addCallbackAddress(cbAddress);
            this.update = new MsgInterceptor(this.glob, this.log, null);
            this.con.connect(qos, this.update);
        }
        catch (Exception e) {
            Thread.currentThread();
            Thread.dumpStack();
            this.log.error(ME, "Can't connect to xmlBlaster: " + e.toString());
        }
        this.update.clear();
    }

    private void changeStatus(String oid, String state) {
        this.log.info(ME, "Changing band width state to '" + state + "'");
        try {
            PublishReturnQos rq = this.con.publish(new MsgUnit(this.glob, "<key oid='" + oid + "'/>", state, null));
            this.log.info(ME, "SUCCESS for state change to '" + state + "', " + rq.getState());
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {}
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.fail("publish bandwidth state - XmlBlasterException: " + e.getMessage());
        }
    }

    private void publish(String oid, int priority) {
        PriorityEnum prio = PriorityEnum.toPriorityEnum(priority);
        try {
            ++this.msgSequenceNumber;
            String content = "" + this.msgSequenceNumber;
            PublishQos pq = new PublishQos(this.glob);
            pq.setPriority(prio);
            PublishReturnQos rq = this.con.publish(new MsgUnit("<key oid='" + oid + "'/>", content.getBytes(), pq.toXml()));
            this.log.info(ME, "SUCCESS publish '" + oid + "' with prio=" + prio.toString() + " content=" + content + " returned state=" + rq.getState());
            Assert.assertEquals("Returned oid wrong", oid, rq.getKeyOid());
            Assert.assertEquals("Return not OK", "OK", rq.getState());
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.fail("publish prio=" + prio.toString() + " - XmlBlasterException: " + e.getMessage());
        }
    }

    private void subscribe(String oid) {
        try {
            SubscribeKey sk = new SubscribeKey(this.glob, oid);
            SubscribeQos sq = new SubscribeQos(this.glob);
            SubscribeReturnQos srq = this.con.subscribe(sk.toXml(), sq.toXml());
            this.log.info(ME, "SUCCESS subscribe to '" + oid + "' returned state=" + srq.getState());
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.fail("subscribe - XmlBlasterException: " + e.getMessage());
        }
    }

    public void testPriorizedDispatchPlugin() {
        this.log.info(ME, "testPriorizedDispatchPlugin() ...");
        long sleep = 1000L;
        this.subscribe("dispatchTestMessage");
        int queueCounter = 0;
        int destroyCounter = 0;
        try {
            String text;
            int i = 0;
            while (i < this.states.length) {
                this.changeStatus(this.statusOid, this.states[i]);
                this.log.info(ME, "========================state=" + this.states[i]);
                int priority = 0;
                while (priority < this.expectedActions[i].length) {
                    int count;
                    String action = this.expectedActions[i][priority];
                    text = "state=" + this.states[i] + " action=" + action;
                    this.log.info(ME, "Doing " + text + " queueCounter=" + queueCounter);
                    boolean expectsNotify = false;
                    if (action.indexOf("notifySender") >= 0) {
                        expectsNotify = true;
                        this.log.info(ME, text + ": Expecting notify");
                    }
                    if (action.startsWith("send")) {
                        this.publish("dispatchTestMessage", priority);
                        Assert.assertEquals(text, 1, this.update.waitOnUpdate(sleep, "dispatchTestMessage", "OK"));
                        count = expectsNotify ? 2 : 1;
                        Assert.assertEquals(text, count, this.update.count());
                        if (expectsNotify) {
                            String expectedState = "send,notifySender";
                            Msg msg = this.update.getMsg("dispatchTestMessage", expectedState);
                            Assert.assertTrue("send,notifySender PtP not arrived", msg != null);
                        }
                    } else if (action.startsWith("queue")) {
                        this.publish("dispatchTestMessage", priority);
                        ++queueCounter;
                        Assert.assertEquals(text, 0, this.update.waitOnUpdate(sleep, "dispatchTestMessage", "OK"));
                        count = expectsNotify ? 1 : 0;
                        Assert.assertEquals(text, count, this.update.count());
                        if (expectsNotify) {
                            Assert.assertEquals(text, "_PriorizedDispatchPlugin", this.update.getMsgs()[0].getUpdateQos().getSender().getLoginName());
                        }
                    } else if (action.startsWith("destroy")) {
                        this.publish("dispatchTestMessage", priority);
                        ++destroyCounter;
                        Assert.assertEquals(text, 0, this.update.waitOnUpdate(sleep, "dispatchTestMessage", "OK"));
                        count = expectsNotify ? 1 : 0;
                        Assert.assertEquals(text, count, this.update.count());
                        if (expectsNotify) {
                            Assert.assertEquals(text, "_PriorizedDispatchPlugin", this.update.getMsgs()[0].getUpdateQos().getSender().getLoginName());
                        }
                    } else {
                        this.log.error(ME, text + ": Action is not supported");
                        Assert.fail(text + ": Action is not supported");
                    }
                    this.update.clear();
                    ++priority;
                }
                ++i;
            }
            text = "Checking ascending sequence of flushed " + queueCounter + " messages which where hold back";
            this.update.clear();
            this.changeStatus(this.statusOid, this.NORMAL_LINE);
            Assert.assertEquals(text, queueCounter, this.update.waitOnUpdate(2000L, "dispatchTestMessage", "OK"));
            Assert.assertEquals(text, queueCounter, this.update.count());
            Msg[] msgArr = this.update.getMsgs();
            Assert.assertEquals(text, queueCounter, msgArr.length);
            int lastNum = -1;
            int lastPrio = PriorityEnum.MAX_PRIORITY.getInt() + 1;
            int i2 = 0;
            while (i2 < msgArr.length) {
                this.log.info(ME, "Received flushed hold back message " + msgArr[i2].getUpdateKey().getOid() + " priority=" + msgArr[i2].getUpdateQos().getPriority() + " content=" + msgArr[i2].getContentStr() + " state=" + msgArr[i2].getUpdateQos().getState());
                ++i2;
            }
            int i3 = 0;
            while (i3 < msgArr.length) {
                int currPrio = msgArr[i3].getUpdateQos().getPriority().getInt();
                int currNum = msgArr[i3].getContentInt();
                if (lastPrio < currPrio || lastPrio == currPrio && lastNum >= currNum) {
                    Assert.fail(text + " Sequence is not ascending: last=" + lastNum + " curr=" + currNum);
                }
                lastNum = currNum;
                lastPrio = currPrio;
                ++i3;
            }
            this.update.clear();
        }
        catch (XmlBlasterException e) {
            Assert.fail(e.toString());
        }
        this.log.info(ME, "Success in testPriorizedDispatchPlugin()");
    }

    public void testPriorizedDispatchPluginReconfigure() {
        this.log.info(ME, "testPriorizedDispatchPluginReconfigure() ...");
        String statusOid2 = this.statusOid + "-2";
        String config = "<msgDispatch defaultStatus='GO' defaultAction='send'>\n  <onStatus oid='" + this.statusOid + "' content='GO' defaultAction='send'>\n" + "    <action do='send'  ifPriority='0-9'/>\n" + "  </onStatus>\n" + "  <onStatus oid='" + statusOid2 + "' content='" + this.BACKUP_LINE + "' defaultAction='send'>\n" + "     <action do='queue'  ifPriority='0-9'/>\n" + "  </onStatus>\n" + "</msgDispatch>\n";
        this.publishNewConfig(config);
        String text = "Testing configuration";
        long sleep = 2000L;
        this.subscribe("dispatchTestMessage");
        int maxPrio = PriorityEnum.MAX_PRIORITY.getInt() + 1;
        this.changeStatus(this.statusOid, "GO");
        int priority = 0;
        while (priority < maxPrio) {
            this.publish("dispatchTestMessage", priority);
            ++priority;
        }
        Assert.assertEquals(text, maxPrio, this.update.waitOnUpdate(sleep, "dispatchTestMessage", "OK"));
        this.log.info(ME, "SUCCESS, state=GO");
        this.update.clear();
        this.changeStatus(statusOid2, this.BACKUP_LINE);
        int priority2 = 0;
        while (priority2 < maxPrio) {
            this.publish("dispatchTestMessage", priority2);
            ++priority2;
        }
        Assert.assertEquals(text, 0, this.update.waitOnUpdate(sleep, "dispatchTestMessage", "OK"));
        this.log.info(ME, "SUCCESS, state=" + this.BACKUP_LINE);
        this.update.clear();
        this.changeStatus(this.statusOid, "GO");
        Assert.assertEquals(text, maxPrio, this.update.waitOnUpdate(sleep, "dispatchTestMessage", "OK"));
        this.log.info(ME, "SUCCESS, state=GO");
        this.update.clear();
        this.changeStatus(this.statusOid, "??YYXX");
        int priority3 = 0;
        while (priority3 < maxPrio) {
            this.publish("dispatchTestMessage", priority3);
            ++priority3;
        }
        Assert.assertEquals(text, maxPrio, this.update.waitOnUpdate(sleep, "dispatchTestMessage", "OK"));
        this.log.info(ME, "SUCCESS, state=GO");
        this.update.clear();
        this.log.info(ME, "Success in testPriorizedDispatchPluginReconfigure()");
    }

    private void publishNewConfig(String config) {
        String configKey = "PriorizedDispatchPlugin/config";
        try {
            String oid = "__cmd:sysprop/?" + configKey;
            String contentStr = config;
            PublishQos pq = new PublishQos(this.glob);
            PublishReturnQos rq = this.con.publish(new MsgUnit("<key oid='" + oid + "'/>", contentStr.getBytes(), pq.toXml()));
            this.log.info(ME, "SUCCESS publish new configuration '" + oid + "' returned state=" + rq.getState());
            Assert.assertEquals("Returned oid wrong", oid, rq.getKeyOid());
            Assert.assertEquals("Return not OK", "OK", rq.getState());
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.toString());
            Assert.fail("publish of configuration data - XmlBlasterException: " + e.getMessage());
        }
    }

    public void testPriorizedDispatchPluginOne() {
        this.log.info(ME, "testPriorizedDispatchPluginOne() ...");
        long sleep = 2000L;
        String text = "state=" + this.BACKUP_LINE + " action=queue,notifySender";
        this.subscribe("dispatchTestMessage");
        this.changeStatus(this.statusOid, this.BACKUP_LINE);
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        int priority = 6;
        this.log.info(ME, text + ": Expecting notify");
        this.update.clear();
        this.publish("dispatchTestMessage", priority);
        Assert.assertEquals(text, 0, this.update.waitOnUpdate(sleep, "dispatchTestMessage", "OK"));
        Assert.assertEquals(text, 1, this.update.count());
        Assert.assertEquals(text, "_PriorizedDispatchPlugin", this.update.getMsgs()[0].getUpdateQos().getSender().getLoginName());
        this.update.clear();
        this.changeStatus(this.statusOid, this.NORMAL_LINE);
        this.log.info(ME, text + ": Expecting queued message");
        Assert.assertEquals(text, 1, this.update.waitOnUpdate(sleep, "dispatchTestMessage", "OK"));
        this.log.info(ME, "Success in testPriorizedDispatchPluginOne()");
    }

    protected void tearDown() {
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        this.con.disconnect(null);
        this.con = null;
        if (this.startEmbedded) {
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
            this.serverThread = null;
        }
        Util.resetPorts(this.glob);
        this.glob = null;
        this.log = null;
        this.con = null;
        this.update = null;
        Global.instance().shutdown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "PriorizedDispatchPlugin";
        suite.addTest(new TestPriorizedDispatchPlugin(Global.instance(), "testPriorizedDispatchPluginOne", "PriorizedDispatchPluginOne"));
        suite.addTest(new TestPriorizedDispatchPlugin(Global.instance(), "testPriorizedDispatchPlugin", "PriorizedDispatchPlugin"));
        suite.addTest(new TestPriorizedDispatchPlugin(Global.instance(), "testPriorizedDispatchPluginReconfigure", "PriorizedDispatchPluginRecovery"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.exit(0);
        }
        TestPriorizedDispatchPlugin testSub = new TestPriorizedDispatchPlugin(glob, "TestPriorizedDispatchPlugin", "TestPriorizedDispatchPlugin");
        testSub.setUp();
        testSub.testPriorizedDispatchPlugin();
        testSub.tearDown();
    }
}

