/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.dispatch;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.plugins.I_ClientPlugin;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.protocol.AbstractCallbackExtended;
import org.xmlBlaster.client.protocol.xmlrpc.XmlRpcCallbackServer;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.test.Msg;
import org.xmlBlaster.test.MsgInterceptor;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public class TestPriorizedDispatchWithLostCallback
extends TestCase {
    private static String ME = "TestPriorizedDispatchWithLostCallback";
    private Global glob;
    private LogChannel log;
    private ConnectQos connectQos;
    private ConnectReturnQos connectReturnQos;
    private I_XmlBlasterAccess con = null;
    private String name;
    private String passwd = "secret";
    private EmbeddedXmlBlaster serverThread;
    private int serverPort = 9660;
    private MsgInterceptor updateInterceptor;
    private MsgInterceptor updateMsgs;
    private final String msgOid = "dispatchTestMessage";
    private int msgSequenceNumber = 0;
    private String statusOid = "_bandwidth.status";
    private String NORMAL_LINE = "2M";
    private String BACKUP_LINE = "64k";
    private String DEAD_LINE = "DOWN";
    private boolean connected;

    public TestPriorizedDispatchWithLostCallback(Global glob, String testName, String name) {
        super(testName);
        this.glob = glob;
        this.log = glob.getLog("test");
        this.name = name;
    }

    protected void setUp() {
        this.glob.init(Util.getOtherServerPorts(this.serverPort));
        String[] args = new String[]{"-ProtocolPlugin[XMLRPC][1.0]", "org.xmlBlaster.protocol.xmlrpc.XmlRpcDriver", "-CbProtocolPlugin[XMLRPC][1.0]", "org.xmlBlaster.protocol.xmlrpc.CallbackXmlRpcDriver", "-dispatch/connection/protocol", "XMLRPC", "-dispatch/callback/protocol", "XMLRPC", "-plugin/xmlrpc/port", "" + (this.serverPort + 1), "-dispatch/callback/plugin/xmlrpc/port", "" + (this.serverPort + 1), "-DispatchPlugin[Priority][1.0]", "org.xmlBlaster.util.dispatch.plugins.prio.PriorizedDispatchPlugin", "-DispatchPlugin/defaultPlugin", "undef", "-PriorizedDispatchPlugin.user", "_PriorizedDispatchPlugin", "-PriorizedDispatchPlugin/config", "<msgDispatch defaultStatus='" + this.BACKUP_LINE + "' defaultAction='send'/>\n"};
        this.glob.init(args);
        this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.glob);
        this.log.info(ME, "XmlBlaster is ready for testing the priority dispatch plugin");
        try {
            this.updateInterceptor = new MsgInterceptor(this.glob, this.log, null);
            this.log.info(ME, "Connecting with XmlRpc ...");
            this.con = this.glob.getXmlBlasterAccess();
            this.connectQos = new ConnectQos(this.glob, this.name, this.passwd);
            CallbackAddress cbAddress = new CallbackAddress(this.glob);
            cbAddress.setDelay(1000L);
            cbAddress.setRetries(-1);
            cbAddress.setPingInterval(5000L);
            cbAddress.setDispatchPlugin("Priority,1.0");
            this.connectQos.addCallbackAddress(cbAddress);
            this.connectReturnQos = this.con.connect(this.connectQos, this.updateInterceptor);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error(ME, "Can't connect to xmlBlaster: " + e.getMessage());
        }
        this.updateInterceptor.clear();
    }

    private void changeStatus(String oid, String state) {
        this.log.info(ME, "Changing band width state to '" + state + "'");
        try {
            PublishReturnQos rq = this.con.publish(new MsgUnit(this.glob, "<key oid='" + oid + "'/>", state, null));
            this.log.info(ME, "SUCCESS for state change to '" + state + "', " + rq.getState());
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {}
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.fail("publish bandwidth state - XmlBlasterException: " + e.getMessage());
        }
    }

    private void publish(String oid, int priority) {
        PriorityEnum prio = PriorityEnum.toPriorityEnum(priority);
        try {
            ++this.msgSequenceNumber;
            String content = "" + this.msgSequenceNumber;
            PublishQos pq = new PublishQos(this.glob);
            pq.setPriority(prio);
            PublishReturnQos rq = this.con.publish(new MsgUnit("<key oid='" + oid + "'/>", content.getBytes(), pq.toXml()));
            this.log.info(ME, "SUCCESS publish '" + oid + "' with prio=" + prio.toString() + " returned state=" + rq.getState());
            Assert.assertEquals("Returned oid wrong", oid, rq.getKeyOid());
            Assert.assertEquals("Return not OK", "OK", rq.getState());
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.fail("publish prio=" + prio.toString() + " - XmlBlasterException: " + e.getMessage());
        }
    }

    private void publishNewConfig(String config) {
        String configKey = "PriorizedDispatchPlugin/config";
        try {
            String oid = "__cmd:sysprop/?" + configKey;
            String contentStr = config;
            PublishQos pq = new PublishQos(this.glob);
            PublishReturnQos rq = this.con.publish(new MsgUnit("<key oid='" + oid + "'/>", contentStr.getBytes(), pq.toXml()));
            this.log.info(ME, "SUCCESS publish '" + oid + "' " + pq.toXml() + ", returned state=" + rq.getState());
            Assert.assertEquals("Returned oid wrong", oid, rq.getKeyOid());
            Assert.assertEquals("Return not OK", "OK", rq.getState());
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            e.printStackTrace();
            Assert.fail("publish of configuration data - XmlBlasterException: " + e.getMessage());
        }
    }

    private void subscribe(String oid) {
        try {
            SubscribeKey sk = new SubscribeKey(this.glob, oid);
            SubscribeQos sq = new SubscribeQos(this.glob);
            SubscribeReturnQos srq = this.con.subscribe(sk.toXml(), sq.toXml());
            this.log.info(ME, "SUCCESS subscribe to '" + oid + "' returned state=" + srq.getState());
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.fail("subscribe - XmlBlasterException: " + e.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void testPriorizedDispatchPluginConnectionState() {
        this.log.info(TestPriorizedDispatchWithLostCallback.ME, "testPriorizedDispatchPluginConnectionState() ...");
        config = "<msgDispatch defaultStatus='" + this.NORMAL_LINE + "' defaultAction='send'>\n" + "  <onStatus oid='" + this.statusOid + "' content='" + this.NORMAL_LINE + "' defaultAction='send'>\n" + "    <action do='send'  ifPriority='0-9'/>\n" + "  </onStatus>\n" + "  <onStatus oid='" + this.statusOid + "' content='" + this.DEAD_LINE + "' defaultAction='queue' connectionState='polling'>\n" + "    <action do='queue'  ifPriority='4-9'/>\n" + "    <action do='destroy'  ifPriority='0-3'/>\n" + "  </onStatus>\n" + "</msgDispatch>\n";
        this.publishNewConfig(config);
        text = "Testing configuration";
        sleep = 2000L;
        this.subscribe("dispatchTestMessage");
        maxPrio = PriorityEnum.MAX_PRIORITY.getInt() + 1;
        this.publish("dispatchTestMessage", 1);
        Assert.assertEquals(text, 1, this.updateInterceptor.waitOnUpdate(sleep, "dispatchTestMessage", "OK"));
        this.updateInterceptor.clear();
        this.log.info(TestPriorizedDispatchWithLostCallback.ME, "Shutdown callback, expecting messages to be queued or destroyed depending on the priority");
        try {
            this.con.getCbServer().shutdown();
        }
        catch (XmlBlasterException e) {
            Assert.fail("ShutdownCB: " + e.getMessage());
        }
        this.updateInterceptor.clear();
        priority = 0;
        while (priority < maxPrio) {
            this.publish("dispatchTestMessage", priority);
            ++priority;
        }
        Assert.assertEquals(text, 0, this.updateInterceptor.waitOnUpdate(sleep, "dispatchTestMessage", "OK"));
        this.updateInterceptor.clear();
        cbServer = null;
        try {
            this.updateMsgs = new MsgInterceptor(this.glob, this.log, null);
            this.updateInterceptor.clear();
            try {
                cbServer = new XmlRpcCallbackServer();
                cbAddress = new CallbackAddress(this.glob);
                cbServer.initialize(this.glob, this.name, cbAddress, new AbstractCallbackExtended(this.glob){

                    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) throws XmlBlasterException {
                        try {
                            String contentStr = new String(content);
                            String cont = contentStr.length() > 10 ? contentStr.substring(0, 10) + "..." : contentStr;
                            this.log.info(ME, "Receiving update of a message oid=" + updateKey.getOid() + " priority=" + updateQos.getPriority() + " state=" + updateQos.getState() + " content=" + cont);
                            if (!updateQos.isErased()) {
                                TestPriorizedDispatchWithLostCallback.this.updateMsgs.add(new Msg(cbSessionId, updateKey, content, updateQos));
                            }
                        }
                        catch (Throwable e) {
                            this.log.error(ME, "Error in update method: " + e.toString());
                            e.printStackTrace();
                        }
                        return "";
                    }

                    public I_ClientPlugin getSecurityPlugin() {
                        return null;
                    }
                });
            }
            catch (Throwable e) {
                this.log.error(TestPriorizedDispatchWithLostCallback.ME, "Can't restart callback server: " + e.toString());
                Assert.fail("Can't restart callback server: " + e.toString());
            }
            this.log.info(TestPriorizedDispatchWithLostCallback.ME, "Waiting long enough that xmlBlaster reconnected to us and expecting the 6 queued messages ...");
            try {
                Thread.currentThread();
                Thread.sleep(3000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            Assert.assertEquals(text, 0, this.updateInterceptor.getMsgs().length);
            Assert.assertEquals(text, 6, this.updateMsgs.getMsgs("dispatchTestMessage", "OK").length);
            msgArr = this.updateMsgs.getMsgs();
            Assert.assertEquals(text, 6, msgArr.length);
            lastNum = -1;
            lastPrio = PriorityEnum.MAX_PRIORITY.getInt() + 1;
            i = 0;
            while (i < msgArr.length) {
                currPrio = msgArr[i].getUpdateQos().getPriority().getInt();
                currNum = msgArr[i].getContentInt();
                if (lastPrio < currPrio || lastPrio == currPrio && lastNum >= currNum) {
                    Assert.fail(text + " Sequence is not ascending: last=" + lastNum + " curr=" + currNum);
                }
                lastNum = currNum;
                lastPrio = currPrio;
                ++i;
            }
            Assert.assertEquals("", PriorityEnum.MAX_PRIORITY, msgArr[0].getUpdateQos().getPriority());
            Assert.assertEquals("", 4, msgArr[5].getUpdateQos().getPriority().getInt());
            this.updateMsgs.clear();
            this.updateInterceptor.clear();
            var15_16 = null;
            ** if (cbServer == null) goto lbl-1000
        }
        catch (Throwable var14_20) {
            var15_17 = null;
            if (cbServer != null) {
                try {
                    cbServer.shutdown();
                }
                catch (Exception e) {
                    this.log.error(TestPriorizedDispatchWithLostCallback.ME, e.toString());
                }
            }
            throw var14_20;
        }
lbl-1000:
        // 1 sources

        {
            try {
                cbServer.shutdown();
            }
            catch (Exception e) {
                this.log.error(TestPriorizedDispatchWithLostCallback.ME, e.toString());
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        this.log.info(TestPriorizedDispatchWithLostCallback.ME, "Success in testPriorizedDispatchPluginConnectionState()");
    }

    protected void tearDown() {
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        this.con.disconnect(null);
        this.con = null;
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
        this.serverThread = null;
        Util.resetPorts(this.glob);
        this.glob = null;
        this.log = null;
        this.connectQos = null;
        this.connectReturnQos = null;
        this.con = null;
        this.updateInterceptor = null;
        this.updateMsgs = null;
        Global.instance().shutdown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "PriorizedDispatchPlugin";
        suite.addTest(new TestPriorizedDispatchWithLostCallback(Global.instance(), "testPriorizedDispatchPluginConnectionState", "PriorizedDispatchPluginRecovery"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.exit(0);
        }
        TestPriorizedDispatchWithLostCallback testSub = new TestPriorizedDispatchWithLostCallback(glob, "TestPriorizedDispatchWithLostCallback", "TestPriorizedDispatchWithLostCallback");
        testSub.setUp();
        testSub.testPriorizedDispatchPluginConnectionState();
        testSub.tearDown();
    }
}

