/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.distributor;

import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.test.util.Client;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;

public class TestConsumableQueue
extends TestCase {
    private static final String ME = "TestConsumableQueue";
    private Global global;
    private LogChannel log;
    private Object latch = new Object();
    private String[] args;
    static ArrayList responses = new ArrayList();
    private static long WAIT_DELAY = 1000L;
    private static long FAIL_WAIT_DELAY = 1000L;
    private Client client;

    public TestConsumableQueue(String name) {
        super(name);
    }

    public void prepare(String[] args) {
        this.args = args;
        this.global = new Global(args);
        this.global.getLog("test");
    }

    protected void setUp() {
        this.global = Global.instance();
        this.log = this.global.getLog("test");
        responses.clear();
    }

    protected void tearDown() {
    }

    public void testSubSubPub() {
        try {
            boolean consumable = true;
            int session = 1;
            Client pub1 = new Client(this.global, "pub1", responses);
            pub1.init("testConsumableQueue", null, consumable, session);
            Client sub1 = new Client(this.global, "sub1", responses);
            sub1.init(null, "testConsumableQueue", consumable, session);
            Client sub2 = new Client(this.global, "sub2", responses);
            sub2.init(null, "testConsumableQueue", consumable, session);
            Client deadMsg = new Client(this.global, "deadMsg", responses);
            deadMsg.init(null, "__sys__deadMessage", !consumable, session);
            Assert.assertEquals("wrong number of initial responses", 0, responses.size());
            ArrayList arrayList = responses;
            synchronized (arrayList) {
                pub1.publish("firstMessage");
                int i = 0;
                while (i < 1) {
                    responses.wait(WAIT_DELAY);
                    ++i;
                }
                Thread.sleep(200L);
                Assert.assertEquals("wrong number of updates", 1, responses.size());
            }
            responses.clear();
            ArrayList arrayList2 = responses;
            synchronized (arrayList2) {
                sub1.setUpdateException(new XmlBlasterException(this.global, ErrorCode.USER_UPDATE_ERROR, "testSubSubPub"));
                pub1.publish("firstMessage");
                int i = 0;
                while (i < 2) {
                    responses.wait(WAIT_DELAY);
                    ++i;
                }
                Thread.sleep(200L);
                Assert.assertEquals("wrong number of updates", 2, responses.size());
                Assert.assertEquals("update should be a dead message", "deadMsg", (String)responses.get(1));
            }
            responses.clear();
            ArrayList arrayList3 = responses;
            synchronized (arrayList3) {
                sub1.setUpdateException(null);
                sub2.setUpdateException(new XmlBlasterException(this.global, ErrorCode.USER_UPDATE_ERROR, "testSubSubPub"));
                pub1.publish("firstMessage");
                int i = 0;
                while (i < 1) {
                    responses.wait(WAIT_DELAY);
                    ++i;
                }
                Thread.sleep(200L);
                Assert.assertEquals("wrong number of updates, since the first sub receives, so it should not even try the second", 1, responses.size());
            }
            responses.clear();
            ArrayList arrayList4 = responses;
            synchronized (arrayList4) {
                sub1.setUpdateException(new XmlBlasterException(this.global, ErrorCode.USER_UPDATE_ERROR, "testSubSubPub"));
                sub2.setUpdateException(new XmlBlasterException(this.global, ErrorCode.USER_UPDATE_ERROR, "testSubSubPub"));
                pub1.publish("firstMessage");
                int i = 0;
                while (i < 2) {
                    responses.wait(WAIT_DELAY);
                    ++i;
                }
                Thread.sleep(200L);
                Assert.assertEquals("wrong number of updates", 2, responses.size());
                Assert.assertEquals("update should be a dead message", "deadMsg", (String)responses.get(1));
            }
            sub1.shutdown(false);
            sub2.shutdown(false);
            pub1.shutdown(true);
            deadMsg.shutdown(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue(false);
        }
    }

    public void testPubSub() {
        try {
            boolean consumable = true;
            int session = 1;
            Client pub1 = new Client(this.global, "pub1", responses);
            pub1.init("testConsumableQueue", null, consumable, session);
            pub1.publish("firstMessage");
            Client sub1 = new Client(this.global, "sub1", responses);
            Assert.assertEquals("wrong number of initial responses", 0, responses.size());
            ArrayList arrayList = responses;
            synchronized (arrayList) {
                sub1.init(null, "testConsumableQueue", consumable, session);
                responses.wait(WAIT_DELAY);
                Thread.sleep(1000L);
                Assert.assertEquals("wrong number of updates", 1, responses.size());
            }
            sub1.shutdown(false);
            pub1.shutdown(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue(false);
        }
    }

    public void testPubSubSub() {
        try {
            boolean consumable = true;
            int session = 1;
            Client pub1 = new Client(this.global, "pub1", responses);
            pub1.init("testConsumableQueue", null, consumable, session);
            pub1.publish("firstMessage");
            Client sub1 = new Client(this.global, "sub1", responses);
            Client sub2 = new Client(this.global, "sub2", responses);
            Assert.assertEquals("wrong number of initial responses", 0, responses.size());
            ArrayList arrayList = responses;
            synchronized (arrayList) {
                sub1.init(null, "testConsumableQueue", consumable, session);
                sub2.init(null, "testConsumableQueue", consumable, session);
                responses.wait(WAIT_DELAY);
                Thread.sleep(1000L);
                Assert.assertEquals("wrong number of updates", 1, responses.size());
            }
            sub1.shutdown(false);
            sub2.shutdown(false);
            pub1.shutdown(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue(false);
        }
    }

    public static void main(String[] args) {
        TestConsumableQueue test = new TestConsumableQueue(ME);
        test.prepare(args);
        test.setUp();
        test.testSubSubPub();
        test.tearDown();
        test.setUp();
        test.testPubSub();
        test.tearDown();
        test.setUp();
        test.testPubSubSub();
        test.tearDown();
    }
}

