/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.j2ee;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.InitialContextFactory;

public class MemContext
implements Context,
InitialContextFactory {
    NameParser parser = new NamingParser();
    static final Properties prop = new Properties();
    String prefix;
    Hashtable env;
    Hashtable bindings;
    private static MemContext root;
    private static Object lock;

    public Context getInitialContext(Hashtable env) throws NamingException {
        Object object = lock;
        synchronized (object) {
            if (root == null) {
                root = new MemContext(env, "");
            }
        }
        return root;
    }

    public MemContext() {
    }

    public MemContext(Hashtable env, String name) throws NamingException {
        this.bindings = new Hashtable();
        this.env = new Hashtable();
        this.prefix = name;
        if (env != null) {
            Enumeration envEntries = env.keys();
            while (envEntries.hasMoreElements()) {
                String entryName = (String)envEntries.nextElement();
                this.addToEnvironment(entryName, env.get(entryName));
            }
        }
    }

    public MemContext(Hashtable env, String name, Hashtable bindings) throws NamingException {
        this(env, name);
        this.bindings = bindings;
    }

    private Context getNextContext(Object candidate, String name) throws NamingException {
        if (candidate == null) {
            throw new NameNotFoundException(name);
        }
        if (candidate instanceof Context) {
            return (Context)candidate;
        }
        throw new NamingException("Can not continue, " + name + " is not a subcontext");
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        Object val = this.env.get(propName);
        this.env.put(propName, propVal);
        return val;
    }

    public Object lookup(Name name) throws NamingException {
        if (name == null) {
            throw new NamingException("Name to allowed to be null");
        }
        if (name.isEmpty()) {
            return new MemContext(this.env, this.prefix, this.bindings);
        }
        String n = name.get(0);
        Object entry = this.bindings.get(n);
        if (entry == null) {
            throw new NameNotFoundException(n);
        }
        if (name.size() > 1) {
            return this.getNextContext(entry, n).lookup(name.getSuffix(1));
        }
        return entry;
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup(this.getNameParser(name).parse(name));
    }

    public void bind(Name name, Object obj) throws NamingException {
        if (name == null) {
            throw new NamingException("Name to allowed to be null");
        }
        String n = name.get(0);
        Object entry = this.bindings.get(n);
        if (name.size() > 1) {
            this.getNextContext(entry, n).bind(name.getSuffix(1), obj);
        } else {
            if (entry != null) {
                throw new NameAlreadyBoundException(n);
            }
            this.bindings.put(n, obj);
        }
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind(this.getNameParser(name).parse(name), obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        if (name == null) {
            throw new NamingException("Name to allowed to be null");
        }
        String n = name.get(0);
        Object entry = this.bindings.get(n);
        if (name.size() > 1) {
            this.getNextContext(entry, n).rebind(name.getSuffix(1), obj);
        } else {
            if (entry != null) {
                this.unbind(n);
            }
            this.bind(n, obj);
        }
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(this.getNameParser(name).parse(name), obj);
    }

    public void unbind(Name name) throws NamingException {
        if (name == null) {
            throw new NamingException("Name to allowed to be null");
        }
        String n = name.get(0);
        Object entry = this.bindings.get(n);
        if (name.size() > 1) {
            this.getNextContext(entry, n).unbind(name.getSuffix(1));
        } else {
            if (entry == null) {
                throw new NameNotFoundException(n);
            }
            this.bindings.remove(n);
        }
    }

    public void unbind(String name) throws NamingException {
        this.unbind(this.getNameParser(name).parse(name));
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (name == null) {
            throw new NamingException("Name to allowed to be null");
        }
        String n = name.get(0);
        Object entry = this.bindings.get(n);
        if (name.size() > 1) {
            return this.getNextContext(entry, n).createSubcontext(name.getSuffix(1));
        }
        if (entry != null) {
            throw new NameAlreadyBoundException(n);
        }
        MemContext ctx = new MemContext(this.env, n);
        this.bindings.put(n, ctx);
        return ctx;
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this.getNameParser(name).parse(name));
    }

    public void close() throws NamingException {
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration list(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration list(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object lookupLink(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this.parser;
    }

    public String composeName(String name, String prefix) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Hashtable getEnvironment() throws NamingException {
        throw new OperationNotSupportedException();
    }

    public static void main(String[] args) {
        try {
            System.setProperty("java.naming.factory.initial", "org.xmlBlaster.test.j2ee.MemContext");
            InitialContext ctx = new InitialContext();
            Context hej = ctx.createSubcontext("hej");
            Context deep = ctx.createSubcontext("hej/deep");
            ctx.rebind("hej/deep/hello", (Object)"Hello");
            String h = (String)ctx.lookup("hej/deep/hello");
            System.out.println(h);
            ctx.unbind("hej/deep/hello");
            try {
                h = (String)ctx.lookup("hej/deep/hello");
                throw new NamingException("Name found altough it was unbound");
            }
            catch (NamingException e) {
                ctx.rebind("hej/deep/hello", (Object)"Hello");
                h = (String)new InitialContext().lookup("hej/deep/hello");
                System.out.println(h);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        prop.setProperty("jndi.syntax.direction", "left_to_right");
        prop.setProperty("jndi.syntax.separator", "/");
        lock = new Object();
    }

    class NamingParser
    implements NameParser {
        NamingParser() {
        }

        public Name parse(String name) throws NamingException {
            return new CompoundName(name, prop);
        }
    }
}

