/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.j2ee;

import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.j2ee.jmx.XmlBlasterService;
import org.xmlBlaster.j2ee.k2.BlasterManagedConnectionFactory;
import org.xmlBlaster.j2ee.k2.client.BlasterConnection;
import org.xmlBlaster.j2ee.k2.client.BlasterConnectionFactory;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class TestJ2eeServices
extends TestCase
implements I_Callback {
    private static String ME = "TestJ2eeServices";
    private final Global glob;
    private final LogChannel log;
    private I_XmlBlasterAccess con = null;
    private String propertyFileName = "org/xmlBlaster/test/j2ee/blasterServer.properties";
    private String clientPropertyFileName = "org/xmlBlaster/test/j2ee/blasterClient.properties";
    private XmlBlasterService server;
    private int serverPort = 8624;
    private BlasterManagedConnectionFactory mcf;
    private BlasterConnectionFactory factory;
    private HashMap subscriberTable = new HashMap();
    private int[] subRec = new int[2];
    private String subscribeOid;
    private String subscribeOid2;
    private String name = "testsub";
    private String passwd = "secret";
    private int numReceived = 0;

    public TestJ2eeServices() {
        this(null, "TestJ2eeServices");
    }

    public TestJ2eeServices(Global glob, String testName) {
        super(testName);
        this.glob = glob == null ? Global.instance() : glob;
        this.log = this.glob.getLog("test");
    }

    protected void setUpServer() throws Exception {
        System.setProperty("java.naming.factory.initial", "org.xmlBlaster.test.j2ee.MemContext");
        this.server = new XmlBlasterService();
        this.server.setPropertyFileName(this.propertyFileName);
        this.server.setJNDIName("xmlBlaster/globalUtil");
        this.server.setPort("" + this.serverPort);
        this.server.start();
    }

    protected void setUpK2() throws Exception {
        this.mcf = new BlasterManagedConnectionFactory();
        this.mcf.setUserName("test");
        this.mcf.setPassword("test");
        this.mcf.setClientProtocol("LOCAL");
        this.mcf.setIorPort("" + this.serverPort);
        this.mcf.setPropertyFileName(this.clientPropertyFileName);
        this.mcf.setJNDIName("xmlBlaster/globalUtil");
        this.factory = (BlasterConnectionFactory)this.mcf.createConnectionFactory();
    }

    protected void setUp() throws Exception {
        this.setUpServer();
        this.setUpK2();
        String[] args = new String[]{"-bootstrapPort", "" + this.serverPort};
        this.glob.init(args);
        try {
            this.log.info(ME, "Connecting ...");
            this.con = this.glob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(this.glob, this.name, this.passwd);
            this.con.connect(qos, this);
            String xmlKey = "<key oid='' queryType='XPATH'>\n//TestLocalProtocol-AGENT</key>";
            String sqos = "<qos><notify>false</notify></qos>";
            this.subscribeOid = this.con.subscribe(xmlKey, sqos).getSubscriptionId();
            this.log.info(ME, "Success: Subscribe on subscriptionId=" + this.subscribeOid + " done");
            Assert.assertTrue("returned null subscriptionId", this.subscribeOid != null);
            this.subscriberTable.put(this.subscribeOid, new Integer(0));
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    protected void tearDown() throws Exception {
        this.log.info(ME, "TEST: tearing down");
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        try {
            this.con.unSubscribe("<key oid='" + this.subscribeOid + "'/>", "<qos/>");
            EraseReturnQos[] arr = this.con.erase("<key oid='' queryType='XPATH'>\n   /xmlBlaster/key/TestLocalProtocol-AGENT</key>", "<qos/>");
            Assert.assertEquals("Erase", 5, arr.length);
        }
        catch (XmlBlasterException e) {
            Assert.fail("Erase XmlBlasterException: " + e.getMessage());
        }
        this.con.disconnect(null);
        this.con = null;
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.server.stop();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testPublish() throws Exception {
        BlasterConnection conn = null;
        int i = 0;
        while (true) {
            block8: {
                Object var6_6;
                if (i >= 5) {
                    this.waitOnUpdate(this.subscribeOid, 10000L, 5);
                    return;
                }
                try {
                    try {
                        conn = this.factory.getConnection();
                        String c = "<content>" + i + "</content>";
                        String k = "<key oid='" + i + "' contentMime='text/xml'><TestLocalProtocol-AGENT id='" + i + "' type='generic'/></key>";
                        this.log.info(ME, "Key: " + k);
                        conn.publish(new MsgUnit(k, c.getBytes(), null));
                    }
                    catch (XmlBlasterException e) {
                        this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
                        Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
                        var6_6 = null;
                        if (conn != null) {
                            conn.close();
                        }
                        break block8;
                    }
                    var6_6 = null;
                    if (conn == null) break block8;
                }
                catch (Throwable throwable) {
                    var6_6 = null;
                    if (conn != null) {
                        conn.close();
                    }
                    throw throwable;
                }
                conn.close();
            }
            ++i;
        }
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.log.info(ME, "Receiving update of a message " + updateKey.getOid() + " for subId: " + updateQos.getSubscriptionId());
        int ii = (Integer)this.subscriberTable.get(updateQos.getSubscriptionId());
        this.log.trace(ME, "Got message " + new String(content));
        int n = ii;
        this.subRec[n] = this.subRec[n] + 1;
        ++this.numReceived;
        return "";
    }

    private void waitOnUpdate(String subId, long timeout, int numWait) {
        long pollingInterval = 50L;
        if (timeout < 50L) {
            pollingInterval = timeout / 10L;
        }
        long sum = 0L;
        int ii = (Integer)this.subscriberTable.get(subId);
        while (this.subRec[ii] < numWait) {
            try {
                Thread.currentThread();
                Thread.sleep(pollingInterval);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            Assert.assertTrue("Timeout of " + timeout + " occurred without update", (sum += pollingInterval) <= timeout);
        }
        try {
            Thread.currentThread();
            Thread.sleep(timeout);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assert.assertEquals("Wrong number of messages arrived", numWait, this.subRec[ii]);
        this.log.info(ME, "Found correct rec messages for: " + subId);
        this.subRec[ii] = 0;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "Tim";
        suite.addTest(new TestJ2eeServices(new Global(), "testPublish"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.err.println(ME + ": Init failed");
            System.exit(1);
        }
        TestJ2eeServices testSub = new TestJ2eeServices(glob, "TestLocalProtocol");
        try {
            testSub.setUp();
            testSub.testPublish();
            testSub.tearDown();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

