/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.jdbc;

import java.util.Vector;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.XmlDbMessageWrapper;
import org.xmlBlaster.client.key.GetKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.GetQos;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;

public class TestJdbcAccess
extends TestCase {
    private static String ME = "TestJdbcAccess";
    private final Global glob = Global.instance();
    private final LogChannel log = this.glob.getLog(null);
    private I_XmlBlasterAccess con = null;
    private String name;
    private String passwd = "secret";
    private EmbeddedXmlBlaster serverThread;
    private int serverPort = 7615;
    private XmlDbMessageWrapper wrap = null;

    public TestJdbcAccess(String testName) {
        super(testName);
        this.name = testName;
    }

    protected void setUp() {
        Vector argsVec = Util.getOtherServerPortVec(this.serverPort);
        String tmp = this.glob.getProperty().get("JdbcDriver.drivers", (String)null);
        if (tmp == null || tmp.indexOf("ORG.as220.tinySQL.dbfFileDriver") < 0) {
            argsVec.add("-JdbcDriver.drivers");
            argsVec.add("ORG.as220.tinySQL.dbfFileDriver");
        }
        this.glob.init(argsVec.toArray(new String[argsVec.size()]));
        this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.glob);
        this.log.info(ME, "XmlBlaster is ready for testing JDBC access");
        try {
            this.log.info(ME, "Connecting ...");
            this.con = this.glob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(this.glob, this.name, this.passwd);
            this.con.connect(qos, null);
        }
        catch (Exception e) {
            Thread.currentThread();
            Thread.dumpStack();
            this.log.error(ME, "Can't connect to xmlBlaster: " + e.toString());
        }
        this.wrap = new XmlDbMessageWrapper(this.glob, "joe", "secret", "jdbc:dbfFile:.");
        this.wrap.initUpdate(true, "DROP TABLE IF EXISTS cars");
        String string = this.invokeSyncQuery(this.wrap, 1, null);
    }

    protected void tearDown() {
        if (this.wrap != null) {
            this.wrap.initUpdate(true, "DROP TABLE IF EXISTS cars");
            String result = this.invokeSyncQuery(this.wrap, 1, null);
            this.wrap = null;
        }
        this.con.disconnect(null);
        this.con = null;
        try {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
        this.serverThread = null;
        Util.resetPorts();
    }

    public void testQueries() {
        this.log.info(ME, "######## Start testQueries()");
        String request = "CREATE TABLE cars (name CHAR(25), id NUMERIC(4,0))";
        this.log.info(ME, "*** REQUEST=" + request);
        this.wrap.initUpdate(true, request);
        String result = this.invokeSyncQuery(this.wrap, 1, null);
        String[] brands = new String[]{"Fiat", "Audi", "BMW", "Porsche", "Mercedes", "Renault", "Citroen"};
        int ii = 0;
        while (ii < brands.length) {
            request = "INSERT INTO cars (name, id) VALUES('" + brands[ii] + "', " + (ii + 1) + ")";
            this.log.info(ME, "*** REQUEST=" + request);
            this.wrap.initUpdate(true, request);
            result = this.invokeSyncQuery(this.wrap, 1, null);
            ++ii;
        }
        request = "SELECT * from cars";
        this.log.info(ME, "*** REQUEST=" + request);
        this.wrap.initQuery(100, true, request);
        result = this.invokeSyncQuery(this.wrap, 1, "BMW");
        this.log.info(ME, "Successful retrieved cars, dump ommitted to not disturb JUNIT test report generation");
        this.log.trace(ME, "Retrieved cars:\n" + result);
    }

    private String invokeSyncQuery(XmlDbMessageWrapper wrap, int numResultRowsExpected, String token) {
        try {
            if (this.log.TRACE) {
                this.log.trace(ME, "Sending command string:\n" + wrap.toXml());
            }
            GetKey key = new GetKey(this.glob, "__sys__jdbc");
            key.wrap(wrap.toXml());
            GetQos qos = new GetQos(this.glob);
            MsgUnit[] msgUnitArr = this.con.get(key.toXml(), qos.toXml());
            if (msgUnitArr.length > 0) {
                String result = new String(msgUnitArr[0].getContent());
                if (this.log.TRACE) {
                    this.log.trace(ME, result);
                }
                if (token != null && result.indexOf(token) < 0) {
                    Assert.fail("Token " + token + " not found in result");
                }
            } else {
                this.log.info(ME, "No results for your query");
            }
            Assert.assertEquals("Wrong number of results", numResultRowsExpected, msgUnitArr.length);
            return new String(msgUnitArr[0].getContent());
        }
        catch (Exception e) {
            Assert.fail("Query failed: " + e.toString());
            return "";
        }
    }

    public static void main(String[] args) {
        Global glob = Global.instance();
        if (glob.init(args) != 0) {
            System.err.println("Init failed");
            System.exit(1);
        }
        TestJdbcAccess test = new TestJdbcAccess("TestJdbcAccess");
        test.setUp();
        test.testQueries();
        test.tearDown();
    }
}

