/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.jms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.naming.NamingService;
import org.jutils.log.LogChannel;
import org.xmlBlaster.jms.XBConnectionFactory;
import org.xmlBlaster.jms.XBTopic;
import org.xmlBlaster.util.Global;

public class TestJmsSubscribe
extends TestCase
implements MessageListener {
    private static final String ME = "TestJmsSubscribe";
    private static final String CONNECTION_FACTORY = "connectionFactory";
    private static final String TOPIC = "jms-test";
    protected Global glob;
    protected LogChannel log;
    int counter = 0;
    int nmax;
    private ConnectionFactory factory;
    private Destination topic;
    private Connection connection;
    private Object latch = new Object();
    private long[] timestamps;
    private String[] args;
    private NamingService namingService;

    public TestJmsSubscribe(String name) {
        super(name);
        try {
            this.namingService = new NamingService();
            this.namingService.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue("exception in constructor when starting naming service", false);
        }
    }

    public void finalize() {
        this.namingService.stop();
    }

    public void prepare(String[] args) {
        this.args = args;
        this.glob = new Global(args);
        this.glob.getLog("test");
    }

    public void onMessage(Message message) {
        if (this.log.CALL) {
            this.log.call(ME, "onMessage start");
        }
        try {
            if (message instanceof TextMessage) {
                this.timestamps[this.counter] = System.currentTimeMillis();
                ++this.counter;
                System.out.println(((TextMessage)message).getText());
                Thread.sleep(200L);
                if (this.log.TRACE) {
                    this.log.trace(ME, "onMessage before ack");
                }
                message.acknowledge();
                if (this.log.TRACE) {
                    this.log.trace(ME, "onMessage after ack");
                }
                Thread.sleep(300L);
                if (this.log.TRACE) {
                    this.log.trace(ME, "onMessage after final sleeping");
                }
                if (this.counter == this.nmax) {
                    Object object = this.latch;
                    synchronized (object) {
                        this.latch.notify();
                    }
                }
            }
            if (this.log.CALL) {
                this.log.call(ME, "onMessage stop");
            }
        }
        catch (JMSException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
        }
        catch (InterruptedException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    protected void setUp() {
        this.glob = Global.instance();
        this.log = this.glob.getLog("test");
        try {
            this.adminJmsStart();
            try {
                InitialContext ctx = new InitialContext();
                this.factory = (XBConnectionFactory)ctx.lookup(CONNECTION_FACTORY);
                this.topic = (XBTopic)ctx.lookup(TOPIC);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Assert.assertTrue("naming exception", false);
            }
            this.connection = this.factory.createConnection();
            this.connection.start();
            this.nmax = 5;
            this.timestamps = new long[this.nmax];
            this.counter = 0;
        }
        catch (JMSException ex) {
            ex.printStackTrace();
            Assert.assertTrue(false);
        }
    }

    protected void tearDown() {
        try {
            this.connection.stop();
            InitialContext ctx = new InitialContext();
            ctx.unbind(CONNECTION_FACTORY);
            ctx.unbind(TOPIC);
        }
        catch (JMSException ex) {
            ex.printStackTrace();
            Assert.assertTrue(false);
        }
        catch (NamingException ex) {
            ex.printStackTrace();
            Assert.assertTrue("exception when unbinding", false);
        }
    }

    protected void adminJmsStart() {
        try {
            InitialContext ctx = new InitialContext();
            ctx.bind(CONNECTION_FACTORY, (Object)new XBConnectionFactory(this.args));
            ctx.bind(TOPIC, (Object)new XBTopic(TOPIC));
        }
        catch (NamingException ex) {
            ex.printStackTrace();
            Assert.assertTrue("exception occured in testJndi", false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue("exception when starting naming service", false);
        }
    }

    public void testSubAutoAck() {
        try {
            Session session = this.connection.createSession(false, 1);
            MessageConsumer subscriber = session.createConsumer(this.topic);
            subscriber.setMessageListener((MessageListener)this);
            Session session2 = this.connection.createSession(false, 1);
            MessageProducer publisher = session2.createProducer(this.topic);
            TextMessage msg = session2.createTextMessage();
            msg.setText("this is a simple jms AUTO acknowlegded test message");
            int i = 0;
            while (i < this.nmax) {
                publisher.send(this.topic, (Message)msg);
                Thread.sleep(50L);
                ++i;
            }
            Object object = this.latch;
            synchronized (object) {
                this.latch.wait((long)this.nmax * 700L);
                Thread.sleep(100L);
                Assert.assertEquals("number of onMessage invocations is wrong", this.nmax, this.counter);
            }
            double expDt = 500.0;
            double dt = 1.0 * (double)(this.timestamps[this.nmax - 1] - this.timestamps[0]) / ((double)this.nmax - 1.0);
            this.log.info("", "The processing time is '" + dt + "' ms and expected is '" + expDt + "' ms");
            Assert.assertEquals("The expected processing time wrong", 1.0 * expDt, 1.0 * dt, 0.2 * dt);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue(false);
        }
    }

    public void testSubClientAck() {
        try {
            Session session = this.connection.createSession(false, 2);
            MessageConsumer subscriber = session.createConsumer(this.topic);
            subscriber.setMessageListener((MessageListener)this);
            Session session2 = this.connection.createSession(false, 2);
            MessageProducer publisher = session2.createProducer(this.topic);
            TextMessage msg = session2.createTextMessage();
            msg.setText("this is a simple jms CLIENT acknowlegded test message");
            long t1 = System.currentTimeMillis();
            int i = 0;
            while (i < this.nmax) {
                publisher.send(this.topic, (Message)msg);
                Thread.sleep(50L);
                ++i;
            }
            Object object = this.latch;
            synchronized (object) {
                this.latch.wait((long)this.nmax * 700L);
                Thread.sleep(100L);
                Assert.assertEquals("number of onMessage invocations is wrong", this.nmax, this.nmax);
            }
            double expDt = 200.0;
            double dt = 1.0 * (double)(this.timestamps[this.nmax - 1] - this.timestamps[0]) / ((double)this.nmax - 1.0);
            this.log.info("", "The processing time is '" + dt + "' ms and expected is '" + expDt + "' ms");
            Assert.assertEquals("The expected processing time wrong", 1.0 * expDt, 1.0 * dt, 0.2 * dt);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue(false);
        }
    }

    public void testSyncReceiver() {
        try {
            Session session = this.connection.createSession(false, 1);
            MessageConsumer subscriber = session.createConsumer(this.topic);
            subscriber.setMessageListener((MessageListener)this);
            Session session2 = this.connection.createSession(false, 1);
            MessageProducer publisher = session2.createProducer(this.topic);
            TextMessage msg = session2.createTextMessage();
            msg.setText("this message will be consumed synchronously");
            PublisherThread pub = new PublisherThread(publisher, (Message)msg, 6, 100L);
            pub.start();
            int i = 0;
            while (i < 3) {
                Message msg2 = subscriber.receive();
                Assert.assertEquals("receive(): messages are not the same", msg, msg2);
                ++i;
            }
            int i2 = 0;
            while (i2 < 3) {
                Message msg2 = subscriber.receive(300L);
                Assert.assertEquals("receive(delay): messages are not the same", msg, msg2);
                ++i2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue(false);
        }
    }

    public static void main(String[] args) {
        TestJmsSubscribe test = new TestJmsSubscribe(ME);
        test.prepare(args);
        test.setUp();
        test.testSubAutoAck();
        test.tearDown();
        test.setUp();
        test.testSubClientAck();
        test.tearDown();
        test.setUp();
        test.testSyncReceiver();
        test.tearDown();
    }

    class PublisherThread
    extends Thread {
        private MessageProducer producer;
        private int numOfPublishes;
        private long delayBetweenPublishes;
        private Message msg;

        public PublisherThread(MessageProducer producer, Message msg, int numOfPublishes, long delayBetweenPublishes) {
            this.producer = producer;
            this.numOfPublishes = numOfPublishes;
            this.delayBetweenPublishes = delayBetweenPublishes;
            this.msg = msg;
        }

        public void run() {
            int i = 0;
            while (i < this.numOfPublishes) {
                try {
                    Thread.sleep(this.delayBetweenPublishes);
                    this.producer.send(this.msg);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Assert.assertTrue("Exception in publisher thread " + ex.getMessage(), false);
                }
                ++i;
            }
        }
    }
}

