/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.jms;

import java.lang.reflect.Method;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.jms.XBMessage;
import org.xmlBlaster.jms.XBTextMessage;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.key.MsgKeyData;
import org.xmlBlaster.util.qos.MsgQosData;

public class TestMessages
extends TestCase {
    private static final String ME = "TestMessages";
    protected Global glob;
    protected LogChannel log;
    int counter = 0;
    int nmax;
    private String[] args;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$xmlBlaster$jms$XBMessage;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public TestMessages(String name) {
        super(name);
    }

    public void prepare(String[] args) {
        this.args = args;
        this.glob = new Global(args);
        this.glob.getLog("test");
    }

    protected void setUp() {
        this.glob = Global.instance();
        this.log = this.glob.getLog("test");
    }

    protected void tearDown() {
    }

    private void checkIfAllowed(XBMessage msg, String setter, String getter, Object val, boolean allowed) {
        try {
            String methodName = "get" + getter + "Property";
            Class[] argTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = TestMessages.class$("java.lang.String")) : class$java$lang$String};
            Object[] args = new Object[]{setter};
            Method method = (class$org$xmlBlaster$jms$XBMessage == null ? (class$org$xmlBlaster$jms$XBMessage = TestMessages.class$("org.xmlBlaster.jms.XBMessage")) : class$org$xmlBlaster$jms$XBMessage).getMethod(methodName, argTypes);
            try {
                this.log.info(ME, "checkIfAllowed: setter='" + setter + "', getter='" + getter + "' expected='" + allowed + "'");
                method.invoke((Object)msg, args);
                Assert.assertTrue("the combination set" + setter + "Property / get" + getter + "Property should NOT be allowed", allowed);
            }
            catch (Exception ex) {
                if (ex instanceof JMSException) {
                    if (allowed) {
                        ex.printStackTrace();
                    }
                    Assert.assertTrue("the combination set" + setter + "Property / get" + getter + "Property should be allowed: " + ex.getMessage(), !allowed);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue("Something is probably wrong with this test", false);
        }
    }

    private void checkSetter(XBMessage msg, String name, Object obj) {
        try {
            Class<?> obj1 = msg.getObjectProperty(name).getClass();
            Assert.assertEquals("Type of setter is incorrect ", obj, obj1);
        }
        catch (Exception ex) {
            Assert.assertTrue("exception should not occur when testing setter for '" + name + "' ", false);
        }
    }

    public void testPropertyValueConversion() {
        try {
            int i;
            MsgKeyData key = null;
            byte[] content = null;
            MsgQosData qos = null;
            int type = 0;
            XBMessage msg = new XBMessage(this.glob, key, content, qos, type);
            String[] keys = new String[]{"Boolean", "Byte", "Short", "Int", "Long", "Float", "Double", "String"};
            Object[] values = new Object[]{new Boolean(false), new Byte(1), new Short(2), new Integer(3), new Long(4L), new Float(5.01), new Double(6.02), new String("7 String")};
            msg.setBooleanProperty(keys[0], false);
            msg.setByteProperty(keys[1], (byte)1);
            msg.setShortProperty(keys[2], (short)2);
            msg.setIntProperty(keys[3], 3);
            msg.setLongProperty(keys[4], 4L);
            msg.setFloatProperty(keys[5], 5.01f);
            msg.setDoubleProperty(keys[6], 6.02);
            msg.setStringProperty(keys[7], "7 (String)");
            boolean[][] allowed = new boolean[8][8];
            int j = 0;
            while (j < 8) {
                i = 0;
                while (i < 8) {
                    allowed[j][i] = false;
                    ++i;
                }
                ++j;
            }
            i = 0;
            while (i < 8) {
                allowed[7][i] = true;
                ++i;
            }
            int i2 = 0;
            while (i2 < 8) {
                allowed[i2][7] = true;
                ++i2;
            }
            allowed[0][0] = true;
            allowed[1][1] = true;
            allowed[1][2] = true;
            allowed[2][2] = true;
            allowed[1][3] = true;
            allowed[2][3] = true;
            allowed[3][3] = true;
            allowed[1][4] = true;
            allowed[2][4] = true;
            allowed[3][4] = true;
            allowed[4][4] = true;
            allowed[5][5] = true;
            allowed[5][6] = true;
            allowed[6][6] = true;
            this.checkSetter(msg, "Boolean", class$java$lang$Boolean == null ? (class$java$lang$Boolean = TestMessages.class$("java.lang.Boolean")) : class$java$lang$Boolean);
            this.checkSetter(msg, "Byte", class$java$lang$Byte == null ? (class$java$lang$Byte = TestMessages.class$("java.lang.Byte")) : class$java$lang$Byte);
            this.checkSetter(msg, "Short", class$java$lang$Short == null ? (class$java$lang$Short = TestMessages.class$("java.lang.Short")) : class$java$lang$Short);
            this.checkSetter(msg, "Int", class$java$lang$Integer == null ? (class$java$lang$Integer = TestMessages.class$("java.lang.Integer")) : class$java$lang$Integer);
            this.checkSetter(msg, "Long", class$java$lang$Long == null ? (class$java$lang$Long = TestMessages.class$("java.lang.Long")) : class$java$lang$Long);
            this.checkSetter(msg, "Float", class$java$lang$Float == null ? (class$java$lang$Float = TestMessages.class$("java.lang.Float")) : class$java$lang$Float);
            this.checkSetter(msg, "Double", class$java$lang$Double == null ? (class$java$lang$Double = TestMessages.class$("java.lang.Double")) : class$java$lang$Double);
            this.checkSetter(msg, "String", class$java$lang$String == null ? (class$java$lang$String = TestMessages.class$("java.lang.String")) : class$java$lang$String);
            int j2 = 0;
            while (j2 < 8) {
                int i3 = 0;
                while (i3 < 8) {
                    this.checkIfAllowed(msg, keys[j2], keys[i3], values[j2], allowed[j2][i3]);
                    ++i3;
                }
                ++j2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue("exception occured ", false);
        }
    }

    public void testReadOnlyProperties() {
        try {
            MsgKeyData key = null;
            byte[] content = "testReadOnlyProperties".getBytes();
            MsgQosData qos = null;
            int type = 0;
            XBMessage msg = new XBMessage(this.glob, key, content, qos, type);
            String[] keys = new String[]{"Boolean", "Byte", "Short", "Int", "Long", "Float", "Double", "String"};
            try {
                msg.setBooleanProperty(keys[0], false);
                Assert.assertTrue("the setting of the boolean property should not be possible in read only mode", false);
            }
            catch (MessageNotWriteableException e) {
                // empty catch block
            }
            try {
                msg.setByteProperty(keys[1], (byte)1);
                Assert.assertTrue("the setting of the byte property should not be possible in read only mode", false);
            }
            catch (MessageNotWriteableException e) {
                // empty catch block
            }
            try {
                msg.setShortProperty(keys[2], (short)2);
                Assert.assertTrue("the setting of the short property should not be possible in read only mode", false);
            }
            catch (MessageNotWriteableException e) {
                // empty catch block
            }
            try {
                msg.setIntProperty(keys[3], 3);
                Assert.assertTrue("the setting of the int property should not be possible in read only mode", false);
            }
            catch (MessageNotWriteableException e) {
                // empty catch block
            }
            try {
                msg.setLongProperty(keys[4], 4L);
                Assert.assertTrue("the setting of the long property should not be possible in read only mode", false);
            }
            catch (MessageNotWriteableException e) {
                // empty catch block
            }
            try {
                msg.setFloatProperty(keys[5], 5.01f);
                Assert.assertTrue("the setting of the float property should not be possible in read only mode", false);
            }
            catch (MessageNotWriteableException e) {
                // empty catch block
            }
            try {
                msg.setDoubleProperty(keys[6], 6.02);
                Assert.assertTrue("the setting of the double property should not be possible in read only mode", false);
            }
            catch (MessageNotWriteableException e) {
                // empty catch block
            }
            try {
                msg.setStringProperty(keys[7], "7 (String)");
                Assert.assertTrue("the setting of the string property should not be possible in read only mode", false);
            }
            catch (MessageNotWriteableException e) {
                // empty catch block
            }
            msg.clearProperties();
            try {
                msg.setBooleanProperty(keys[0], false);
            }
            catch (MessageNotWriteableException e) {
                Assert.assertTrue("the setting of the boolean property should be possible since not in read only mode", false);
            }
            try {
                msg.setByteProperty(keys[1], (byte)1);
            }
            catch (MessageNotWriteableException e) {
                Assert.assertTrue("the setting of the byte property should be possible since not in read only mode", false);
            }
            try {
                msg.setShortProperty(keys[2], (short)2);
            }
            catch (MessageNotWriteableException e) {
                Assert.assertTrue("the setting of the short property should be possible since not in read only mode", false);
            }
            try {
                msg.setIntProperty(keys[3], 3);
            }
            catch (MessageNotWriteableException e) {
                Assert.assertTrue("the setting of the int property should be possible since not in read only mode", false);
            }
            try {
                msg.setLongProperty(keys[4], 4L);
            }
            catch (MessageNotWriteableException e) {
                Assert.assertTrue("the setting of the long property should be possible since not in read only mode", false);
            }
            try {
                msg.setFloatProperty(keys[5], 5.01f);
            }
            catch (MessageNotWriteableException e) {
                Assert.assertTrue("the setting of the float property should be possible since not in read only mode", false);
            }
            try {
                msg.setDoubleProperty(keys[6], 6.02);
            }
            catch (MessageNotWriteableException e) {
                Assert.assertTrue("the setting of the double property should be possible since not in read only mode", false);
            }
            try {
                msg.setStringProperty(keys[7], "7 (String)");
            }
            catch (MessageNotWriteableException e) {
                Assert.assertTrue("the setting of the string property should be possible since not in read only mode", false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue("exception occured ", false);
        }
    }

    public void testTextMessage() {
        try {
            MsgKeyData key = null;
            MsgQosData qos = null;
            Object content = null;
            XBTextMessage msg = new XBTextMessage(this.glob, key, content, qos);
            String txt1 = "funny Things happen";
            msg.setText(txt1);
            String txt2 = msg.getText();
            Assert.assertEquals("normal text comparison", txt1, txt2);
            txt1 = null;
            msg.setText(txt1);
            txt2 = msg.getText();
            Assert.assertEquals("normal text comparison", txt1, txt2);
            key = null;
            qos = null;
            content = null;
            msg = new XBTextMessage(this.glob, key, "oh I am a text msg".getBytes(), qos);
            txt1 = "funny Things happen";
            msg.setText(txt1);
            txt2 = msg.getText();
            Assert.assertEquals("normal text comparison", txt1, txt2);
            txt1 = null;
            msg.setText(txt1);
            txt2 = msg.getText();
            Assert.assertEquals("normal text comparison", txt1, txt2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue("exception occured ", false);
        }
    }

    public static void main(String[] args) {
        TestMessages test = new TestMessages(ME);
        test.prepare(args);
        test.setUp();
        test.testPropertyValueConversion();
        test.tearDown();
        test.setUp();
        test.testReadOnlyProperties();
        test.tearDown();
        test.setUp();
        test.testTextMessage();
        test.tearDown();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

