/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.jmx;

import java.io.IOException;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.admin.extern.MethodInvocation;
import org.xmlBlaster.util.admin.extern.SerializeHelper;

public class TestConnector
extends TestCase
implements I_Callback {
    private final int serverPort = 3424;
    private static final String ME = "TestConnector";
    private Global glob = null;
    private LogChannel log = null;
    private I_XmlBlasterAccess returnCon;
    private I_XmlBlasterAccess invokeCon;
    private MsgUnit msg = null;
    private static String port = "3424";
    SerializeHelper sh = null;
    MethodInvocation mi = null;

    public TestConnector(String testName) {
        super(testName);
    }

    protected void setUp() {
        if (this.glob == null) {
            this.glob = Global.instance();
        }
        this.log = this.glob.getLog("test");
        this.log.info(ME, "setUp of TestConnector...");
        Properties prop = new Properties();
        prop.setProperty("bootstrapPort", port);
        prop.setProperty("bootstrapHostname", "localhost");
        this.glob.init(prop);
        this.invokeCon = this.glob.getXmlBlasterAccess();
        this.returnCon = this.glob.getXmlBlasterAccess();
        try {
            ConnectQos qos = new ConnectQos(this.glob, "InternalConnector", "connector");
            this.returnCon.connect(qos, this);
        }
        catch (XmlBlasterException ex) {
            Assert.assertTrue("Error when connecting to xmlBlaster " + ex.toString(), false);
            this.log.error(ME, "Error when connecting to xmlBlaster " + ex.toString());
        }
        SubscribeKey subKey = new SubscribeKey(this.glob, "xmlBlasterMBeans_Return");
        SubscribeQos sQos = new SubscribeQos(this.glob);
        sQos.setWantLocal(false);
        try {
            this.returnCon.subscribe(subKey, sQos);
        }
        catch (XmlBlasterException ex) {
            Assert.assertTrue("Error when subscribing to xmlBlaster " + ex.toString(), false);
            this.log.error(ME, "Error when subscribing to xmlBlaster " + ex.toString());
        }
        this.sh = new SerializeHelper(this.glob);
        if (this.invokeCon.isConnected() && this.returnCon.isConnected()) {
            this.log.info(ME, "connection establisheld");
        } else {
            this.log.warn(ME, "Couldnt connect to server on port " + port);
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new TestConnector("testConnector"));
        return suite;
    }

    public void testConnector() {
        try {
            this.log.info(ME, "Creating TestMessage");
            this.mi = new MethodInvocation();
            this.mi.setMethodName("getDefaultDomain");
            this.log.info(ME, "new MethodInvocation build " + this.mi.getMethodName());
            PublishReturnQos rqos = this.invokeCon.publish(new MsgUnit("<key oid='xmlBlasterMBeans_Invoke'/>", this.sh.serializeObject(this.mi), "<qos/>"));
            this.log.info(ME, "Publish test Message to jmx-topic..");
        }
        catch (XmlBlasterException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            this.log.error(ME, "Error when creating methodInvocation " + ex.toString());
            ex.printStackTrace();
        }
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.log.info(ME, "Receiving update of a message, checking ...");
        MethodInvocation mi = null;
        try {
            mi = (MethodInvocation)this.sh.deserializeObject(content);
        }
        catch (IOException ex) {
            this.log.error(ME, "Error when deserializing object");
        }
        Object obj = mi.getReturnValue();
        this.log.info(ME, "Received Object: " + obj);
        if (obj.toString().length() > 0) {
            this.log.info(ME, "Success... Received Domainname: " + obj);
        } else {
            this.log.error(ME, "Error when receiving returning object...");
            Assert.assertTrue("Error when receiving returning object...", false);
        }
        return "";
    }
}

