/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.jmx;

import java.rmi.RemoteException;
import javax.management.MBeanInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.jmx.AsyncMBeanServer;
import org.xmlBlaster.client.jmx.Callback;
import org.xmlBlaster.client.jmx.ConnectorException;
import org.xmlBlaster.client.jmx.ConnectorFactory;
import org.xmlBlaster.util.Global;

public class TestRemoteMBeanServer
extends TestCase {
    private static final String ME = "TestRemoteMBeanServer";
    private Global glob = null;
    private LogChannel log = null;
    protected ObjectName RequestBrokerName;
    protected AsyncMBeanServer server;
    ObjectName JmxLogChannelName;

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new TestRemoteMBeanServer("testRemoteMBeanServer"));
        return suite;
    }

    public TestRemoteMBeanServer() {
        super(ME);
    }

    public TestRemoteMBeanServer(String testName) {
        super(testName);
    }

    public static void main(String[] args) {
        TestRemoteMBeanServer testRemoteMBeanServer1 = new TestRemoteMBeanServer();
        testRemoteMBeanServer1.setUp();
        testRemoteMBeanServer1.testRemoteMBeanServer();
        testRemoteMBeanServer1.tearDown();
    }

    protected void setUp() {
        this.glob = this.glob == null ? new Global() : this.glob;
        this.log = this.glob.getLog("test");
        try {
            this.log.info(ME, "setUp of TestRemoteMBeanServer...");
            this.JmxLogChannelName = new ObjectName("xmlBlaster:name=JmxLogChannel");
            this.RequestBrokerName = new ObjectName("xmlBlaster:name=requestBroker");
        }
        catch (MalformedObjectNameException ex) {
            Assert.assertTrue("Object not found!! " + ex.toString(), false);
            this.log.error(ME, "Object not found!! " + ex.toString());
            ex.printStackTrace();
        }
        catch (Exception ex) {
            Assert.assertTrue("Error creating ObjectName!! " + ex.toString(), false);
            this.log.error(ME, "Error creating ObjectName!! " + ex.toString());
            ex.printStackTrace();
        }
    }

    protected void tearDown() {
        this.log.info(ME, "shutting down server...");
        this.server.close();
    }

    public void testRemoteMBeanServer() {
        this.log.info(ME, "creating server on localhost");
        try {
            this.server = ConnectorFactory.getInstance(this.glob).getMBeanServer("localhost");
        }
        catch (ConnectorException ex) {
            Assert.assertTrue("Error connecting to server! " + ex.toString(), false);
        }
        this.testCreateMBean();
        Callback cb2 = this.server.getObjectInstance(this.JmxLogChannelName);
        this.log.info(ME, "Playing around with Bean...");
        this.testInvoke();
        boolean registered = this.testIsRegistered();
        this.testGetAttribute();
        this.testGetMBeanInfo();
        this.testGetMBeanCount();
        this.testUnregisterMBean(registered);
    }

    private boolean testIsRegistered() {
        this.log.info(ME, "Is JmxLogChannelMBean still registered?");
        boolean registered = false;
        try {
            registered = (Boolean)this.server.isRegistered(this.JmxLogChannelName).get();
        }
        catch (Exception ex) {
            this.log.error(ME, "Error when checking for JmxLogChannel! " + ex.toString());
            Assert.assertTrue("Error when checking for JmxLogChannel " + ex.toString(), false);
        }
        if (registered) {
            this.log.info(ME, "success, JmxLogChannel still registered");
        } else {
            this.log.error(ME, "JmxLogChannel no longer registered!");
            Assert.assertTrue("JmxLogChannel no longer registered!", false);
        }
        return registered;
    }

    private void testInvoke() {
        this.log.info(ME, "Invoking addDumpLevel on JmxLogChannelMBean");
        try {
            this.server.invoke(this.JmxLogChannelName, "addDumpLevel", null, null);
        }
        catch (Exception ex) {
            this.log.error(ME, "Error when invoking addDumpLevel on JmxLogChannelMBean! " + ex.toString());
            Assert.assertTrue("Error when invoking addDumpLevel on JmxLogChannelMBean! " + ex.toString(), false);
        }
    }

    private void testCreateMBean() {
        this.log.info(ME, "creating MBean org.xmlBlaster.util.admin.extern.JmxLogChannel");
        this.server.createMBean("org.xmlBlaster.util.admin.extern.JmxLogChannel", this.JmxLogChannelName);
        Callback cb = this.server.getDefaultDomain();
        if (cb == null) {
            Assert.assertTrue("Error when receiving callback...", false);
            this.log.warn(ME, "Error when receiving callback...");
        }
    }

    private void testGetMBeanCount() {
        this.log.info(ME, "counting MBeans on server");
        try {
            this.server.getMBeanCount().get();
        }
        catch (RemoteException ex) {
            this.log.error(ME, "Error when counting MBeans on server! " + ex.toString());
            Assert.assertTrue("Error when counting MBeans on server! " + ex.toString(), false);
        }
    }

    private void testGetAttribute() {
        this.log.info(ME, "Reading attribute");
        try {
            this.server.getAttribute(this.JmxLogChannelName, "LogText");
        }
        catch (Exception ex) {
            this.log.error(ME, "Attribute not found!");
            Assert.assertTrue("Attribute not found!", false);
        }
    }

    private void testUnregisterMBean(boolean registered) {
        this.log.info(ME, "Unregistering MBean");
        try {
            this.server.unregisterMBean(this.JmxLogChannelName);
        }
        catch (Exception ex) {
            this.log.error(ME, "Error when unregistering JmxLogChannel! " + ex.toString());
            Assert.assertTrue("Error when unregistering JmxLogChannel " + ex.toString(), false);
        }
        this.log.info(ME, "Is JmxLogChannelMBean still registered?");
        try {
            registered = (Boolean)this.server.isRegistered(this.JmxLogChannelName).get();
        }
        catch (Exception ex) {
            this.log.error(ME, "Error when checking for JmxLogChannel! " + ex.toString());
            Assert.assertTrue("Error when checking for JmxLogChannel " + ex.toString(), false);
        }
        if (!registered) {
            this.log.info(ME, "success, JmxLogChannel removed");
        } else {
            this.log.error(ME, "JmxLogChannel not removed!");
            Assert.assertTrue("JmxLogChannel not removed", false);
        }
    }

    private void testGetMBeanInfo() {
        this.log.info(ME, "Reading MBeanInfo..");
        MBeanInfo info = null;
        try {
            info = (MBeanInfo)this.server.getMBeanInfo(this.JmxLogChannelName).get();
        }
        catch (Exception ex) {
            this.log.error(ME, "MBeanInfo not found!");
            Assert.assertTrue("MBeanInfo not found!", false);
        }
        if (info == null) {
            this.log.error(ME, "MBeanInfo not found!");
            Assert.assertTrue("MBeanInfo not found!", false);
        }
    }
}

