/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.jmx;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.admin.extern.MethodInvocation;
import org.xmlBlaster.util.admin.extern.SerializeHelper;

public class TestSerializer
extends TestCase {
    private static final String ME = "TestSerializer";
    private Global glob = null;
    private LogChannel log = null;
    SerializeHelper sh = null;
    MethodInvocation mi = null;

    public TestSerializer(String testName) {
        super(testName);
    }

    protected void setUp() {
        this.glob = Global.instance();
        this.log = this.glob.getLog("test");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new TestSerializer("testSerializer"));
        return suite;
    }

    public void testSerializer() {
        try {
            this.sh = new SerializeHelper(this.glob);
        }
        catch (Exception ex) {
            this.log.error(ME, "Error when creating SerializeHelper" + ex.toString());
            Assert.assertTrue("Error when creating SerializeHelper" + ex.toString(), false);
        }
        this.mi = new MethodInvocation();
        try {
            this.mi.setMethodName("Test");
            this.log.info(ME, "Serializing MethodInvocation");
            byte[] testByte = this.sh.serializeObject(this.mi);
            this.log.info(ME, "Deserializing MethodInvocation...");
            MethodInvocation mi2 = (MethodInvocation)this.sh.deserializeObject(testByte);
            if (!mi2.getMethodName().equals("Test")) {
                this.log.error(ME, "Values are different");
                Assert.assertTrue("Values are different", false);
            }
        }
        catch (Exception ex) {
            Assert.assertTrue("Error when serializing or deserialiizing Object " + ex.toString(), false);
            this.log.error(ME, "Error when serializing or deserialiizing Object " + ex.toString());
        }
    }

    public static void main(String[] args) {
        TestSerializer testSer = new TestSerializer("SerializerTest");
        testSer.setUp();
        testSer.testSerializer();
    }
}

