/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.memoryleak;

import java.io.IOException;
import org.jutils.log.LogChannel;
import org.jutils.runtime.ThreadLister;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;

public class Embedded {
    private static String ME = "Embedded";
    private final Global glob;
    private final LogChannel log;
    private int serverPort = 7615;

    public Embedded(Global glob) {
        this.glob = glob;
        this.log = glob.getLog(null);
        Thread.currentThread().setName("EmbeddedTest.MainThread");
    }

    protected void testLoop() {
        boolean interactive = this.glob.getProperty().get("interactive", false);
        long sleep = this.glob.getProperty().get("sleep", 1000L);
        int n = 100;
        int i = 0;
        while (i < n) {
            if (interactive) {
                this.log.info(ME, "Hit a key to start embedded xmlBlaster #" + (i + 1) + "/" + n);
                try {
                    System.in.read();
                }
                catch (IOException e) {}
            } else {
                this.log.info(ME, "********* Start embedded xmlBlaster #" + (i + 1) + "/" + n);
            }
            if (i == 0) {
                this.log.info(ME, "Threads before starting #" + (i + 1) + " num=" + ThreadLister.countThreads());
                ThreadLister.listAllThreads(System.out);
            }
            EmbeddedXmlBlaster embeddedXmlBlaster = EmbeddedXmlBlaster.startXmlBlaster(this.glob);
            this.log.info(ME, "Threads with alive server #" + (i + 1) + " num=" + ThreadLister.countThreads());
            ThreadLister.listAllThreads(System.out);
            if (interactive) {
                this.log.info(ME, "Hit a key to stop embedded xmlBlaster #" + (i + 1) + "/" + n);
                try {
                    System.in.read();
                }
                catch (IOException e) {}
            } else {
                this.log.info(ME, "********* Stop embedded xmlBlaster #" + (i + 1) + "/" + n);
            }
            embeddedXmlBlaster.stopServer(true);
            embeddedXmlBlaster = null;
            this.log.info(ME, "Threads after stopping #" + (i + 1) + " num=" + ThreadLister.countThreads());
            ThreadLister.listAllThreads(System.out);
            if (!interactive) {
                try {
                    Thread.currentThread();
                    Thread.sleep(sleep);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            ++i;
        }
        this.log.info(ME, "Done");
    }

    public static void main(String[] args) {
        Embedded embedded = new Embedded(new Global(args));
        embedded.testLoop();
    }
}

