/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.memoryleak;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.jutils.runtime.ThreadLister;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.qos.SessionQos;

public class TestThreadLeak
extends TestCase
implements I_Callback {
    private static String ME = "TestThreadLeak";
    private final Global glob;
    private final LogChannel log;
    private String fileName;
    private int noConnections = 10;
    private boolean noError = true;
    private ArrayList connections = new ArrayList();
    private int maxThreadDiff = 500;
    private String pid;
    private String osName;
    private long cttl = 5000L;

    public TestThreadLeak(Global glob, String testName) throws Exception {
        super(testName);
        this.glob = glob;
        this.log = this.glob.getLog("test");
        this.fileName = glob.getProperty().get("pidFileName", (String)null);
    }

    protected void setUp() throws Exception {
        String[] args = new String[]{"-protocol", "SOCKET", "-session.maxSessions", "20"};
        this.glob.init(args);
        if (this.fileName != null) {
            int i = 0;
            File file = new File(this.fileName);
            while (!file.exists()) {
                if (++i > 4) {
                    Assert.fail("We where given a pid filename " + file + " but could not find it, giving up");
                }
                Thread.sleep(2000L);
            }
            BufferedReader r = new BufferedReader(new FileReader(file));
            this.pid = r.readLine();
        }
        this.osName = System.getProperty("os.name");
    }

    void dumpThreadStack() throws Exception {
        if (this.pid != null && !this.osName.startsWith("Window")) {
            Runtime runtime = Runtime.getRuntime();
            Process p = runtime.exec("kill -3 " + this.pid);
            p.waitFor();
        } else {
            this.log.info(ME, "Could not dump stack pid=" + this.pid + " os=" + this.osName);
        }
    }

    void handleLock(ConnectorWorker wr) throws Exception {
        this.dumpThreadStack();
    }

    public void testThreadLeakage() throws Exception {
        int startNoThreads = -1;
        int lastNoThreads = -1;
        int round = 0;
        while (this.noError) {
            this.log.info(ME, "Doing a new connection round no " + ++round);
            int i = 0;
            while (i < this.noConnections) {
                ConnectorWorker conn = new ConnectorWorker(this.glob, this.cttl);
                this.connections.add(conn);
                ++i;
            }
            System.gc();
            Thread.sleep(1000L);
            System.gc();
            Thread.sleep(1000L);
            int noThreads = ThreadLister.countThreads();
            if (startNoThreads != -1) {
                startNoThreads = noThreads;
                lastNoThreads = noThreads;
            } else {
                int firstDiff = noThreads - startNoThreads;
                int lastDiff = noThreads - lastNoThreads;
                this.log.info(ME, "No of thread created since start:" + firstDiff + "; number of threads created since last round: " + lastDiff);
                lastNoThreads = noThreads;
                if (firstDiff > this.maxThreadDiff) {
                    ThreadLister.listAllThreads(System.out);
                    Assert.fail("Max number of new threads reached " + firstDiff + " number of threads created since first round: XmlBlaster is leaking huge numbers of threads. Happened in round " + round);
                }
            }
            Thread.sleep(this.noConnections * 1000);
            Iterator c = ((AbstractList)this.connections).iterator();
            while (c.hasNext()) {
                Throwable t;
                ConnectorWorker w = (ConnectorWorker)c.next();
                if (w.isAlive()) {
                    int j = 0;
                    while (w.isAlive() && j < 4) {
                        this.log.warn(ME, "Possible lock of connection " + w + " detected, waiting 30 s round " + j);
                        Thread.sleep(30000L);
                        if (++j <= 3) continue;
                        this.log.error(ME, "Possible lock of connection " + w + " detected, aborting");
                        this.noError = false;
                        this.handleLock(w);
                    }
                }
                if ((t = w.getException()) == null) continue;
                this.log.error(ME, "Connection had exception, giving up : " + t);
                t.printStackTrace();
                Assert.fail("Connection had exception, giving up : " + t);
            }
            this.connections.clear();
        }
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.log.info(ME, "Receiving update of a message " + updateKey.getOid() + " for subId: " + updateQos.getSubscriptionId());
        this.log.trace(ME, "Got message " + new String(content));
        return "";
    }

    public static Test suite() throws Exception {
        TestSuite suite = new TestSuite();
        suite.addTest(new TestThreadLeak(new Global(), "testThreadLeakage"));
        return suite;
    }

    public static void main(String[] args) throws Exception {
        try {
            Global glob = new Global();
            if (glob.init(args) != 0) {
                System.err.println(ME + ": Init failed");
                System.exit(1);
            }
            TestThreadLeak testSub = new TestThreadLeak(glob, "testThreadLeak");
            testSub.setUp();
            testSub.testThreadLeakage();
            testSub.tearDown();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    class ConnectorWorker
    implements Runnable {
        Global glob;
        long timeout;
        private I_XmlBlasterAccess con = null;
        Thread internalThread;
        Throwable ie;
        ConnectReturnQos retQos;
        volatile String state = "CREATED";
        volatile long started;

        public ConnectorWorker(Global glob, long timeout) {
            this.glob = glob.getClone(null);
            this.timeout = timeout;
            this.internalThread = new Thread(this);
            this.internalThread.start();
        }

        public void run() {
            this.started = System.currentTimeMillis();
            this.state = "RUNNING";
            if (Thread.currentThread() != this.internalThread) {
                this.ie = new RuntimeException("Only internal thread allowed");
                throw (RuntimeException)this.ie;
            }
            try {
                this.state = "CONNECTING";
                this.con = this.glob.getXmlBlasterAccess();
                ConnectQos qos = new ConnectQos(this.glob, "test", "dummy");
                this.retQos = this.con.connect(qos, TestThreadLeak.this);
                TestThreadLeak.this.log.info(ME, "Connected " + this);
                this.state = "CONNECTED";
                Thread.sleep(this.timeout);
                this.state = "DISCONNECTING";
                this.con.disconnect(null);
                this.state = "DISCONNECTED";
                this.con = null;
                this.glob.shutdown();
                this.glob = null;
            }
            catch (Throwable e) {
                this.ie = e;
                TestThreadLeak.this.log.error(ME, "Giving up " + e);
            }
        }

        public long getAgeSeconds() {
            return (System.currentTimeMillis() - this.started) / 1000L;
        }

        public String getState() {
            return this.state;
        }

        public String toString() {
            String s = super.toString();
            String q = "";
            if (this.retQos != null) {
                SessionQos ses = this.retQos.getSessionQos();
                q = "secretId=" + ses.getSecretSessionId() + " publicId=" + ses.getPublicSessionId();
            }
            return s + ":" + this.state + " age=" + this.getAgeSeconds() + " seconds old, (thread=" + this.internalThread.getName() + ") " + q;
        }

        public Throwable getException() {
            return this.ie;
        }

        public boolean isAlive() {
            return this.internalThread.isAlive();
        }
    }
}

