/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.mime;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.GetQos;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.AccessFilterQos;

public class TestGetFilter
extends TestCase {
    private static String ME = "TestGetFilter";
    private final Global glob;
    private final LogChannel log;
    private I_XmlBlasterAccess con = null;
    private String name;
    private String passwd = "secret";
    private EmbeddedXmlBlaster serverThread;
    private int serverPort = 7615;
    private int filterMessageContentBiggerAs = 10;

    public TestGetFilter(Global glob, String testName, String name) {
        super(testName);
        this.glob = glob;
        this.log = this.glob.getLog("test");
        this.name = name;
    }

    protected void setUp() {
        String[] args = new String[]{"-bootstrapPort", "" + this.serverPort, "-plugin/socket/port", "" + (this.serverPort - 1), "-plugin/rmi/registryPort", "" + (this.serverPort - 2), "-plugin/xmlrpc/port", "" + (this.serverPort - 3), "-MimeAccessPlugin[ContentLenFilter][1.0]", "org.xmlBlaster.engine.mime.demo.ContentLenFilter,DEFAULT_MAX_LEN=200,THROW_EXCEPTION_FOR_LEN=3"};
        this.glob.init(args);
        this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.glob);
        this.log.info(ME, "XmlBlaster is ready for testing subscribe MIME filter");
        try {
            this.log.info(ME, "Connecting ...");
            this.con = this.glob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(this.glob, this.name, this.passwd);
            this.con.connect(qos, null);
        }
        catch (Exception e) {
            Thread.currentThread();
            Thread.dumpStack();
            this.log.error(ME, "Can't connect to xmlBlaster: " + e.toString());
        }
    }

    protected void tearDown() {
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        try {
            EraseReturnQos[] arr = this.con.erase("<key oid='MSG'/>", null);
            if (arr.length != 1) {
                this.log.error(ME, "Erased " + arr.length + " messages:");
            }
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "XmlBlasterException: " + e.getMessage());
        }
        this.con.disconnect(null);
        this.con = null;
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
        this.serverThread = null;
        Util.resetPorts();
    }

    public void testFilter() {
        MsgUnit[] msgUnits;
        GetQos qos;
        this.log.info(ME, "testFilter() with filterMessageContentBiggerAs=" + this.filterMessageContentBiggerAs + " ...");
        this.log.info(ME, "TEST 1: Testing unfiltered message");
        String content = "1234567890";
        try {
            this.con.publish(new MsgUnit("<key oid='MSG'/>", content.getBytes(), null));
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
        try {
            qos = new GetQos(this.glob);
            qos.addAccessFilter(new AccessFilterQos(this.glob, "ContentLenFilter", "1.0", "" + this.filterMessageContentBiggerAs));
            msgUnits = this.con.get("<key oid='MSG'/>", qos.toXml());
            Assert.assertTrue("Expected one returned message", msgUnits != null);
            Assert.assertTrue("Expected exactly one returned message", msgUnits.length == 1);
            Assert.assertTrue("Message content in corrupted '" + new String(msgUnits[0].getContent()) + "' versus '" + content + "'", msgUnits[0].getContent().length == content.length());
            this.log.info(ME, "Success: Got one message.");
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("get - XmlBlasterException: " + e.getMessage(), false);
        }
        this.log.info(ME, "TEST 2: Testing filtered message");
        content = "12345678901";
        try {
            this.con.publish(new MsgUnit("<key oid='MSG'/>", content.getBytes(), null));
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
        try {
            qos = new GetQos(this.glob);
            qos.addAccessFilter(new AccessFilterQos(this.glob, "ContentLenFilter", "1.0", "" + this.filterMessageContentBiggerAs));
            msgUnits = this.con.get("<key oid='MSG'/>", qos.toXml());
            Assert.assertTrue("Expected one returned message", msgUnits != null);
            Assert.assertEquals("Expected no returned message", 0, msgUnits.length);
            this.log.info(ME, "Success: Got no message.");
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.fail("get - XmlBlasterException: " + e.getMessage());
        }
        this.log.info(ME, "TEST 3: Test what happens if the plugin throws an exception");
        try {
            this.con.publish(new MsgUnit("<key oid='MSG'/>", "123".getBytes(), null));
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.fail("publish - XmlBlasterException: " + e.getMessage());
        }
        try {
            qos = new GetQos(this.glob);
            qos.addAccessFilter(new AccessFilterQos(this.glob, "ContentLenFilter", "1.0", "" + this.filterMessageContentBiggerAs));
            msgUnits = this.con.get("<key oid='MSG'/>", qos.toXml());
            Assert.fail("get() message should throw an XmlBlasterException, but it didn't happen");
        }
        catch (XmlBlasterException e) {
            this.log.info(ME, "SUCCESS: We expected an XmlBlasterException: " + e.getMessage());
        }
        this.log.info(ME, "Success in testFilter()");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "Tim";
        suite.addTest(new TestGetFilter(new Global(), "testFilter", "Tim"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.err.println(ME + ": Init failed");
            System.exit(1);
        }
        TestGetFilter testSub = new TestGetFilter(glob, "TestGetFilter", "Tim");
        testSub.setUp();
        testSub.testFilter();
    }
}

