/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.mime;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.address.Destination;

public class TestPublishFilter
extends TestCase {
    private static String ME = "TestPublishFilter";
    private final Global glob;
    private final LogChannel log;
    private I_XmlBlasterAccess con = null;
    private String name;
    private String passwd = "secret";
    private EmbeddedXmlBlaster serverThread;
    private int serverPort = 7619;
    private int filterMessageContentBiggerAs = 10;
    private int numUpdated = 0;

    public TestPublishFilter(Global glob, String testName, String name) {
        super(testName);
        this.glob = glob;
        this.log = glob.getLog(null);
        this.name = name;
    }

    protected void setUp() {
        String[] args = new String[]{"-bootstrapPort", "" + this.serverPort, "-plugin/socket/port", "" + (this.serverPort - 1), "-plugin/rmi/registryPort", "" + (this.serverPort - 2), "-plugin/xmlrpc/port", "" + (this.serverPort - 3), "-MimePublishPlugin[PublishLenChecker][1.0]", "org.xmlBlaster.engine.mime.demo.PublishLenChecker,DEFAULT_MAX_LEN=10,THROW_EXCEPTION_FOR_LEN=3"};
        this.glob.init(args);
        this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.glob);
        this.log.info(ME, "XmlBlaster is ready for testing publish MIME filter");
        try {
            this.log.info(ME, "Connecting ...");
            this.con = this.glob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(this.glob, this.name, this.passwd);
            this.con.connect(qos, new I_Callback(){

                public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
                    TestPublishFilter.this.log.info(TestPublishFilter.this.name, "Reveiving asynchronous message '" + updateKey.getOid() + "' in default handler");
                    TestPublishFilter.this.numUpdated++;
                    return "";
                }
            });
        }
        catch (Exception e) {
            Thread.currentThread();
            Thread.dumpStack();
            this.log.error(ME, "Can't connect to xmlBlaster: " + e.toString());
        }
    }

    protected void tearDown() {
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        this.con.disconnect(null);
        this.con = null;
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
        this.serverThread = null;
        Util.resetPorts();
    }

    public void testFilter() {
        MsgUnit[] msgUnits;
        PublishReturnQos rq;
        this.log.info(ME, "testFilter() with filterMessageContentBiggerAs=" + this.filterMessageContentBiggerAs + " ...");
        this.log.info(ME, "TEST 1: Testing filtered message");
        String content = "12345678901";
        try {
            rq = this.con.publish(new MsgUnit("<key oid='MSG'/>", content.getBytes(), null));
            this.log.info(ME, "TEST 1: SUCCESS returned state=" + rq.getState());
            Assert.assertTrue("Return OK", !"OK".equals(rq.getState()));
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
        try {
            msgUnits = this.con.get("<key oid='MSG'/>", null);
            Assert.assertTrue("Invalid return", msgUnits != null);
            Assert.assertEquals("Expected no returned message", 0, msgUnits.length);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "get - XmlBlasterException: " + e.getMessage());
            Assert.fail("get - XmlBlasterException: " + e.getMessage());
        }
        this.log.info(ME, "TEST 2: Testing unfiltered message");
        content = "1234567890";
        try {
            rq = this.con.publish(new MsgUnit("<key oid='MSG'/>", content.getBytes(), null));
            Assert.assertEquals("Return not OK", "OK", rq.getState());
            this.log.info(ME, "TEST 2: SUCCESS");
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
        try {
            msgUnits = this.con.get("<key oid='MSG'/>", null);
            Assert.assertTrue("Expected one returned message", msgUnits != null);
            Assert.assertTrue("Expected exactly one returned message", msgUnits.length == 1);
            Assert.assertTrue("Message content in corrupted '" + new String(msgUnits[0].getContent()) + "' versus '" + content + "'", msgUnits[0].getContent().length == content.length());
            this.log.info(ME, "Success: Got one message.");
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "get - XmlBlasterException: " + e.getMessage());
            Assert.fail("get - XmlBlasterException: " + e.getMessage());
        }
        this.log.info(ME, "TEST 3: Test what happens if the plugin throws an exception");
        try {
            this.con.publish(new MsgUnit("<key oid='MSG'/>", "123".getBytes(), null));
            Assert.fail("publish - expected an XmlBlasterException");
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "TEST 3: SUCCESS XmlBlasterException: " + e.getMessage());
        }
        try {
            EraseReturnQos[] arr = this.con.erase("<key oid='MSG'/>", null);
            Assert.assertEquals("Erased problem", 1, arr.length);
        }
        catch (XmlBlasterException e) {
            Assert.fail(ME + " XmlBlasterException: " + e.getMessage());
        }
        this.log.info(ME, "Success in testFilter()");
    }

    public void testPtPFilter() {
        PublishReturnQos rq;
        PublishQos pq;
        this.log.info(ME, "testPtPFilter() with filterMessageContentBiggerAs=" + this.filterMessageContentBiggerAs + " ...");
        this.numUpdated = 0;
        this.log.info(ME, "TEST 1: Testing filtered PtP message");
        String content = "12345678901";
        try {
            pq = new PublishQos(this.glob);
            pq.addDestination(new Destination(new SessionName(this.glob, this.name)));
            rq = this.con.publish(new MsgUnit("<key oid='MSG'/>", content.getBytes(), pq.toXml()));
            this.log.info(ME, "TEST 1: SUCCESS returned state=" + rq.getState());
            Assert.assertTrue("Return OK", !"OK".equals(rq.getState()));
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
        try {
            MsgUnit[] msgUnits = this.con.get("<key oid='MSG'/>", null);
            Assert.assertTrue("Invalid return", msgUnits != null);
            Assert.assertEquals("Expected no returned message", 0, msgUnits.length);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "get - XmlBlasterException: " + e.getMessage());
            Assert.fail("get - XmlBlasterException: " + e.getMessage());
        }
        this.log.info(ME, "TEST 2: Testing unfiltered PtP message");
        content = "1234567890";
        try {
            pq = new PublishQos(this.glob);
            pq.addDestination(new Destination(new SessionName(this.glob, this.name)));
            rq = this.con.publish(new MsgUnit("<key oid='MSG'/>", content.getBytes(), pq.toXml()));
            Assert.assertEquals("Return not OK", "OK", rq.getState());
            this.log.info(ME, "TEST 2: SUCCESS");
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
        this.log.info(ME, "TEST 3: Test what happens if the plugin throws an exception");
        try {
            pq = new PublishQos(this.glob);
            pq.addDestination(new Destination(new SessionName(this.glob, this.name)));
            this.con.publish(new MsgUnit("<key oid='MSG'/>", "123".getBytes(), pq.toXml()));
            Assert.fail("publish - expected an XmlBlasterException");
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "TEST 3: SUCCESS XmlBlasterException: " + e.getMessage());
        }
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals("PtP updates is not one", 1, this.numUpdated);
        this.log.info(ME, "Success in testPtPFilter()");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "Tim";
        suite.addTest(new TestPublishFilter(new Global(), "testFilter", "Tim"));
        suite.addTest(new TestPublishFilter(new Global(), "testPtPFilter", "Tim"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.exit(0);
        }
        TestPublishFilter testSub = new TestPublishFilter(glob, "TestPublishFilter", "Tim");
        testSub.setUp();
        testSub.testFilter();
        testSub.testPtPFilter();
    }
}

