/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.mime;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.AccessFilterQos;

public class TestSubscribeFilter
extends TestCase
implements I_Callback {
    private static String ME = "TestSubscribeFilter";
    private final Global glob;
    private final LogChannel log;
    private I_XmlBlasterAccess con = null;
    private String name;
    private String passwd = "secret";
    private int numReceived = 0;
    private String updateOid;
    private EmbeddedXmlBlaster serverThread;
    private int serverPort = 7624;
    private int filterMessageContentBiggerAs = 10;

    public TestSubscribeFilter(Global glob, String testName, String name) {
        super(testName);
        this.glob = glob;
        this.log = this.glob.getLog("test");
        this.name = name;
    }

    protected void setUp() {
        Object qos;
        String[] args = new String[]{"-bootstrapPort", "" + this.serverPort, "-plugin/socket/port", "" + (this.serverPort - 1), "-plugin/rmi/registryPort", "" + (this.serverPort - 2), "-plugin/xmlrpc/port", "" + (this.serverPort - 3), "-MimeAccessPlugin[ContentLenFilter][1.0]", "org.xmlBlaster.engine.mime.demo.ContentLenFilter,DEFAULT_MAX_LEN=200,THROW_EXCEPTION_FOR_LEN=3", "-admin.remoteconsole.port", "0"};
        this.glob.init(args);
        this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(args);
        this.log.info(ME, "XmlBlaster is ready for testing subscribe MIME filter");
        try {
            this.log.info(ME, "Connecting ...");
            this.con = this.glob.getXmlBlasterAccess();
            qos = new ConnectQos(this.glob, this.name, this.passwd);
            this.con.connect((ConnectQos)qos, this);
        }
        catch (Exception e) {
            Thread.currentThread();
            Thread.dumpStack();
            this.log.error(ME, "Can't connect to xmlBlaster: " + e.toString());
        }
        try {
            qos = new SubscribeQos(this.glob);
            ((SubscribeQos)qos).addAccessFilter(new AccessFilterQos(this.glob, "ContentLenFilter", "1.0", "" + this.filterMessageContentBiggerAs));
            String subscribeOid = this.con.subscribe("<key oid='MSG'/>", ((SubscribeQos)qos).toXml()).getSubscriptionId();
            this.log.info(ME, "Success: Subscribe subscription-id=" + subscribeOid + " done");
            this.con.subscribe("<key oid='__sys__deadMessage'/>", "<qos/>");
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    protected void tearDown() {
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        try {
            EraseReturnQos[] arr = this.con.erase("<key oid='MSG'/>", "<qos/>");
            Assert.assertEquals("Erase", 1, arr.length);
        }
        catch (XmlBlasterException e) {
            Assert.fail("Erase XmlBlasterException: " + e.getMessage());
        }
        this.con.disconnect(null);
        this.con = null;
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
        this.serverThread = null;
        Util.resetPorts();
    }

    public void testFilter() {
        this.log.info(ME, "testFilter() with filterMessageContentBiggerAs=" + this.filterMessageContentBiggerAs + " ...");
        this.log.info(ME, "TEST 1: Testing unfiltered message");
        try {
            this.con.publish(new MsgUnit("<key oid='MSG'/>", "1234567890".getBytes(), null));
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
        this.waitOnUpdate(2000L, 1);
        this.log.info(ME, "TEST 2: Testing filtered message");
        try {
            this.con.publish(new MsgUnit("<key oid='MSG'/>", "12345678901".getBytes(), null));
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
        this.waitOnUpdate(2000L, 0);
        this.log.info(ME, "TEST 3: Test what happens if the plugin throws an exception");
        try {
            this.con.publish(new MsgUnit("<key oid='MSG'/>", "123".getBytes(), null));
            this.waitOnUpdate(2000L, 1);
            Assert.assertEquals("", "__sys__deadMessage", this.updateOid);
            this.log.info(ME, "SUCCESS: Dead message arrived");
        }
        catch (XmlBlasterException e) {
            Assert.fail("publish forced the plugin to throw an XmlBlasterException, but it should not reach the publisher: " + e.toString());
        }
        this.waitOnUpdate(2000L, 0);
        this.log.info(ME, "Success in testFilter()");
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.log.info(ME, "Receiving update of a message '" + updateKey.getOid() + "' state=" + updateQos.getState());
        this.updateOid = updateKey.getOid();
        ++this.numReceived;
        return "";
    }

    private void waitOnUpdate(long timeout, int numWait) {
        long pollingInterval = 50L;
        if (timeout < 50L) {
            pollingInterval = timeout / 10L;
        }
        long sum = 0L;
        while (this.numReceived < numWait) {
            try {
                Thread.currentThread();
                Thread.sleep(pollingInterval);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            Assert.assertTrue("Timeout of " + timeout + " occurred without update", (sum += pollingInterval) <= timeout);
        }
        try {
            Thread.currentThread();
            Thread.sleep(timeout);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assert.assertEquals("Wrong number of messages arrived", numWait, this.numReceived);
        this.numReceived = 0;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "Tim";
        suite.addTest(new TestSubscribeFilter(new Global(), "testFilter", "Tim"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.err.println(ME + ": Init failed");
            System.exit(1);
        }
        TestSubscribeFilter testSub = new TestSubscribeFilter(glob, "TestSubscribeFilter", "Tim");
        testSub.setUp();
        testSub.testFilter();
    }
}

