/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.mime;

import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.AccessFilterQos;

public class TestXPathSubscribeFilter
extends TestCase
implements I_Callback {
    private static String ME = "Tim";
    private final Global glob;
    private final LogChannel log;
    private I_XmlBlasterAccess con = null;
    private String name;
    private String passwd = "secret";
    private int numReceived = 0;
    private EmbeddedXmlBlaster serverThread;
    private int serverPort = 7624;
    private int filterMessageContentBiggerAs = 10;
    private HashMap subscriberTable = new HashMap();
    private int[] subRec = new int[4];
    String subscribeOid;
    String subscribeOid2;
    String subscribeOid3;
    String subscribeOid4;

    public TestXPathSubscribeFilter(Global glob, String testName, String name) {
        super(testName);
        this.glob = glob;
        this.log = this.glob.getLog("test");
        this.name = name;
    }

    protected void setUp() {
        Object qos;
        String[] args = new String[]{"-bootstrapPort", "" + this.serverPort, "-plugin/socket/port", "" + (this.serverPort - 1), "-plugin/rmi/registryPort", "" + (this.serverPort - 2), "-plugin/xmlrpc/port", "" + (this.serverPort - 3), "-MimeAccessPlugin[XPathFilter][1.0]", "org.xmlBlaster.engine.mime.xpath.XPathFilter,engine.mime.xpath.extension_functions=:contains-ignore-case:org.xmlBlaster.engine.mime.xpath.ContainsIgnoreCaseFunction;:recursive-text:org.xmlBlaster.engine.mime.xpath.RecursiveTextFunction", "-admin.remoteconsole.port", "0"};
        this.glob.init(args);
        this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(args);
        this.log.info(ME, "XmlBlaster is ready for testing subscribe MIME filter");
        try {
            this.log.info(ME, "Connecting ...");
            this.con = this.glob.getXmlBlasterAccess();
            qos = new ConnectQos(this.glob, this.name, this.passwd);
            this.con.connect((ConnectQos)qos, this);
        }
        catch (Exception e) {
            Thread.currentThread();
            Thread.dumpStack();
            this.log.error(ME, "Can't connect to xmlBlaster: " + e.toString());
        }
        try {
            qos = new SubscribeQos(this.glob);
            ((SubscribeQos)qos).addAccessFilter(new AccessFilterQos(this.glob, "XPathFilter", "1.0", "/news[@type='sport']"));
            this.subscribeOid = this.con.subscribe("<key oid='MSG'/>", ((SubscribeQos)qos).toXml()).getSubscriptionId();
            this.subscriberTable.put(this.subscribeOid, new Integer(0));
            this.log.info(ME, "Success: Subscribe subscription-id=" + this.subscribeOid + " done");
            qos = new SubscribeQos(this.glob);
            ((SubscribeQos)qos).addAccessFilter(new AccessFilterQos(this.glob, "XPathFilter", "1.0", "/news[@type='culture']"));
            this.subscribeOid2 = this.con.subscribe("<key oid='MSG'/>", ((SubscribeQos)qos).toXml()).getSubscriptionId();
            this.subscriberTable.put(this.subscribeOid2, new Integer(1));
            this.log.info(ME, "Success: Subscribe subscription-id2=" + this.subscribeOid2 + " done");
            qos = new SubscribeQos(this.glob);
            ((SubscribeQos)qos).addAccessFilter(new AccessFilterQos(this.glob, "XPathFilter", "1.0", "/news[@type='sport' or @type='culture']"));
            this.subscribeOid3 = this.con.subscribe("<key oid='AnotherMsG'/>", ((SubscribeQos)qos).toXml()).getSubscriptionId();
            this.subscriberTable.put(this.subscribeOid3, new Integer(2));
            this.log.info(ME, "Success: Subscribe subscription-id3=" + this.subscribeOid3 + " done");
            qos = new SubscribeQos(this.glob);
            ((SubscribeQos)qos).addAccessFilter(new AccessFilterQos(this.glob, "XPathFilter", "1.0", "/news[ contains-ignore-case( recursive-text(body), 'needle')]"));
            this.subscribeOid4 = this.con.subscribe("<key oid='AnotherMsG'/>", ((SubscribeQos)qos).toXml()).getSubscriptionId();
            this.subscriberTable.put(this.subscribeOid4, new Integer(3));
            this.log.info(ME, "Success: Subscribe subscription-id4=" + this.subscribeOid4 + " done");
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    protected void tearDown() {
        this.log.info(ME, "TEST: tearing down");
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        try {
            this.con.unSubscribe("<key oid='" + this.subscribeOid + "'/>", "<qos/>");
            this.con.unSubscribe("<key oid='" + this.subscribeOid2 + "'/>", "<qos/>");
            this.con.unSubscribe("<key oid='" + this.subscribeOid3 + "'/>", "<qos/>");
            this.con.unSubscribe("<key oid='" + this.subscribeOid4 + "'/>", "<qos/>");
            EraseReturnQos[] arr = this.con.erase("<key oid='MSG'/>", "<qos/>");
            Assert.assertEquals("Erase", 1, arr.length);
            arr = this.con.erase("<key oid='AnotherMsG'/>", "<qos/>");
            Assert.assertEquals("Erase", 1, arr.length);
        }
        catch (XmlBlasterException e) {
            Assert.fail("Erase XmlBlasterException: " + e.getMessage());
        }
        this.con.disconnect(null);
        this.con = null;
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
        this.serverThread = null;
        Util.resetPorts();
    }

    public void testFilter() {
        this.log.info(ME, "testFilter() with XPath filter /news[@type='sport'] ...");
        this.log.info(ME, "TEST 1: Testing sport message");
        try {
            this.con.publish(new MsgUnit("<key oid='MSG' contentMime='text/xml'/>", "<news type='sport'></news>".getBytes(), null));
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
        this.waitOnUpdate(this.subscribeOid, 4000L, 1);
        this.log.info(ME, "TEST 2: Testing culture message");
        try {
            this.con.publish(new MsgUnit("<key oid='MSG' contentMime='text/xml'/>", "<news type='culture'></news>".getBytes(), null));
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
        this.waitOnUpdate(this.subscribeOid2, 4000L, 1);
        this.log.info(ME, "TEST 3: Testing AnotherMsG message");
        try {
            this.con.publish(new MsgUnit("<key oid='AnotherMsG' contentMime='text/xml'/>", "<news type='culture'></news>".getBytes(), null));
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
        this.waitOnUpdate(this.subscribeOid3, 4000L, 1);
        this.log.info(ME, "TEST 4: Testing extention functions");
        try {
            this.con.publish(new MsgUnit("<key oid='AnotherMsG' contentMime='text/xml'/>", "<news><body><p>A little message</p><p>With a Needle in second paragraph wich normal XPath string function would not see</p></body></news>".getBytes(), null));
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
        this.waitOnUpdate(this.subscribeOid4, 4000L, 1);
        this.log.info(ME, "Success in testFilter()");
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.log.info(ME, "Receiving update of a message " + updateKey.getOid() + " for subId: " + updateQos.getSubscriptionId());
        int ii = (Integer)this.subscriberTable.get(updateQos.getSubscriptionId());
        this.log.trace(ME, "Got message " + new String(content));
        int n = ii;
        this.subRec[n] = this.subRec[n] + 1;
        ++this.numReceived;
        return "";
    }

    private void waitOnUpdate(String subId, long timeout, int numWait) {
        long pollingInterval = 50L;
        if (timeout < 50L) {
            pollingInterval = timeout / 10L;
        }
        long sum = 0L;
        int ii = (Integer)this.subscriberTable.get(subId);
        while (this.subRec[ii] < numWait) {
            try {
                Thread.currentThread();
                Thread.sleep(pollingInterval);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            Assert.assertTrue("Timeout of " + timeout + " occurred without update", (sum += pollingInterval) <= timeout);
        }
        try {
            Thread.currentThread();
            Thread.sleep(timeout);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assert.assertEquals("Wrong number of messages arrived", numWait, this.subRec[ii]);
        this.log.info(ME, "Found correct rec messages for: " + subId);
        this.subRec[ii] = 0;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "Tim";
        suite.addTest(new TestXPathSubscribeFilter(new Global(), "testFilter", "Tim"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.err.println(ME + ": Init failed");
            System.exit(1);
        }
        TestXPathSubscribeFilter testSub = new TestXPathSubscribeFilter(glob, "TestXPathSubscribeFilter", "Tim");
        testSub.setUp();
        testSub.testFilter();
        testSub.tearDown();
    }
}

