/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.persistence;

import java.io.File;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.io.FileUtil;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class TestPersistence
extends TestCase
implements I_Callback {
    private static final String ME = "TestPersistence";
    private Global glob = null;
    private LogChannel log = null;
    private final String senderName = "Gesa";
    private String publishOid = "HelloPersistent";
    private I_XmlBlasterAccess senderConnection = null;
    private String senderContent = "Some persistent content";
    private int numReceived = 0;

    public TestPersistence(String testName) {
        super(testName);
    }

    protected void setUp() {
        if (this.glob == null) {
            this.glob = new Global();
        }
        this.log = this.glob.getLog("test");
        try {
            String passwd = "secret";
            this.senderConnection = this.glob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(this.glob, "Gesa", passwd);
            this.senderConnection.connect(qos, this);
        }
        catch (Exception e) {
            this.log.error(ME, e.toString());
            e.printStackTrace();
        }
    }

    protected void tearDown() {
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        String xmlKey = "<key oid='" + this.publishOid + "' queryType='EXACT'>\n</key>";
        String qos = "<qos></qos>";
        try {
            EraseReturnQos[] arr = this.senderConnection.erase(xmlKey, qos);
            Assert.assertEquals("Erase", 1, arr.length);
        }
        catch (XmlBlasterException e) {
            Assert.fail("Erase XmlBlasterException: " + e.getMessage());
        }
        this.checkContent(false);
        this.senderConnection.disconnect(null);
    }

    public void sendPersistent() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Testing a persistent message ...");
        }
        String xmlKey = "<key oid='" + this.publishOid + "' contentMime='text/plain' contentMimeExtended='2.0' domain='RUGBY'>\n" + "</key>";
        String qos = "<qos>   <persistent /></qos>";
        try {
            MsgUnit msgUnit = new MsgUnit(xmlKey, this.senderContent.getBytes(), qos);
            String returnedOid = this.senderConnection.publish(msgUnit).getKeyOid();
            Assert.assertEquals("Retunred oid is invalid", this.publishOid, returnedOid);
            this.log.info(ME, "Sending of '" + this.senderContent + "' done, returned oid=" + this.publishOid);
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "publish() XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
        this.waitOnUpdate(1000L, 0);
        Assert.assertEquals("numReceived after sending", 0, this.numReceived);
        this.numReceived = 0;
    }

    public void testPersistent() {
        this.sendPersistent();
        this.checkContent(true);
        this.senderContent = this.senderContent + " again";
        this.sendPersistent();
        this.checkContent(true);
    }

    void checkContent(boolean checkContent) {
        String driverType = this.glob.getProperty().get("Persistence.Driver.Type", (String)null);
        if (driverType == null || !driverType.equals("filestore")) {
            this.log.info(ME, "Sorry, can't check persistence store, only checks for FileDriver is implemented");
            return;
        }
        String path = this.glob.getProperty().get("Persistence.Path", (String)null);
        if (path == null) {
            this.log.info(ME, "Sorry, xmlBlaster is running memory based only, no checks possible");
            return;
        }
        if (checkContent) {
            try {
                String persistenceContent = FileUtil.readAsciiFile(path, this.publishOid);
                Assert.assertEquals("Written content is corrupted", this.senderContent, persistenceContent);
            }
            catch (Exception e) {
                Assert.assertTrue("Couldn't read file " + FileUtil.concatPath(path, this.publishOid), false);
            }
        } else {
            File f = new File(path, this.publishOid);
            if (f.exists()) {
                Assert.assertTrue("File " + FileUtil.concatPath(path, this.publishOid) + " is not erased properly", false);
            }
        }
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.log.info(ME, "Receiving update of a message, checking ...");
        ++this.numReceived;
        Assert.assertEquals("Wrong sender", "Gesa", updateQos.getSender().getLoginName());
        Assert.assertEquals("Wrong oid of message returned", this.publishOid, updateKey.getOid());
        Assert.assertEquals("Wrong mime of message returned", "text/plain", updateKey.getContentMime());
        Assert.assertEquals("Wrong extended mime of message returned", "2.0", updateKey.getContentMimeExtended());
        Assert.assertEquals("Wrong domain of message returned", "RUGBY", updateKey.getDomain());
        Assert.assertEquals("Message content is corrupted", new String(this.senderContent), new String(content));
        return "";
    }

    private void waitOnUpdate(long timeout, int numWait) {
        long pollingInterval = 50L;
        if (timeout < 50L) {
            pollingInterval = timeout / 10L;
        }
        long sum = 0L;
        while (this.numReceived < numWait) {
            try {
                Thread.currentThread();
                Thread.sleep(pollingInterval);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            if ((sum += pollingInterval) <= timeout) continue;
            this.log.warn(ME, "Timeout of " + timeout + " occurred");
            break;
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new TestPersistence("testPersistent"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.err.println("TestPersistence: Init failed");
            System.exit(1);
        }
        TestPersistence testSub = new TestPersistence(ME);
        testSub.setUp();
        testSub.testPersistent();
        testSub.tearDown();
    }
}

