/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.persistence;

import java.io.File;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.io.FileUtil;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.test.Msg;
import org.xmlBlaster.test.MsgInterceptor;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class TestPersistence2
extends TestCase {
    private static final String ME = "TestPersistence2";
    private final Global glob;
    private final LogChannel log;
    private final String senderName = "Gesa";
    private final String senderPasswd = "secret";
    private String publishOid = "HelloPersistent";
    private I_XmlBlasterAccess senderConnection = null;
    private String senderContent = "Some persistent content";
    private EmbeddedXmlBlaster serverThread;
    private int serverPort = 7604;
    private MsgInterceptor updateInterceptor;

    public TestPersistence2(Global glob, String testName) {
        super(testName);
        this.glob = glob;
        this.log = this.glob.getLog("test");
    }

    protected void setUp() {
        this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(Util.getOtherServerPorts(this.serverPort));
        this.log.info(ME, "XmlBlaster is ready for testing on bootstrapPort " + this.serverPort);
        this.doLogin();
    }

    private void doLogin() {
        try {
            Global senderGlobal = Util.getOtherServerPorts(this.glob, this.serverPort);
            this.senderConnection = senderGlobal.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(senderGlobal, "Gesa", "secret");
            this.updateInterceptor = new MsgInterceptor(senderGlobal, this.log, null);
            this.senderConnection.connect(qos, this.updateInterceptor);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "setUp() - login failed");
        }
        catch (Exception e) {
            this.log.error(ME, e.toString());
            e.printStackTrace();
        }
    }

    protected void tearDown() {
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        String xmlKey = "<key oid='" + this.publishOid + "' queryType='EXACT'>\n</key>";
        String qos = "<qos></qos>";
        try {
            EraseReturnQos[] arr = this.senderConnection.erase(xmlKey, qos);
            if (arr.length != 1) {
                this.log.error(ME, "Erased " + arr.length + " messages:");
            }
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "XmlBlasterException: " + e.getMessage());
        }
        this.senderConnection.disconnect(null);
        this.senderConnection = null;
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
        this.serverThread = null;
        Util.resetPorts();
    }

    public void sendPersistent() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Testing a persistent message ...");
        }
        String xmlKey = "<key oid='" + this.publishOid + "' contentMime='text/plain' contentMimeExtended='2.0' domain='RUGBY'/>";
        String qos = "<qos>   <persistent /></qos>";
        try {
            MsgUnit msgUnit = new MsgUnit(xmlKey, this.senderContent.getBytes(), qos);
            String returnedOid = this.senderConnection.publish(msgUnit).getKeyOid();
            Assert.assertEquals("Retunred oid is invalid", this.publishOid, returnedOid);
            this.log.info(ME, "Sending of '" + this.senderContent + "' done, returned oid=" + this.publishOid);
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "publish() XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
        Assert.assertEquals("numReceived after sending", 0, this.updateInterceptor.waitOnUpdate(1000L, this.publishOid, "OK"));
        Assert.assertEquals("", 0, this.updateInterceptor.count());
    }

    public void testPersistent() {
        this.sendPersistent();
        this.checkContent(true);
        this.senderContent = this.senderContent + " again";
        this.sendPersistent();
        this.RestartTestServer();
        this.doLogin();
        try {
            this.senderConnection.subscribe("<key oid='" + this.publishOid + "'/>", "<qos/>");
            this.log.info(ME, "Subscribe done");
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "subscribe() XmlBlasterException: " + e.getMessage());
            Assert.fail("subscribe - XmlBlasterException: " + e.getMessage());
        }
        Assert.assertEquals("", 1, this.updateInterceptor.waitOnUpdate(2000L, this.publishOid, "OK"));
        Msg msg = this.updateInterceptor.getMsgs()[0];
        Assert.assertEquals("Wrong sender", "Gesa", msg.getUpdateQos().getSender().getLoginName());
        Assert.assertEquals("Wrong oid of message returned", this.publishOid, msg.getUpdateKey().getOid());
        Assert.assertEquals("Wrong mime of message returned", "text/plain", msg.getUpdateKey().getContentMime());
        Assert.assertEquals("Wrong extended mime of message returned", "2.0", msg.getUpdateKey().getContentMimeExtended());
        Assert.assertEquals("Wrong domain of message returned", "RUGBY", msg.getUpdateKey().getDomain());
        Assert.assertEquals("Message content is corrupted", new String(this.senderContent), msg.getContentStr());
        this.updateInterceptor.clear();
    }

    public void RestartTestServer() {
        long delay4Server = 4000L;
        this.log.info(ME, "Restarting Test Server");
        try {
            this.senderConnection.disconnect(null);
            EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
            this.serverThread = null;
            Util.delay(delay4Server);
            this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(Util.getOtherServerPorts(this.serverPort));
            Util.delay(delay4Server);
            Global globSender = Util.getOtherServerPorts(this.glob, this.serverPort);
            this.senderConnection = globSender.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(globSender, "Gesa", "secret");
            this.updateInterceptor = new MsgInterceptor(globSender, this.log, null);
            this.senderConnection.connect(qos, this.updateInterceptor);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "setUp() - login failed");
        }
        catch (Exception e) {
            this.log.error(ME, e.toString());
            e.printStackTrace();
        }
    }

    void checkContent(boolean checkContent) {
        String driverType = this.glob.getProperty().get("Persistence.Driver.Type", (String)null);
        if (driverType == null || !driverType.equals("filestore")) {
            this.log.info(ME, "Sorry, can't check persistence store, only checks for FileDriver is implemented");
            return;
        }
        String path = this.glob.getProperty().get("Persistence.Path", (String)null);
        if (path == null) {
            this.log.info(ME, "Sorry, xmlBlaster is running memory based only, no checks possible");
            return;
        }
        if (checkContent) {
            this.log.info(ME, "Checking content of message " + this.publishOid);
            try {
                String persistenceContent = FileUtil.readAsciiFile(path, this.publishOid);
                Assert.assertEquals("Written content is corrupted", this.senderContent, persistenceContent);
            }
            catch (Exception e) {
                Assert.assertTrue("Couldn't read file " + FileUtil.concatPath(path, this.publishOid), false);
            }
        } else {
            File f = new File(path, this.publishOid);
            if (f.exists()) {
                Assert.assertTrue("File " + FileUtil.concatPath(path, this.publishOid) + " is not erased properly", false);
            }
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new TestPersistence2(new Global(), "testPersistent"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.err.println("TestPersistence2: Init failed");
            System.exit(1);
        }
        TestPersistence2 testSub = new TestPersistence2(glob, ME);
        testSub.setUp();
        testSub.testPersistent();
        testSub.tearDown();
    }
}

