/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.persistence;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class TestPersistenceXMLDB
extends TestCase
implements I_Callback {
    private static final String ME = "TestPersistenceXMLDB";
    private Global glob = null;
    private final LogChannel log;
    private final String senderName = "Benedikt";
    private final String senderPasswd = "secret";
    private String publishOid = "amIpersistent";
    private String subscribeString = "subscribeMe";
    private I_XmlBlasterAccess senderConnection = null;
    private String senderContent = "Smoked < Ham";
    private int numReceived = 0;
    private EmbeddedXmlBlaster st;
    private EmbeddedXmlBlaster serverThread1;
    private EmbeddedXmlBlaster serverThread2;
    private int serverPort = 7604;

    public TestPersistenceXMLDB(Global glob, String testName) {
        super(testName);
        this.glob = glob;
        this.log = this.glob.getLog("test");
    }

    protected EmbeddedXmlBlaster startServer() {
        this.glob.init(Util.getOtherServerPorts(this.serverPort));
        EmbeddedXmlBlaster st = EmbeddedXmlBlaster.startXmlBlaster(Util.getOtherServerPorts(this.serverPort));
        this.log.info(ME, "XmlBlaster is ready for testing on bootstrapPort " + this.serverPort);
        return st;
    }

    protected void stopServer(EmbeddedXmlBlaster st) {
        EmbeddedXmlBlaster.stopXmlBlaster(st);
        this.log.info(ME, "Xmlblaster stopped");
        st = null;
    }

    protected I_XmlBlasterAccess connectClient(String name, String passwd) {
        this.log.info(ME, "connect to client: name='" + name + "' passwd='" + passwd + "'");
        I_XmlBlasterAccess sc = null;
        try {
            sc = this.glob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(this.glob, name, passwd);
            sc.connect(qos, this);
            this.log.info(ME, name + " connected");
        }
        catch (Exception e) {
            this.log.error(ME, e.toString());
            e.printStackTrace();
        }
        return sc;
    }

    protected void disconnectClient(I_XmlBlasterAccess sc) {
        try {
            sc.disconnect(null);
            sc = null;
        }
        catch (Exception e) {
            this.log.error(ME, e.toString());
            e.printStackTrace();
        }
    }

    protected void setUp() {
        this.serverThread1 = this.startServer();
        this.senderConnection = this.connectClient("Benedikt", "secret");
        this.sendPersistent(this.senderConnection);
        this.disconnectClient(this.senderConnection);
        this.stopServer(this.serverThread1);
        this.serverThread1 = null;
        this.senderConnection = null;
    }

    protected void tearDown() {
        Util.resetPorts();
    }

    public void sendPersistent(I_XmlBlasterAccess sc) {
        if (this.log.CALL) {
            this.log.call(ME, "sendPersistent");
        }
        if (this.log.TRACE) {
            this.log.trace(ME, "Testing a persistent message ...");
        }
        String xmlKey = "<key oid='" + this.publishOid + "' contentMime='text/plain'>\n" + "   <" + this.subscribeString + "/>\n" + "</key>";
        String qos = "<qos>   <persistent /></qos>";
        try {
            MsgUnit msgUnit = new MsgUnit(xmlKey, this.senderContent.getBytes(), qos);
            String returnedOid = sc.publish(msgUnit).getKeyOid();
            Assert.assertEquals("Returned oid is invalid", this.publishOid, returnedOid);
            this.log.info(ME, "Sending of '" + this.senderContent + "' done, returned oid '" + this.publishOid + "'");
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "publish() XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    protected void subscribe(I_XmlBlasterAccess sc) {
        if (this.log.CALL) {
            this.log.call(ME, "subscribe");
        }
        String xmlKeySub = "<key oid='' queryType='XPATH'>\n/xmlBlaster/key/" + this.subscribeString + " </key>";
        this.log.info(ME, "Subscribe to '" + xmlKeySub + "' ...");
        try {
            sc.subscribe(xmlKeySub, "<qos></qos>");
        }
        catch (XmlBlasterException e2) {
            this.log.warn(ME, "XmlBlasterException: " + e2.getMessage());
        }
    }

    public void testPersistent() {
        this.serverThread2 = this.startServer();
        this.senderConnection = this.connectClient("Benedikt", "secret");
        this.subscribe(this.senderConnection);
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.disconnectClient(this.senderConnection);
        this.stopServer(this.serverThread2);
        this.serverThread2 = null;
        this.senderConnection = null;
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        if (this.log.CALL) {
            this.log.call(ME, "Receiving update of a message ...");
        }
        ++this.numReceived;
        this.log.plain("UpdateKey", updateKey.toXml());
        this.log.plain("content", new String(content).toString());
        this.log.plain("UpdateQos", updateQos.toXml());
        Assert.assertEquals("Wrong sender", "Benedikt", updateQos.getSender().getLoginName());
        Assert.assertEquals("Wrong oid of message returned", this.publishOid, updateKey.getOid());
        Assert.assertEquals("Message content is corrupted", new String(this.senderContent), new String(content));
        return "";
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new TestPersistenceXMLDB(new Global(), "testPersistent"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.err.println("TestPersistenceXMLDB: Init failed");
            System.exit(1);
        }
        TestPersistenceXMLDB testSub = new TestPersistenceXMLDB(glob, ME);
        testSub.setUp();
        testSub.testPersistent();
    }
}

