/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;

public class TestCallback
extends TestCase
implements I_Callback {
    private static String ME = "TestCallback";
    private final Global glob;
    private final LogChannel log;
    private String name;
    private String passwd = "secret";
    private int numReceived = 0;
    private boolean isDeadMessage = false;
    private String subscribeDeadMessageOid = null;
    private I_XmlBlasterAccess conAdmin = null;
    private String publishOid = null;
    private boolean isSocket = false;

    public TestCallback(Global glob, String testName, String name) {
        super(testName);
        this.glob = glob;
        this.log = glob.getLog("test");
        this.name = name;
    }

    protected void setUp() {
        String driverType = this.glob.getProperty().get("client.protocol", "dummy");
        if (driverType.equalsIgnoreCase("SOCKET")) {
            this.isSocket = true;
        }
        if (this.isSocket) {
            this.log.warn(ME, "callback test ignored for driverType=" + driverType + " as callback server uses same socket as invoce channel");
            return;
        }
        try {
            Global globAdmin = this.glob.getClone(null);
            this.conAdmin = globAdmin.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(globAdmin, "admin", this.passwd);
            this.conAdmin.connect(qos, this);
            this.subscribeDeadMessageOid = this.conAdmin.subscribe("<key oid='__sys__deadMessage'/>", null).getSubscriptionId();
            this.log.info(ME, "Success: Subscribe on " + this.subscribeDeadMessageOid + " done");
        }
        catch (Exception e) {
            this.log.error(ME, e.toString());
            Assert.assertTrue(e.toString(), false);
        }
    }

    protected void tearDown() {
        if (this.isSocket) {
            return;
        }
        try {
            if (this.conAdmin != null) {
                EraseReturnQos[] strArr = this.conAdmin.erase("<key oid='" + this.publishOid + "'/>", null);
                if (strArr.length != 1) {
                    this.log.error(ME, "ERROR: Erased " + strArr.length + " messages");
                }
                this.conAdmin.disconnect(null);
            }
        }
        catch (Exception e) {
            this.log.error(ME, e.toString());
            e.printStackTrace();
            Assert.assertTrue(e.toString(), false);
        }
    }

    public void testCallbackFailure() {
        if (this.isSocket) {
            return;
        }
        this.log.info(ME, "testCallbackFailure() ...");
        try {
            this.log.info(ME, "Connecting ...");
            Global globSub = this.glob.getClone(null);
            I_XmlBlasterAccess con = globSub.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(globSub, this.name, this.passwd);
            con.connect(qos, this);
            try {
                con.getCbServer().shutdown();
            }
            catch (Throwable e) {
                this.log.error(ME, "testCallbackFailure: " + e.toString());
                Assert.fail(e.toString());
            }
            String subscribeOid = con.subscribe("<key oid='testCallbackMsg'/>", null).getSubscriptionId();
            this.log.info(ME, "Success: Subscribe on " + subscribeOid + " done");
            MsgUnit msgUnit = new MsgUnit("<key oid='testCallbackMsg'/>", "Bla".getBytes(), null);
            this.publishOid = con.publish(msgUnit).getKeyOid();
            this.log.info(ME, "Success: Publishing done, returned oid=" + this.publishOid);
            this.waitOnUpdate(2000L, 1);
            Assert.assertTrue("Expected a dead letter", this.isDeadMessage);
            this.isDeadMessage = false;
            try {
                con.subscribe("<key oid='testCallbackMsg'/>", null);
                Assert.assertTrue("Session should be destroyed by xmlBlaster", false);
            }
            catch (Exception e2) {
                this.log.info(ME, "SUCCESS: The session was destroyed by xmlBlaster");
            }
        }
        catch (Exception e) {
            this.log.error(ME, e.toString());
            Assert.assertTrue(e.toString(), false);
        }
        this.log.info(ME, "Success in testCallbackFailure()");
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.log.info(ME, "Receiving update of a message " + updateKey.getOid());
        ++this.numReceived;
        this.isDeadMessage = updateKey.isDeadMessage();
        return "";
    }

    private void waitOnUpdate(long timeout, int numWait) {
        long pollingInterval = 50L;
        if (timeout < 50L) {
            pollingInterval = timeout / 10L;
        }
        long sum = 0L;
        while (this.numReceived < numWait) {
            try {
                Thread.currentThread();
                Thread.sleep(pollingInterval);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            Assert.assertTrue("Timeout of " + timeout + " occurred without update", (sum += pollingInterval) <= timeout);
        }
        try {
            Thread.currentThread();
            Thread.sleep(timeout);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assert.assertEquals("Wrong number of messages arrived", numWait, this.numReceived);
        this.numReceived = 0;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "Tim";
        suite.addTest(new TestCallback(new Global(), "testCallbackFailure", "Tim"));
        return suite;
    }

    public static void main(String[] args) {
        TestCallback testSub = new TestCallback(new Global(args), "TestCallback", "Tim");
        testSub.setUp();
        testSub.testCallbackFailure();
        testSub.tearDown();
    }
}

