/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.DisconnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.test.MsgInterceptor;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public class TestCallbackConfig
extends TestCase {
    private static String ME = "TestCallbackConfig";
    private final Global glob;
    private final LogChannel log;
    private String name;
    private String passwd = "secret";
    private I_XmlBlasterAccess con = null;
    private String publishOid = null;
    private String cbSessionId = "topSecret";
    private MsgInterceptor updateInterceptor;

    public TestCallbackConfig(Global glob, String testName, String name) {
        super(testName);
        this.glob = glob;
        this.log = this.glob.getLog("test");
        this.name = name;
    }

    protected void setUp() {
        Util.resetPorts();
        Util.resetPorts(this.glob);
        try {
            this.con = this.glob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(null, "admin", this.passwd);
            CallbackAddress cbProps = new CallbackAddress(new Global());
            cbProps.setCollectTime(0L);
            cbProps.setSecretSessionId(this.cbSessionId);
            cbProps.setPingInterval(10000L);
            cbProps.setRetries(1);
            cbProps.setDelay(1000L);
            cbProps.setPtpAllowed(true);
            qos.addCallbackAddress(cbProps);
            this.updateInterceptor = new MsgInterceptor(this.glob, this.log, null);
            this.con.connect(qos, this.updateInterceptor);
        }
        catch (Exception e) {
            this.log.error(ME, e.toString() + " \n" + this.glob.getProperty().toXml() + " GLOBAL.INSTANCE:\n" + Global.instance().getProperty().toXml());
            e.printStackTrace();
            Assert.assertTrue(e.toString(), false);
        }
        this.updateInterceptor.clear();
    }

    protected void tearDown() {
        try {
            if (this.con != null) {
                EraseReturnQos[] strArr = this.con.erase("<key oid='" + this.publishOid + "'/>", null);
                if (strArr.length != 1) {
                    this.log.error(ME, "ERROR: Erased " + strArr.length + " messages");
                }
                this.con.disconnect(new DisconnectQos(this.glob));
            }
        }
        catch (Exception e) {
            this.log.error(ME, e.toString());
            Assert.assertTrue(e.toString(), false);
        }
    }

    public void testCbSessionId() {
        this.log.info(ME, "testCbSessionId() ...");
        try {
            this.con.subscribe("<key oid='testCallbackMsg'/>", null);
            this.publishOid = this.con.publish(new MsgUnit("<key oid='testCallbackMsg'/>", "Bla".getBytes(), null)).getKeyOid();
            this.log.info(ME, "Success: Publishing done, returned oid=" + this.publishOid);
            Assert.assertEquals("returned oid", "testCallbackMsg", this.publishOid);
            Assert.assertEquals("numReceived after publishing", 1, this.updateInterceptor.waitOnUpdate(2000L, this.publishOid, "OK"));
            Assert.assertEquals("", 1, this.updateInterceptor.getMsgs().length);
            Assert.assertEquals("", this.cbSessionId, this.updateInterceptor.getMsgs()[0].getCbSessionId());
        }
        catch (Exception e) {
            this.log.error(ME, e.toString());
            Assert.assertTrue(e.toString(), false);
        }
        this.log.info(ME, "Success in testCbSessionId()");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "Tim";
        suite.addTest(new TestCallbackConfig(new Global(), "testCbSessionId", "Tim"));
        return suite;
    }

    public static void main(String[] args) {
        TestCallbackConfig testSub = new TestCallbackConfig(new Global(args), "TestCallbackConfig", "Tim");
        testSub.setUp();
        testSub.testCbSessionId();
        testSub.tearDown();
    }
}

