/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import java.util.Map;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.DisconnectQos;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.UnSubscribeQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.ClientProperty;
import org.xmlBlaster.util.qos.ConnectQosData;
import org.xmlBlaster.util.qos.ConnectQosSaxFactory;
import org.xmlBlaster.util.qos.DisconnectQosData;
import org.xmlBlaster.util.qos.DisconnectQosSaxFactory;
import org.xmlBlaster.util.qos.MsgQosData;
import org.xmlBlaster.util.qos.MsgQosSaxFactory;
import org.xmlBlaster.util.qos.QueryQosData;
import org.xmlBlaster.util.qos.QueryQosSaxFactory;

public class TestClientProperty
extends TestCase
implements I_Callback {
    private static String ME = "TestClientProperty";
    private final Global glob;
    private final LogChannel log;
    private boolean messageArrived = false;
    private I_XmlBlasterAccess senderConnection;

    public TestClientProperty(Global glob, String name) {
        super(name);
        this.glob = glob;
        this.log = this.glob.getLog("test");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private void checkValues(Map map) {
        Assert.assertEquals("", 3, map.size());
        Assert.assertEquals("", "oneValue", ((ClientProperty)map.get("oneKey")).getStringValue());
        Assert.assertEquals("", "twoValue", ((ClientProperty)map.get("twoKey")).getStringValue());
        Assert.assertEquals("", 55, ((ClientProperty)map.get("threeKey")).getIntValue());
    }

    public void testConnectQos() {
        if (this.log.TRACE) {
            this.log.trace(ME, "TestConnectQos");
        }
        ConnectQos qos = new ConnectQos(this.glob);
        qos.addClientProperty("oneKey", "oneValue");
        qos.addClientProperty("twoKey", "twoValue");
        qos.addClientProperty("threeKey", new Integer(55));
        String literal = qos.toXml();
        ConnectQosSaxFactory factory = new ConnectQosSaxFactory(this.glob);
        try {
            ConnectQosData data = factory.readObject(literal);
            this.checkValues(data.getClientProperties());
        }
        catch (XmlBlasterException ex) {
            Assert.assertTrue("Exeption occured : " + ex.getMessage(), false);
        }
    }

    public void testDisconnectQos() {
        if (this.log.TRACE) {
            this.log.trace(ME, "TestDisconnectQos");
        }
        DisconnectQos qos = new DisconnectQos(this.glob);
        qos.addClientProperty("oneKey", "oneValue");
        qos.addClientProperty("twoKey", "twoValue");
        qos.addClientProperty("threeKey", new Integer(55));
        String literal = qos.toXml();
        DisconnectQosSaxFactory factory = new DisconnectQosSaxFactory(this.glob);
        try {
            DisconnectQosData data = factory.readObject(literal);
            this.checkValues(data.getClientProperties());
        }
        catch (XmlBlasterException ex) {
            Assert.assertTrue("Exeption occured : " + ex.getMessage(), false);
        }
    }

    public void testPublishQos() {
        if (this.log.TRACE) {
            this.log.trace(ME, "TestPublishQos");
        }
        PublishQos qos = new PublishQos(this.glob);
        qos.addClientProperty("oneKey", "oneValue");
        qos.addClientProperty("twoKey", "twoValue");
        qos.addClientProperty("threeKey", new Integer(55));
        String literal = qos.toXml();
        MsgQosSaxFactory factory = new MsgQosSaxFactory(this.glob);
        try {
            MsgQosData data = factory.readObject(literal);
            this.checkValues(data.getClientProperties());
        }
        catch (XmlBlasterException ex) {
            Assert.assertTrue("Exeption occured : " + ex.getMessage(), false);
        }
    }

    public void testSubscribeQos() {
        if (this.log.TRACE) {
            this.log.trace(ME, "TestSubscribeQos");
        }
        SubscribeQos qos = new SubscribeQos(this.glob);
        qos.addClientProperty("oneKey", "oneValue");
        qos.addClientProperty("twoKey", "twoValue");
        qos.addClientProperty("threeKey", new Integer(55));
        String literal = qos.toXml();
        QueryQosSaxFactory factory = new QueryQosSaxFactory(this.glob);
        try {
            QueryQosData data = factory.readObject(literal);
            this.checkValues(data.getClientProperties());
        }
        catch (XmlBlasterException ex) {
            Assert.assertTrue("Exeption occured : " + ex.getMessage(), false);
        }
    }

    public void testUnSubscribeQos() {
        if (this.log.TRACE) {
            this.log.trace(ME, "TestUnSubscribeQos");
        }
        UnSubscribeQos qos = new UnSubscribeQos(this.glob);
        qos.addClientProperty("oneKey", "oneValue");
        qos.addClientProperty("twoKey", "twoValue");
        qos.addClientProperty("threeKey", new Integer(55));
        String literal = qos.toXml();
        ConnectQosSaxFactory factory = new ConnectQosSaxFactory(this.glob);
        try {
            ConnectQosData data = factory.readObject(literal);
            this.checkValues(data.getClientProperties());
        }
        catch (XmlBlasterException ex) {
            Assert.assertTrue("Exeption occured : " + ex.getMessage(), false);
        }
    }

    public void testGetQos() {
        if (this.log.TRACE) {
            this.log.trace(ME, "TestGetQos");
        }
        ConnectQos qos = new ConnectQos(this.glob);
        qos.addClientProperty("oneKey", "oneValue");
        qos.addClientProperty("twoKey", "twoValue");
        qos.addClientProperty("threeKey", new Integer(55));
        String literal = qos.toXml();
        QueryQosSaxFactory factory = new QueryQosSaxFactory(this.glob);
        try {
            QueryQosData data = factory.readObject(literal);
            this.checkValues(data.getClientProperties());
        }
        catch (XmlBlasterException ex) {
            Assert.assertTrue("Exeption occured : " + ex.getMessage(), false);
        }
    }

    public void testEraseQos() {
        if (this.log.TRACE) {
            this.log.trace(ME, "TestEraseQos");
        }
        EraseQos qos = new EraseQos(this.glob);
        qos.addClientProperty("oneKey", "oneValue");
        qos.addClientProperty("twoKey", "twoValue");
        qos.addClientProperty("threeKey", new Integer(55));
        String literal = qos.toXml();
        QueryQosSaxFactory factory = new QueryQosSaxFactory(this.glob);
        try {
            QueryQosData data = factory.readObject(literal);
            this.checkValues(data.getClientProperties());
        }
        catch (XmlBlasterException ex) {
            Assert.assertTrue("Exeption occured : " + ex.getMessage(), false);
        }
    }

    public void testUpdateQos() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Testing the update qos ...");
        }
        try {
            this.senderConnection = this.glob.getXmlBlasterAccess();
            String passwd = "secret";
            ConnectQos connQos = new ConnectQos(this.glob, "clientProperty", passwd);
            if (this.log.TRACE) {
                this.log.trace(ME, "the connect qos is: " + connQos.toXml());
            }
            this.senderConnection.connect(connQos, this);
            PublishKey key = new PublishKey(this.glob, "clientProp");
            PublishQos qos = new PublishQos(this.glob);
            qos.addClientProperty("oneKey", "oneValue");
            qos.addClientProperty("twoKey", "twoValue");
            qos.addClientProperty("threeKey", new Integer(55));
            MsgUnit msg = new MsgUnit(key, "message".getBytes(), qos);
            this.senderConnection.publish(msg);
            this.senderConnection.subscribe(new SubscribeKey(this.glob, "clientProp"), new SubscribeQos(this.glob));
            this.waitOnUpdate(10000L);
            this.senderConnection.erase(new EraseKey(this.glob, "clientProperty"), new EraseQos(this.glob));
            this.senderConnection.disconnect(new DisconnectQos(this.glob));
        }
        catch (Exception e) {
            this.log.error(ME, "Login failed: " + e.toString());
            e.printStackTrace();
            Assert.assertTrue("Login failed: " + e.toString(), false);
        }
    }

    public String update(String cbSessionId_, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.log.info(ME, "Receiving update of message oid=" + updateKey.getOid() + "...");
        if (updateQos.isErased()) {
            return "";
        }
        Assert.assertEquals("Wrong sender", "clientProperty", updateQos.getSender().getLoginName());
        Assert.assertEquals("Wrong oid of message returned", "clientProp", updateKey.getOid());
        Map map = updateQos.getData().getClientProperties();
        this.checkValues(map);
        this.messageArrived = true;
        return "";
    }

    private void waitOnUpdate(long timeout) {
        long pollingInterval = 50L;
        if (timeout < 50L) {
            pollingInterval = timeout / 10L;
        }
        long sum = 0L;
        while (!this.messageArrived) {
            try {
                Thread.sleep(pollingInterval);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            if ((sum += pollingInterval) <= timeout) continue;
            this.log.warn(ME, "Timeout of " + timeout + " occurred");
            break;
        }
        Assert.assertTrue("The message never arrived", this.messageArrived);
        this.messageArrived = false;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "Tim";
        suite.addTest(new TestClientProperty(new Global(), "testConnectQos"));
        suite.addTest(new TestClientProperty(new Global(), "testDisconnectQos"));
        suite.addTest(new TestClientProperty(new Global(), "testPublishQos"));
        suite.addTest(new TestClientProperty(new Global(), "testSubscribeQos"));
        suite.addTest(new TestClientProperty(new Global(), "testUnSubscribeQos"));
        suite.addTest(new TestClientProperty(new Global(), "testGetQos"));
        suite.addTest(new TestClientProperty(new Global(), "testEraseQos"));
        suite.addTest(new TestClientProperty(new Global(), "testUpdateQos"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.err.println(ME + ": Init failed");
            System.exit(1);
        }
        TestClientProperty test = new TestClientProperty(glob, "testClientProperty");
        test.setUp();
        test.testConnectQos();
        test.tearDown();
        test.setUp();
        test.testDisconnectQos();
        test.tearDown();
        test.setUp();
        test.testPublishQos();
        test.tearDown();
        test.setUp();
        test.testSubscribeQos();
        test.tearDown();
        test.setUp();
        test.testUnSubscribeQos();
        test.tearDown();
        test.setUp();
        test.testGetQos();
        test.tearDown();
        test.setUp();
        test.testEraseQos();
        test.tearDown();
        test.setUp();
        test.testUpdateQos();
        test.tearDown();
    }
}

