/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import java.io.IOException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.jutils.runtime.ThreadLister;
import org.omg.CORBA.ORB;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.protocol.I_CallbackExtended;
import org.xmlBlaster.client.protocol.I_CallbackServer;
import org.xmlBlaster.client.protocol.corba.CorbaCallbackServer;
import org.xmlBlaster.client.protocol.corba.CorbaConnection;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.protocol.corba.OrbInstanceFactory;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public class TestCorbaThreads
extends TestCase
implements I_CallbackExtended {
    private static final String ME = "TestCorbaThreads";
    private Global glob;
    private final LogChannel log;
    private EmbeddedXmlBlaster serverThread;
    private final String loginName = "TestCorbaThreads";
    private String publishOid = "";
    private CorbaConnection corbaConnection = null;
    private I_CallbackServer cbServer = null;
    private String corbaContent;
    private int numReceived = 0;

    public TestCorbaThreads(Global glob, String testName) {
        super(testName);
        this.glob = glob;
        this.log = glob.getLog("test");
    }

    public void testJacORB() {
        Util.gc(2);
        int threadsBefore = ThreadLister.countThreads();
        int ii = 0;
        while (ii < 20) {
            System.out.println("Hit a key for ORB #" + ii + "/20");
            try {
                System.in.read();
            }
            catch (IOException e) {
                // empty catch block
            }
            ORB orb = OrbInstanceFactory.createOrbInstance(this.glob, new String[0], null, new CallbackAddress(this.glob));
            try {
                POA rootPOA = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
                rootPOA.the_POAManager().activate();
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.out.println("ERROR: " + e.toString());
            }
            orb.shutdown(true);
            ++ii;
        }
        Util.gc(2);
        Assert.assertEquals("JacORB has a thread leak", threadsBefore, ThreadLister.countThreads());
    }

    protected void setUp() {
        this.glob.init(Util.getOtherServerPorts(8116));
        String[] args = new String[]{"-ProtocolPlugin[IOR][1.0]", "org.xmlBlaster.protocol.corba.CorbaDriver", "-CbProtocolPlugin[IOR][1.0]", "org.xmlBlaster.protocol.corba.CallbackCorbaDriver"};
        this.glob.init(args);
        this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.glob);
        this.log.info(ME, "XmlBlaster is ready for testing on bootstrapPort 8116");
    }

    private void login() {
        try {
            String passwd = "secret";
            this.cbServer = new CorbaCallbackServer();
            CallbackAddress cba = new CallbackAddress(this.glob);
            this.cbServer.initialize(this.glob, ME, cba, this);
            this.corbaConnection = new CorbaConnection();
            this.corbaConnection.init(this.glob, null);
            ConnectQos connectQos = new ConnectQos(this.glob, ME, passwd);
            this.corbaConnection.connect(connectQos.toXml());
        }
        catch (Exception e) {
            this.log.error(ME, e.toString());
            e.printStackTrace();
        }
    }

    protected void tearDown() {
        EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
        this.serverThread = null;
        Util.resetPorts(this.glob);
        this.log.info(ME, "Ports reset to default: " + this.glob.getProperty().toXml());
    }

    private void logout() {
        if (this.corbaConnection != null) {
            try {
                Thread.currentThread();
                Thread.sleep(200L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            this.corbaConnection.disconnect(null);
            this.corbaConnection = null;
            System.gc();
        }
        if (this.cbServer != null) {
            try {
                this.cbServer.shutdown();
            }
            catch (Exception e) {
                this.log.error(ME, "shutdownCb(): " + e.toString());
            }
            this.cbServer = null;
            System.gc();
        }
    }

    public void testThread() {
        this.log.info(ME, "Testing thread consume on multiple login/logouts, used threads before any login=" + ThreadLister.countThreads());
        ThreadLister.listAllThreads(System.out);
        int threadsBefore = 0;
        int ii = 0;
        while (ii < 5) {
            this.log.info(ME, "Testing login/logout no = " + ii);
            this.login();
            this.logout();
            if (ii == 0) {
                Util.gc(2);
                threadsBefore = ThreadLister.countThreads();
                this.log.info(ME, "Testing thread consume on multiple login/logouts, used threads after first login=" + threadsBefore);
                ThreadLister.listAllThreads(System.out);
            }
            ++ii;
        }
        Util.gc(2);
        ThreadLister.listAllThreads(System.out);
        int threadsAfter = ThreadLister.countThreads();
        this.log.info(ME, "Currently used threads after 5 login/logout=" + threadsAfter);
        Assert.assertTrue("We have a thread leak, threadsBefore=" + threadsBefore + " threadsAfter=" + threadsAfter, threadsAfter <= threadsBefore);
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        if (this.log.CALL) {
            this.log.call(ME, "Receiving update of a message ...");
        }
        return "";
    }

    public String update(String cbSessionId, String updateKeyLiteral, byte[] content, String updateQosLiteral) {
        if (this.log.CALL) {
            this.log.call(ME, "Receiving update of a message ...");
        }
        return "";
    }

    public String[] update(String cbSessionId, MsgUnitRaw[] msgUnitArr) {
        if (this.log.CALL) {
            this.log.call(ME, "Receiving update of a message ...");
        }
        String[] retArr = new String[msgUnitArr.length];
        int ii = 0;
        while (ii < retArr.length) {
            retArr[ii] = "";
            ++ii;
        }
        return retArr;
    }

    public void updateOneway(String cbSessionId, String updateKeyLiteral, byte[] content, String updateQosLiteral) {
        if (this.log.CALL) {
            this.log.call(ME, "Receiving update of a message ...");
        }
    }

    public void updateOneway(String cbSessionId, MsgUnitRaw[] msgUnitArr) {
        if (this.log.CALL) {
            this.log.call(ME, "Receiving update of a message ...");
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new TestCorbaThreads(new Global(), "testThread"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) < 0) {
            System.out.println("Wrong params");
            return;
        }
        TestCorbaThreads testSub = new TestCorbaThreads(glob, ME);
        testSub.setUp();
        testSub.testJacORB();
        testSub.testThread();
        testSub.tearDown();
    }
}

