/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.jutils.runtime.ThreadLister;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;

public class TestEmbeddedXmlBlaster
extends TestCase {
    private static final String ME = "TestEmbeddedXmlBlaster";
    private final Global glob;
    private final LogChannel log;
    private I_XmlBlasterAccess con = null;
    private String name;
    private String passwd = "secret";
    private EmbeddedXmlBlaster serverThread;
    private int serverPort = 7615;

    public TestEmbeddedXmlBlaster(String testName) {
        this(Global.instance(), testName);
    }

    public TestEmbeddedXmlBlaster(Global glob, String testName) {
        super(testName);
        this.glob = glob;
        this.log = glob.getLog(null);
        this.name = testName;
    }

    protected void setUp() {
    }

    protected void tearDown() {
        Util.resetPorts();
    }

    public void testThreadFree() {
        this.log.info(ME, "######## Start testThreadFree()");
        int threadsBefore = ThreadLister.countThreads();
        this.log.info(ME, "Testing thread consume before xmlBlaster startup=" + threadsBefore);
        ThreadLister.listAllThreads(System.out);
        String[] args = new String[]{"-bootstrapPort", "" + this.serverPort, "-plugin/socket/port", "" + (this.serverPort - 1), "-plugin/rmi/registryPort", "" + (this.serverPort - 2), "-plugin/xmlrpc/port", "" + (this.serverPort - 3), "-ProtocolPlugin[IOR][1.0]", "org.xmlBlaster.protocol.corba.CorbaDriver", "-CbProtocolPlugin[IOR][1.0]", "org.xmlBlaster.protocol.corba.CallbackCorbaDriver"};
        this.glob.init(args);
        this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.glob);
        this.log.info(ME, "XmlBlaster is ready for testing JDBC access");
        try {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
        this.serverThread = null;
        ThreadLister.listAllThreads(System.out);
        int threadsAfter = ThreadLister.countThreads();
        this.log.info(ME, "Currently used threads after server startup/shutdown" + threadsAfter);
        int allow = threadsBefore + 1;
        Assert.assertTrue("We have a thread leak, threadsBefore=" + threadsBefore + " threadsAfter=" + threadsAfter, threadsAfter <= allow);
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.out.println("TestEmbeddedXmlBlaster: Init failed");
            System.exit(1);
        }
        TestEmbeddedXmlBlaster test = new TestEmbeddedXmlBlaster(glob, ME);
        test.setUp();
        test.testThreadFree();
        test.tearDown();
    }
}

