/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class TestErase
extends TestCase
implements I_Callback {
    private static String ME = "TestErase";
    private final Global glob;
    private final LogChannel log;
    private String subscribeId;
    private String oidExact = "HelloMessage";
    private String publishOid = null;
    private I_XmlBlasterAccess con;
    private String senderContent;
    private boolean expectingErase = false;
    private int numReceived = 0;
    private final String contentMime = "text/xml";

    public TestErase(Global glob, String testName) {
        super(testName);
        this.glob = glob;
        this.log = glob.getLog(null);
    }

    protected void setUp() {
        this.numReceived = 0;
        this.expectingErase = false;
    }

    protected void tearDown() {
        if (this.con != null) {
            if (this.publishOid != null) {
                String xmlKey = "<key oid='" + this.publishOid + "' queryType='EXACT'/>";
                try {
                    EraseReturnQos[] arr = this.con.erase(xmlKey, "<qos/>");
                }
                catch (XmlBlasterException e) {
                    Assert.fail("Erase XmlBlasterException: " + e.getMessage());
                }
            }
            this.con.disconnect(null);
            this.con = null;
        }
    }

    private void subscribe() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Subscribing ...");
        }
        String xmlKey = "<key oid='" + this.oidExact + "' queryType='EXACT'/>";
        String qos = "<qos/>";
        this.numReceived = 0;
        this.subscribeId = null;
        try {
            this.subscribeId = this.con.subscribe(xmlKey, qos).getSubscriptionId();
            Assert.assertTrue("returned null subscribeId", this.subscribeId != null);
            Assert.assertTrue("returned subscribeId is empty", 0 != this.subscribeId.length());
            this.log.info(ME, "Success: Subscribe on " + this.subscribeId + " done");
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    private void publish() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Publishing a message ...");
        }
        this.numReceived = 0;
        String xmlKey = "<key oid='" + this.oidExact + "' contentMime='" + "text/xml" + "'/>";
        this.senderContent = "Yeahh, i'm the new content";
        try {
            MsgUnit msgUnit = new MsgUnit(xmlKey, this.senderContent.getBytes(), "<qos/>");
            this.publishOid = this.con.publish(msgUnit).getKeyOid();
            this.log.info(ME, "Success: Publishing done, returned oid=" + this.publishOid);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
        Assert.assertTrue("returned publishOid == null", this.publishOid != null);
        Assert.assertTrue("returned publishOid", 0 != this.publishOid.length());
        Assert.assertEquals("returned publishOid is wrong", this.oidExact, this.publishOid);
    }

    private void unSubscribe() {
        if (this.log.TRACE) {
            this.log.trace(ME, "unSubscribing ...");
        }
        String qos = "<qos/>";
        this.numReceived = 0;
        try {
            this.con.unSubscribe("<key oid='" + this.subscribeId + "'/>", qos);
            this.log.info(ME, "Success: unSubscribe on " + this.subscribeId + " done");
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("unSubscribe - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    private void erase() {
        if (this.publishOid != null) {
            String xmlKey = "<key oid='" + this.publishOid + "' queryType='EXACT'/>";
            try {
                EraseReturnQos[] arr = this.con.erase(xmlKey, "<qos/>");
                Assert.assertEquals("Erase", 1, arr.length);
            }
            catch (XmlBlasterException e) {
                Assert.fail("Erase XmlBlasterException: " + e.getMessage());
            }
        }
    }

    private void connect() {
        try {
            this.con = this.glob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(this.glob);
            this.con.connect(qos, this);
        }
        catch (Exception e) {
            this.log.error(ME, "Login failed: " + e.toString());
            e.printStackTrace();
            Assert.assertTrue("Login failed: " + e.toString(), false);
        }
    }

    public void testEraseEvent() {
        this.log.info(ME, "testEraseEvent ...");
        this.numReceived = 0;
        this.connect();
        this.subscribe();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assert.assertEquals("numReceived after subscribe", 0, this.numReceived);
        this.numReceived = 0;
        this.publish();
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assert.assertEquals("numReceived after publishing", 1, this.numReceived);
        this.numReceived = 0;
        this.expectingErase = true;
        this.erase();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals("numReceived after erase", 1, this.numReceived);
        this.log.info(ME, "testEraseEvent SUCCESS");
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        if (this.log.CALL) {
            this.log.call(ME, "Receiving update of a message ...");
        }
        ++this.numReceived;
        if (updateQos.isErased()) {
            return "";
        }
        if (this.expectingErase) {
            Assert.assertEquals("Wrong update state", "ERASED", updateQos.getState());
            Assert.assertTrue("Wrong update state", updateQos.isErased());
        } else {
            Assert.assertEquals("Wrong update state", "OK", updateQos.getState());
            Assert.assertTrue("Wrong update state", updateQos.isOk());
        }
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assert.assertEquals("Wrong oid of message returned", this.publishOid, updateKey.getOid());
        Assert.assertEquals("Message content is corrupted", new String(this.senderContent), new String(content));
        Assert.assertEquals("Message contentMime is corrupted", "text/xml", updateKey.getContentMime());
        return "";
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new TestErase(new Global(), "testEraseEvent"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.err.println("Init failed");
            System.exit(1);
        }
        TestErase testSub = new TestErase(glob, "TestErase");
        testSub.setUp();
        testSub.testEraseEvent();
        testSub.tearDown();
    }
}

