/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.GetReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class TestGet
extends TestCase {
    private static String ME = "TestGet";
    private final Global glob;
    private final LogChannel log;
    private String publishOid = "TestGet";
    private I_XmlBlasterAccess connection;
    private String loginName;
    private String senderContent = "A test message";
    private int numReceived = 0;
    private final String contentMime = "text/xml";
    private final String contentMimeExtended = "1.0";

    public TestGet(Global glob, String testName, String loginName) {
        super(testName);
        this.glob = glob;
        this.log = glob.getLog("test");
        this.loginName = loginName;
    }

    protected void setUp() {
        try {
            this.connection = this.glob.getXmlBlasterAccess();
            String passwd = "secret";
            ConnectQos qos = new ConnectQos(this.glob, this.loginName, passwd);
            this.connection.connect(qos, null);
        }
        catch (Exception e) {
            this.log.error(ME, e.toString());
            e.printStackTrace();
        }
    }

    protected void tearDown() {
        this.connection.disconnect(null);
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.log.info(ME, "Success, logged out");
    }

    public void testGet() {
        MsgUnit[] msgArr;
        String qos;
        String xmlKey;
        if (this.log.TRACE) {
            this.log.trace(ME, "1. Get a not existing message ...");
        }
        try {
            xmlKey = "<key oid='" + this.publishOid + "' queryType='EXACT'></key>";
            qos = "<qos></qos>";
            msgArr = this.connection.get(xmlKey, qos);
            if (msgArr.length > 0) {
                this.log.error(ME, "Received " + msgArr.length + " unexpected messages");
                int i = 0;
                while (i < msgArr.length) {
                    this.log.error(ME, "Wrong message is " + msgArr[i].toXml());
                    ++i;
                }
                Assert.assertTrue("get of not existing message is not possible", false);
            } else {
                this.log.info(ME, "Success, got zero messages when trying to get unknown message");
            }
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "get of not existing message should not throw an exception");
            Assert.assertTrue("get of not existing message should not throw an exception", false);
        }
        if (this.log.TRACE) {
            this.log.trace(ME, "2. Publish a message ...");
        }
        try {
            xmlKey = "<key oid='" + this.publishOid + "' contentMime='text/plain'>\n</key>";
            PublishQos qosWrapper = new PublishQos(this.glob);
            MsgUnit msgUnit = new MsgUnit(xmlKey, this.senderContent.getBytes(), qosWrapper.toXml());
            this.connection.publish(msgUnit);
            this.log.info(ME, "Success, published a message");
        }
        catch (XmlBlasterException e) {
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
        if (this.log.TRACE) {
            this.log.trace(ME, "3. Get an existing message ...");
        }
        try {
            xmlKey = "<key oid='" + this.publishOid + "' queryType='EXACT'></key>";
            qos = "<qos></qos>";
            msgArr = this.connection.get(xmlKey, qos);
            Assert.assertEquals("Got wrong number of messages", 1, msgArr.length);
            this.log.info(ME, "Success, got the message '" + msgArr[0].getKey() + "'");
            if (this.log.DUMP) {
                this.log.dump(ME, msgArr[0].toXml());
            }
            GetReturnQos getQos = new GetReturnQos(this.glob, msgArr[0].getQos());
            Assert.assertEquals("Sender is corrupted", this.loginName, getQos.getSender().getLoginName());
            this.log.info(ME, "Get success from sender " + getQos.getSender());
            Assert.assertEquals("Corrupted content", this.senderContent, new String(msgArr[0].getContent()));
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "XmlBlasterException for trying to get a message: " + e.getMessage());
            Assert.assertTrue("Couldn't get() an existing message", false);
        }
        xmlKey = "<key oid='" + this.publishOid + "' queryType='EXACT'>\n" + "</key>";
        qos = "<qos></qos>";
        try {
            EraseReturnQos[] arr = this.connection.erase(xmlKey, qos);
            if (arr.length != 1) {
                this.log.error(ME, "Erased " + arr.length + " messages:");
                Assert.fail("Message " + this.publishOid + " was not erased");
            }
            this.log.info(ME, "Success, erased a message");
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "XmlBlasterException: " + e.getMessage());
        }
    }

    public void testGetMany() {
        int num = this.glob.getProperty().get("numTries", 5);
        this.log.info(ME, "Get " + num + " not existing messages ...");
        String xmlKey = "<key oid='NotExistingMessage' queryType='EXACT'></key>";
        String qos = "<qos></qos>";
        int ii = 0;
        while (ii < num) {
            try {
                MsgUnit[] msgArr = this.connection.get(xmlKey, qos);
                if (msgArr.length > 0) {
                    Assert.assertTrue("get() of not existing message is not possible", false);
                }
            }
            catch (XmlBlasterException e) {
                Assert.assertTrue("get() of not existing message should not throw an Exception: " + e.toString(), false);
            }
            ++ii;
        }
        this.log.info(ME, "Get " + num + " not existing messages done");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "Tim";
        Global glob = new Global();
        suite.addTest(new TestGet(glob, "testGet", loginName));
        suite.addTest(new TestGet(glob, "testGetMany", loginName));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.out.println(ME + " Init failed");
            System.exit(1);
        }
        TestGet testSub = new TestGet(glob, "TestGet", "Tim");
        testSub.setUp();
        testSub.testGet();
        testSub.testGetMany();
        testSub.tearDown();
    }
}

