/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.protocol.I_XmlBlaster;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UnSubscribeReturnQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.recorder.ram.RamRecorder;

public class TestInvocationRecorder
extends TestCase
implements I_XmlBlaster {
    private static String ME = "TestInvocationRecorder";
    private final Global glob;
    private final LogChannel log;
    private RamRecorder recorder = null;
    private String subscribeOid;
    private String publishOid = "";
    private int numSubscribe;
    private int numUnSubscribe;
    private int numPublish;
    private int numPublishArr;
    private int numErase;
    private int numGet;
    private int numUpdate;
    private MsgUnit[] dummyMArr = new MsgUnit[0];
    private String[] dummySArr = new String[0];
    private String dummyS = "";
    private String xmlKey_get = "<key oid='HelloGet' queryType='EXACT'>\n</key>";
    private String qos_get = "<qos><get /></qos>";
    private String xmlKey_subscribe = "<key oid='HelloSubscribe' queryType='EXACT'>\n</key>";
    private String qos_subscribe = "<qos><subscribe /></qos>";

    public TestInvocationRecorder(Global glob, String testName) {
        super(testName);
        this.glob = glob;
        this.log = this.glob.getLog("test");
    }

    protected void setUp() {
        this.log.info(ME, "setup test");
        this.numUpdate = 0;
        this.numGet = 0;
        this.numErase = 0;
        this.numPublishArr = 0;
        this.numPublish = 0;
        this.numUnSubscribe = 0;
        this.numSubscribe = 0;
        this.recorder = new RamRecorder();
        this.recorder.initialize(this.glob, null, 1000L, this);
    }

    protected void tearDown() {
        this.log.info(ME, "testing done");
    }

    public void test() {
        String xmlKey = "<key oid='Hello' queryType='XPATH'>\n   //TestInvocationRecorder-AGENT\n</key>";
        String qos = "<qos></qos>";
        String content = "The content";
        String clientName = "Gonzales";
        String xmlAttr = "";
        try {
            MsgUnit msgUnit = new MsgUnit(xmlKey, content.getBytes(), qos);
            MsgUnit[] msgUnitArr = new MsgUnit[]{msgUnit};
            this.recorder.subscribe(this.xmlKey_subscribe, this.qos_subscribe);
            this.recorder.get(this.xmlKey_get, this.qos_get);
            this.recorder.unSubscribe(xmlKey, qos);
            this.recorder.publish(msgUnit);
            this.recorder.publishArr(msgUnitArr);
            this.recorder.erase(xmlKey, qos);
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "problems feeding the recorder: " + e.getMessage());
            Assert.assertTrue("problems feeding the recorder: " + e.getMessage(), false);
        }
        try {
            this.recorder.pullback(0L, 0L, 1.0);
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "problems with recorder.pullback: " + e.getMessage());
            Assert.assertTrue("problems recorder pullback: " + e.getMessage(), false);
        }
        Assert.assertEquals("numSubscribe: ", 1, this.numSubscribe);
        Assert.assertEquals("numUnSubscribe: ", 1, this.numUnSubscribe);
        Assert.assertEquals("numPublish: ", 1, this.numPublish);
        Assert.assertEquals("numPublishArr: ", 1, this.numPublishArr);
        Assert.assertEquals("numErase: ", 1, this.numErase);
        Assert.assertEquals("numGet: ", 1, this.numGet);
    }

    public SubscribeReturnQos subscribe(String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(ME, "subscribe() ...");
        }
        ++this.numSubscribe;
        Assert.assertEquals("subscribe(xmlKey): ", this.xmlKey_subscribe, xmlKey_literal);
        Assert.assertEquals("subscribe(xmlKey): ", this.qos_subscribe, qos_literal);
        return null;
    }

    public UnSubscribeReturnQos[] unSubscribe(String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(ME, "unSubscribe() ...");
        }
        ++this.numUnSubscribe;
        return null;
    }

    public PublishReturnQos publish(MsgUnit msgUnit) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(ME, "publish() ...");
        }
        ++this.numPublish;
        return null;
    }

    public void publishOneway(MsgUnit[] msgUnitArr) {
        if (this.log.CALL) {
            this.log.call(ME, "publishOneway() ...");
        }
        ++this.numPublishArr;
    }

    public PublishReturnQos[] publishArr(MsgUnit[] msgUnitArr) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(ME, "publishArr() ...");
        }
        ++this.numPublishArr;
        return new PublishReturnQos[0];
    }

    public EraseReturnQos[] erase(String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(ME, "erase() ...");
        }
        ++this.numErase;
        return new EraseReturnQos[0];
    }

    public MsgUnit[] get(String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(ME, "get() ...");
        }
        ++this.numGet;
        Assert.assertEquals("get(xmlKey): ", this.xmlKey_get, xmlKey_literal);
        Assert.assertEquals("get(xmlKey): ", this.qos_get, qos_literal);
        return this.dummyMArr;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new TestInvocationRecorder(new Global(), "test"));
        return suite;
    }

    public static void main(String[] args) {
        TestInvocationRecorder testSub = new TestInvocationRecorder(new Global(args), "test");
        testSub.setUp();
        testSub.test();
        testSub.tearDown();
    }
}

