/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class TestPtD
extends TestCase
implements I_Callback {
    private static final String ME = "TestPtD";
    private final Global glob;
    private final LogChannel log;
    private final String senderName = "Manuel";
    private String publishOid = "";
    private I_XmlBlasterAccess senderConnection = null;
    private String senderContent;
    private final String receiverName = "Ulrike";
    private I_XmlBlasterAccess receiverConnection = null;
    private final String receiver2Name = "KGB";
    private I_XmlBlasterAccess receiver2Connection = null;
    private int numReceived = 0;

    public TestPtD(Global glob, String testName) {
        super(testName);
        this.glob = glob;
        this.log = this.glob.getLog("test");
    }

    protected void setUp() {
        try {
            String passwd = "secret";
            Global receiverGlob = this.glob.getClone(null);
            this.receiverConnection = receiverGlob.getXmlBlasterAccess();
            this.receiverConnection.connect(new ConnectQos(receiverGlob, "Ulrike", passwd), this);
            Global receiver2Glob = this.glob.getClone(null);
            this.receiver2Connection = receiver2Glob.getXmlBlasterAccess();
            this.receiver2Connection.connect(new ConnectQos(receiver2Glob, "KGB", passwd), this);
            Global receiver3Glob = this.glob.getClone(null);
            this.senderConnection = receiver3Glob.getXmlBlasterAccess();
            this.senderConnection.connect(new ConnectQos(receiver3Glob, "Manuel", passwd), this);
        }
        catch (Exception e) {
            this.log.error(ME, e.toString());
            e.printStackTrace();
        }
    }

    protected void tearDown() {
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.receiverConnection.disconnect(null);
        this.receiver2Connection.disconnect(null);
        this.senderConnection.disconnect(null);
    }

    public void testPtOneDestination() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Testing point to one destination ...");
        }
        String xmlKey = "<key oid='' contentMime='text/plain'>\n</key>";
        String qos = "<qos>   <destination queryType='EXACT'>Ulrike   </destination></qos>";
        this.senderContent = "Hi Ulrike, i love you, Manuel";
        try {
            MsgUnit msgUnit = new MsgUnit(xmlKey, this.senderContent.getBytes(), qos);
            this.publishOid = this.senderConnection.publish(msgUnit).getKeyOid();
            this.log.info(ME, "Sending done, returned oid=" + this.publishOid);
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "publish() XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
        this.waitOnUpdate(5000L, 1);
        Assert.assertEquals("numReceived after sending", 1, this.numReceived);
        this.numReceived = 0;
    }

    public void testPtManyDestinations() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Testing point to many destinations ...");
        }
        String xmlKey = "<key oid='' contentMime='text/plain'>\n</key>";
        String qos = "<qos>   <destination queryType='EXACT'>Ulrike   </destination>   <destination queryType='EXACT'>KGB   </destination></qos>";
        this.senderContent = "Hi KGB, i know you are listening, Manuel";
        try {
            MsgUnit msgUnit = new MsgUnit(xmlKey, this.senderContent.getBytes(), qos);
            this.publishOid = this.senderConnection.publish(msgUnit).getKeyOid();
            this.log.info(ME, "Sending done, returned oid=" + this.publishOid);
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "publish() XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
        this.waitOnUpdate(5000L, 2);
        Assert.assertEquals("numReceived after sending", 2, this.numReceived);
        this.numReceived = 0;
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        if (this.log.CALL) {
            this.log.call(ME, "Receiving update of a message ...");
        }
        ++this.numReceived;
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assert.assertEquals("Wrong sender", "Manuel", updateQos.getSender().getLoginName());
        Assert.assertEquals("Wrong oid of message returned", this.publishOid, updateKey.getOid());
        Assert.assertEquals("Message content is corrupted", new String(this.senderContent), new String(content));
        return "";
    }

    private void waitOnUpdate(long timeout, int numWait) {
        long pollingInterval = 50L;
        if (timeout < 50L) {
            pollingInterval = timeout / 10L;
        }
        long sum = 0L;
        while (this.numReceived < numWait) {
            try {
                Thread.currentThread();
                Thread.sleep(pollingInterval);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            if ((sum += pollingInterval) <= timeout) continue;
            this.log.warn(ME, "Timeout of " + timeout + " occurred");
            break;
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        Global glob = new Global();
        suite.addTest(new TestPtD(glob, "testPtOneDestination"));
        suite.addTest(new TestPtD(glob, "testPtManyDestinations"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.err.println("TestPtD: Init failed");
            System.exit(1);
        }
        TestPtD testSub = new TestPtD(glob, ME);
        testSub.setUp();
        testSub.testPtOneDestination();
        testSub.tearDown();
    }
}

