/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class TestPtDQueue
extends TestCase
implements I_Callback {
    private static final String ME = "TestPtDQueue";
    private final Global glob;
    private final LogChannel log;
    private final String senderName = "William";
    private String publishOid = "";
    private I_XmlBlasterAccess senderConnection = null;
    private String senderContent;
    private final String receiverName = "Averell";
    private I_XmlBlasterAccess receiverConnection = null;
    private String passwd = "secret";
    private int numReceived = 0;
    private boolean messageArrived = false;

    public TestPtDQueue(Global glob, String testName) {
        super(testName);
        this.glob = glob;
        this.log = this.glob.getLog("test");
    }

    protected void setUp() {
        try {
            this.senderConnection = this.glob.getClone(null).getXmlBlasterAccess();
            this.senderConnection.connect(new ConnectQos(this.senderConnection.getGlobal(), "William", this.passwd), this);
            this.log.info(ME, "Successful login for William");
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, e.toString());
            e.printStackTrace();
            Assert.assertTrue("login - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    protected void tearDown() {
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.receiverConnection.disconnect(null);
        this.senderConnection.disconnect(null);
    }

    public void testPtUnknownDestination() {
        MsgUnit msgUnit;
        this.log.info(ME, "[1] Testing point to a unknown destination with NO forceQueuing set ...");
        String xmlKey = "<key oid='' contentMime='text/plain'/>";
        String qos = "<qos>   <destination queryType='EXACT' forceQueuing='false'>Averell   </destination></qos>";
        this.senderContent = "Hi Averell, who are you? William";
        try {
            msgUnit = new MsgUnit(this.senderConnection.getGlobal(), xmlKey, this.senderContent.getBytes(), qos);
            this.publishOid = this.senderConnection.publish(msgUnit).getKeyOid();
            this.log.error(ME, "Publishing to a not logged in client should throw an exception, forceQueuing is not set");
            Assert.assertTrue("Publishing to a not logged in client should throw an exception, forceQueuing is not set", false);
        }
        catch (XmlBlasterException e) {
            this.log.info(ME, "Exception is correct, client is not logged in: " + e.getMessage());
        }
        this.waitOnUpdate(1000L);
        Assert.assertEquals("numReceived after sending to 'Averell'", 0, this.numReceived);
        this.numReceived = 0;
        this.log.info(ME, "[2] Testing point to a unknown destination with forceQueuing set ...");
        xmlKey = "<key oid='' contentMime='text/plain'>\n</key>";
        qos = "<qos>   <destination queryType='EXACT' forceQueuing='true'>Averell   </destination></qos>";
        this.senderContent = "Hi Averell, who are you? William";
        try {
            msgUnit = new MsgUnit(this.senderConnection.getGlobal(), xmlKey, this.senderContent.getBytes(), qos);
            this.publishOid = this.senderConnection.publish(msgUnit).getKeyOid();
            this.log.info(ME, "Sending done, returned oid=" + this.publishOid);
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "publish() XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
        this.waitOnUpdate(1000L);
        Assert.assertEquals("numReceived after sending to 'Averell'", 0, this.numReceived);
        this.numReceived = 0;
        this.log.info(ME, "[3] Now the receiver 'Averell' logs in and should get the message '" + this.publishOid + "' from the xmlBlaster queue ...");
        try {
            this.receiverConnection = this.glob.getClone(null).getXmlBlasterAccess();
            ConnectQos connectQos = new ConnectQos(this.receiverConnection.getGlobal(), "Averell", this.passwd);
            this.receiverConnection.connect(connectQos, this);
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, e.toString());
            e.printStackTrace();
            Assert.assertTrue("login - XmlBlasterException: " + e.getMessage(), false);
            return;
        }
        this.waitOnUpdate(1000L);
        Assert.assertEquals("numReceived after 'Averell' logged in", 1, this.numReceived);
        this.numReceived = 0;
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.log.info(ME, "Receiving update of a message '" + updateKey.getOid() + "' state=" + updateQos.getState() + " ...");
        ++this.numReceived;
        Assert.assertEquals("Wrong sender", "William", updateQos.getSender().getLoginName());
        Assert.assertEquals("Wrong oid of message returned", this.publishOid, updateKey.getOid());
        Assert.assertEquals("Message content is corrupted", new String(this.senderContent), new String(content));
        this.messageArrived = true;
        return "";
    }

    private void waitOnUpdate(long timeout) {
        long pollingInterval = 50L;
        if (timeout < 50L) {
            pollingInterval = timeout / 10L;
        }
        long sum = 0L;
        while (!this.messageArrived) {
            try {
                Thread.currentThread();
                Thread.sleep(pollingInterval);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            if ((sum += pollingInterval) <= timeout) continue;
            this.log.warn(ME, "Timeout of " + timeout + " occurred");
            break;
        }
        this.messageArrived = false;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new TestPtDQueue(new Global(), "testPtUnknownDestination"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.err.println("TestPtDQueue: Init failed");
            System.exit(1);
        }
        TestPtDQueue testSub = new TestPtDQueue(glob, ME);
        testSub.setUp();
        testSub.testPtUnknownDestination();
        testSub.tearDown();
    }
}

