/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.test.MsgInterceptor;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.qos.HistoryQos;
import org.xmlBlaster.util.qos.TopicProperty;
import org.xmlBlaster.util.qos.address.CallbackAddress;
import org.xmlBlaster.util.qos.address.Destination;

public class TestPtDQueueRedeliver
extends TestCase {
    private static String ME = "TestPtDQueueRedeliver";
    private final Global glob;
    private final LogChannel log;
    private String passwd = "secret";
    private int serverPort = 7615;
    private String oid = "TestPtDQueueRedeliver.Msg";
    private EmbeddedXmlBlaster serverThread = null;
    private String sessionNameRcv = "TestPtDQueueRedeliverReceiver";
    private I_XmlBlasterAccess conRcv;
    private boolean connectedRcv = false;
    private MsgInterceptor updateInterceptorRcv;
    private String sessionNameSnd = "TestPtDQueueRedeliverSender";
    private I_XmlBlasterAccess conSnd;
    private MsgInterceptor updateInterceptorSnd;

    public TestPtDQueueRedeliver() {
        this(new Global(), "TestPtDQueueRedeliver");
    }

    public TestPtDQueueRedeliver(Global glob, String testName) {
        super(testName);
        this.glob = glob;
        this.log = glob.getLog(null);
    }

    protected void setUp() {
        this.glob.init(Util.getOtherServerPorts(this.serverPort));
        this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.glob);
        this.log.info(ME, "XmlBlaster is ready for testing");
    }

    protected void tearDown() {
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.serverThread != null) {
            this.serverThread.stopServer(true);
        }
        Util.resetPorts();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testPersistentPtp() {
        block11: {
            this.log.info(ME, "testPersistentPtp(" + this.sessionNameRcv + ") ...");
            try {
                try {
                    this.log.info(ME, "============ STEP 1: Start publisher");
                    this.conSnd = this.glob.getXmlBlasterAccess();
                    ConnectQos qosPub = new ConnectQos(this.glob);
                    ConnectReturnQos crqPub = this.conSnd.connect(qosPub, null);
                    this.log.info(ME, "Connect success as " + crqPub.getSessionName());
                    int numPub = 8;
                    this.log.info(ME, "============ STEP 2: Publish " + numPub + " PtP messages");
                    MsgUnit[] sentArr = new MsgUnit[numPub];
                    PublishReturnQos[] sentQos = new PublishReturnQos[numPub];
                    int i = 0;
                    while (true) {
                        PublishReturnQos prq;
                        MsgUnit msgUnit;
                        if (i >= numPub) {
                            this.log.info(ME, "============ STEP 3: Stop xmlBlaster");
                            this.serverThread.stopServer(true);
                            this.log.info(ME, "============ STEP 4: Start xmlBlaster");
                            this.glob.init(Util.getOtherServerPorts(this.serverPort));
                            this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.glob);
                            this.log.info(ME, "XmlBlaster is ready for testing");
                            this.log.info(ME, "============ STEP 5: Start subscriber");
                            this.updateInterceptorRcv = new MsgInterceptor(this.glob, this.log, null);
                            Global globRcv = this.glob.getClone(null);
                            this.conRcv = globRcv.getXmlBlasterAccess();
                            ConnectQos qosSub = new ConnectQos(globRcv, this.sessionNameRcv, this.passwd);
                            CallbackAddress addr = new CallbackAddress(globRcv);
                            addr.setRetries(-1);
                            String secretCbSessionId = "TrustMeSub";
                            addr.setSecretCbSessionId(secretCbSessionId);
                            qosSub.getSessionCbQueueProperty().setCallbackAddress(addr);
                            ConnectReturnQos crqSub = this.conRcv.connect(qosSub, this.updateInterceptorRcv);
                            this.log.info(ME, "Connect as subscriber '" + crqSub.getSessionName() + "' success");
                            SubscribeKey sk = new SubscribeKey(globRcv, this.oid);
                            SubscribeQos sq = new SubscribeQos(globRcv);
                            sq.setWantInitialUpdate(false);
                            sq.setWantLocal(true);
                            sq.setWantContent(true);
                            HistoryQos historyQos = new HistoryQos(globRcv);
                            historyQos.setNumEntries(1);
                            sq.setHistoryQos(historyQos);
                            SubscribeReturnQos srq = this.conRcv.subscribe(sk.toXml(), sq.toXml());
                            this.log.info(ME, "Subscription to '" + this.oid + "' done");
                            this.log.info(ME, "============ STEP 6: Check if messages arrived");
                            Assert.assertEquals("", numPub, this.updateInterceptorRcv.waitOnUpdate(4000L, this.oid, "OK"));
                            this.updateInterceptorRcv.compareToReceived(sentArr, secretCbSessionId);
                            this.updateInterceptorRcv.compareToReceived(sentQos);
                            this.updateInterceptorRcv.clear();
                            break;
                        }
                        PublishKey pk = new PublishKey(this.glob, this.oid, "text/xml", "1.0");
                        pk.setClientTags("<org.xmlBlaster><demo/></org.xmlBlaster>");
                        PublishQos pq = new PublishQos(this.glob);
                        pq.setPriority(PriorityEnum.NORM_PRIORITY);
                        pq.setPersistent(true);
                        Destination dest = new Destination(this.glob, new SessionName(this.glob, this.sessionNameRcv));
                        dest.forceQueuing(true);
                        pq.addDestination(dest);
                        pq.setForceUpdate(true);
                        pq.setSubscribable(false);
                        pq.setLifeTime(60000L);
                        if (i == 0) {
                            TopicProperty topicProperty = new TopicProperty(this.glob);
                            topicProperty.setDestroyDelay(60000L);
                            topicProperty.setCreateDomEntry(true);
                            topicProperty.setReadonly(false);
                            topicProperty.getHistoryQueueProperty().setMaxEntries(numPub + 5);
                            pq.setTopicProperty(topicProperty);
                            this.log.info(ME, "Added TopicProperty on first publish: " + topicProperty.toXml());
                        }
                        byte[] content = "Hello".getBytes();
                        sentArr[i] = msgUnit = new MsgUnit(pk, content, pq);
                        sentQos[i] = prq = this.conSnd.publish(msgUnit);
                        this.log.info(ME, "Got status='" + prq.getState() + "' rcvTimestamp=" + prq.getRcvTimestamp().toString() + " for published message '" + prq.getKeyOid() + "'");
                        ++i;
                    }
                }
                catch (XmlBlasterException e) {
                    this.log.error(ME, e.toString());
                    e.printStackTrace();
                    Assert.fail(e.toString());
                    Object var17_18 = null;
                    this.log.info(ME, "Disconnecting '" + this.sessionNameRcv + "'");
                    if (this.conRcv != null) {
                        this.conRcv.disconnect(null);
                    }
                    break block11;
                }
                Object var17_17 = null;
                this.log.info(ME, "Disconnecting '" + this.sessionNameRcv + "'");
                if (this.conRcv != null) {
                    this.conRcv.disconnect(null);
                }
            }
            catch (Throwable throwable) {
                Object var17_19 = null;
                this.log.info(ME, "Disconnecting '" + this.sessionNameRcv + "'");
                if (this.conRcv != null) {
                    this.conRcv.disconnect(null);
                }
                throw throwable;
            }
        }
        this.log.info(ME, "Success in testPersistentPtp()");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "TestPtDQueueRedeliver";
        suite.addTest(new TestPtDQueueRedeliver(Global.instance(), "testPersistentPtp"));
        return suite;
    }

    public static void main(String[] args) {
        TestPtDQueueRedeliver testSub = new TestPtDQueueRedeliver(new Global(args), "TestPtDQueueRedeliver");
        testSub.setUp();
        testSub.testPersistentPtp();
        testSub.tearDown();
    }
}

