/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.test.MsgInterceptor;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.address.CallbackAddress;
import org.xmlBlaster.util.qos.address.Destination;

public class TestPtPSubscribable
extends TestCase {
    private static String ME = "TestPtPSubscribable";
    private final Global glob;
    private final LogChannel log;
    private String passwd = "secret";
    private int serverPort = 7615;
    private String oid = "TestPtPSubscribable.Msg";
    private EmbeddedXmlBlaster serverThread = null;
    private String sessionNameRcv = "TestPtPSubscribableReceiver";
    private I_XmlBlasterAccess conRcv;
    private boolean connectedRcv = false;
    private MsgInterceptor updateInterceptorRcv;
    private String sessionNameSnd = "TestPtPSubscribableSender";
    private I_XmlBlasterAccess conSnd;
    private MsgInterceptor updateInterceptorSnd;

    public TestPtPSubscribable() {
        this(new Global(), "TestPtPSubscribable");
    }

    public TestPtPSubscribable(Global glob, String testName) {
        super(testName);
        this.glob = glob;
        this.log = glob.getLog(null);
    }

    protected void setUp() {
        this.glob.init(Util.getOtherServerPorts(this.serverPort));
        this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.glob);
        this.log.info(ME, "XmlBlaster is ready for testing");
    }

    protected void tearDown() {
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.serverThread != null) {
            this.serverThread.stopServer(true);
        }
        Util.resetPorts();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSubscribable() {
        block10: {
            this.log.info(ME, "testSubscribable(" + this.sessionNameRcv + ") ...");
            try {
                try {
                    this.log.info(ME, "============ STEP 1: Start publisher client");
                    Global globSnd = this.glob.getClone(null);
                    this.conSnd = globSnd.getXmlBlasterAccess();
                    ConnectQos qosSnd = new ConnectQos(globSnd);
                    String secretSndCbSessionId = "TrustMeSubSnd";
                    CallbackAddress addrSnd = new CallbackAddress(globSnd);
                    addrSnd.setSecretCbSessionId(secretSndCbSessionId);
                    qosSnd.getSessionCbQueueProperty().setCallbackAddress(addrSnd);
                    this.updateInterceptorSnd = new MsgInterceptor(globSnd, this.log, null);
                    ConnectReturnQos crqPub = this.conSnd.connect(qosSnd, this.updateInterceptorSnd);
                    this.log.info(ME, "Connect success as " + crqPub.getSessionName());
                    this.log.info(ME, "============ STEP 2: Subscribe in Pub/Sub mode");
                    SubscribeKey sk = new SubscribeKey(globSnd, this.oid);
                    SubscribeQos sq = new SubscribeQos(globSnd);
                    sq.setWantInitialUpdate(false);
                    sq.setWantLocal(true);
                    SubscribeReturnQos srq = this.conSnd.subscribe(sk, sq);
                    this.log.info(ME, "Subscription to '" + this.oid + "' done");
                    Assert.assertEquals("", 0, this.updateInterceptorSnd.waitOnUpdate(1000L, this.oid, "OK"));
                    this.log.info(ME, "============ STEP 3: Start receiver");
                    Global globRcv = this.glob.getClone(null);
                    this.conRcv = globRcv.getXmlBlasterAccess();
                    ConnectQos qosRcv = new ConnectQos(globRcv, this.sessionNameRcv, this.passwd);
                    CallbackAddress addr = new CallbackAddress(globRcv);
                    addr.setRetries(-1);
                    String secretCbSessionId = "TrustMeSub";
                    addr.setSecretCbSessionId(secretCbSessionId);
                    qosRcv.getSessionCbQueueProperty().setCallbackAddress(addr);
                    this.updateInterceptorRcv = new MsgInterceptor(globRcv, this.log, null);
                    ConnectReturnQos crqRcv = this.conRcv.connect(qosRcv, this.updateInterceptorRcv);
                    this.log.info(ME, "Connect as subscriber '" + crqRcv.getSessionName() + "' success");
                    this.log.info(ME, "============ STEP 4: Publish PtP message which is NOT subscribable");
                    PublishKey pk = new PublishKey(globSnd, this.oid, "text/xml", "1.0");
                    PublishQos pq = new PublishQos(globSnd);
                    Destination dest = new Destination(globSnd, new SessionName(globSnd, this.sessionNameRcv));
                    pq.addDestination(dest);
                    pq.setSubscribable(false);
                    byte[] content = "Hello".getBytes();
                    MsgUnit msgUnit = new MsgUnit(pk, content, pq);
                    PublishReturnQos prq = this.conSnd.publish(msgUnit);
                    this.log.info(ME, "Got status='" + prq.getState() + "' rcvTimestamp=" + prq.getRcvTimestamp().toString() + " for published message '" + prq.getKeyOid() + "'");
                    Assert.assertEquals("", 1, this.updateInterceptorRcv.waitOnUpdate(1000L, this.oid, "OK"));
                    Assert.assertEquals("", secretCbSessionId, this.updateInterceptorRcv.getMsg(this.oid, "OK").getCbSessionId());
                    Assert.assertEquals("", 0, this.updateInterceptorSnd.waitOnUpdate(1000L, this.oid, "OK"));
                    this.updateInterceptorRcv.clear();
                    this.updateInterceptorSnd.clear();
                    this.log.info(ME, "============ STEP 5: Publish PtP message which IS subscribable");
                    pk = new PublishKey(globSnd, this.oid, "text/xml", "1.0");
                    pq = new PublishQos(globSnd);
                    dest = new Destination(globSnd, new SessionName(globSnd, this.sessionNameRcv));
                    pq.addDestination(dest);
                    pq.setSubscribable(true);
                    content = "Hello".getBytes();
                    msgUnit = new MsgUnit(pk, content, pq);
                    prq = this.conSnd.publish(msgUnit);
                    this.log.info(ME, "Got status='" + prq.getState() + "' rcvTimestamp=" + prq.getRcvTimestamp().toString() + " for published message '" + prq.getKeyOid() + "'");
                    Assert.assertEquals("", 1, this.updateInterceptorRcv.waitOnUpdate(1000L, this.oid, "OK"));
                    Assert.assertEquals("", secretCbSessionId, this.updateInterceptorRcv.getMsg(this.oid, "OK").getCbSessionId());
                    Assert.assertEquals("", 1, this.updateInterceptorSnd.waitOnUpdate(1000L, this.oid, "OK"));
                    Assert.assertEquals("", secretSndCbSessionId, this.updateInterceptorSnd.getMsg(this.oid, "OK").getCbSessionId());
                    this.updateInterceptorRcv.clear();
                    this.updateInterceptorSnd.clear();
                }
                catch (XmlBlasterException e) {
                    this.log.error(ME, e.toString());
                    Assert.fail(e.toString());
                    Object var21_22 = null;
                    this.log.info(ME, "Disconnecting '" + this.sessionNameRcv + "'");
                    if (this.conRcv != null) {
                        this.conRcv.disconnect(null);
                    }
                    if (this.conSnd != null) {
                        this.conSnd.disconnect(null);
                    }
                    break block10;
                }
                Object var21_21 = null;
                this.log.info(ME, "Disconnecting '" + this.sessionNameRcv + "'");
                if (this.conRcv != null) {
                    this.conRcv.disconnect(null);
                }
            }
            catch (Throwable throwable) {
                Object var21_23 = null;
                this.log.info(ME, "Disconnecting '" + this.sessionNameRcv + "'");
                if (this.conRcv != null) {
                    this.conRcv.disconnect(null);
                }
                if (this.conSnd != null) {
                    this.conSnd.disconnect(null);
                }
                throw throwable;
            }
            if (this.conSnd != null) {
                this.conSnd.disconnect(null);
            }
        }
        this.log.info(ME, "Success in testSubscribable()");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "TestPtPSubscribable";
        suite.addTest(new TestPtPSubscribable(Global.instance(), "testSubscribable"));
        return suite;
    }

    public static void main(String[] args) {
        TestPtPSubscribable testSub = new TestPtPSubscribable(new Global(args), "TestPtPSubscribable");
        testSub.setUp();
        testSub.testSubscribable();
        testSub.tearDown();
    }
}

