/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.test.MsgInterceptor;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.address.Destination;

public class TestPtSession
extends TestCase {
    private static String ME = "TestPtSession";
    private Global glob;
    private LogChannel log;
    private int numCons = 5;
    private ConHolder[] conHolderArr;
    private String name;
    private String passwd = "secret";
    private EmbeddedXmlBlaster serverThread;
    private int serverPort = 9560;
    private boolean startEmbedded = true;
    private final String msgOid = "ptpTestMessage";
    private int msgSequenceNumber = 0;

    public TestPtSession(Global glob, String testName, String name) {
        super(testName);
        this.glob = glob;
        this.log = glob.getLog("test");
        this.name = name;
    }

    protected void setUp() {
        this.startEmbedded = this.glob.getProperty().get("startEmbedded", this.startEmbedded);
        if (this.startEmbedded) {
            this.glob.init(Util.getOtherServerPorts(this.serverPort));
            String[] args = new String[]{};
            this.glob.init(args);
            this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.glob);
            this.log.info(ME, "XmlBlaster is ready for testing the session PtP messages");
        } else {
            this.log.warn(ME, "You need to start an external xmlBlaster server for this test or use option -startEmbedded true");
        }
        this.conHolderArr = new ConHolder[this.numCons];
        int ii = 0;
        while (ii < this.conHolderArr.length) {
            this.conHolderArr[ii] = new ConHolder();
            try {
                this.log.info(ME, "Connecting ...");
                Global globTmp = this.glob.getClone(null);
                this.conHolderArr[ii].con = globTmp.getXmlBlasterAccess();
                ConnectQos qos = new ConnectQos(globTmp, this.name, this.passwd);
                this.conHolderArr[ii].update = new MsgInterceptor(globTmp, this.log, null);
                this.conHolderArr[ii].connectReturnQos = this.conHolderArr[ii].con.connect(qos, this.conHolderArr[ii].update);
            }
            catch (Exception e) {
                Thread.currentThread();
                Thread.dumpStack();
                this.log.error(ME, "Can't connect to xmlBlaster: " + e.toString());
                Assert.fail("Can't connect to xmlBlaster: " + e.toString());
            }
            ++ii;
        }
        int ii2 = 0;
        while (ii2 < this.conHolderArr.length) {
            this.conHolderArr[ii2].update.clear();
            ++ii2;
        }
    }

    private void publish(ConHolder conHolder, String oid, SessionName[] sessionNameArr) {
        try {
            ++this.msgSequenceNumber;
            String content = "" + this.msgSequenceNumber;
            PublishQos pq = new PublishQos(this.glob);
            int i = 0;
            while (i < sessionNameArr.length) {
                pq.addDestination(new Destination(sessionNameArr[i]));
                ++i;
            }
            MsgUnit msgUnit = new MsgUnit("<key oid='" + oid + "'/>", content.getBytes(), pq.toXml());
            PublishReturnQos rq = conHolder.con.publish(msgUnit);
            this.log.info(ME, "SUCCESS publish '" + oid + "' with " + sessionNameArr.length + " destinations, returned state=" + rq.getState());
            Assert.assertEquals("Returned oid wrong", oid, rq.getKeyOid());
            Assert.assertEquals("Return not OK", "OK", rq.getState());
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.fail("publish - XmlBlasterException: " + e.getMessage());
        }
    }

    public void testPtSession() {
        this.log.info(ME, "testPtSession() ...");
        long sleep = 1000L;
        this.log.info(ME, "TEST #1: Sending PtP message to all sessions of client " + this.name);
        SessionName[] sessionNameArr = new SessionName[]{new SessionName(this.glob, this.name)};
        this.publish(this.conHolderArr[0], "ptpTestMessage", sessionNameArr);
        int ii = 0;
        while (ii < this.conHolderArr.length) {
            Assert.assertEquals("", 1, this.conHolderArr[ii].update.waitOnUpdate(sleep, "ptpTestMessage", "OK"));
            this.conHolderArr[ii].update.clear();
            ++ii;
        }
        SessionName sessionName3 = this.conHolderArr[3].connectReturnQos.getSessionName();
        this.log.info(ME, "TEST #2: Sending PtP message to session " + sessionName3.getAbsoluteName());
        SessionName[] sessionNameArr2 = new SessionName[]{sessionName3};
        this.publish(this.conHolderArr[0], "ptpTestMessage", sessionNameArr2);
        int ii2 = 0;
        while (ii2 < this.conHolderArr.length) {
            int numExpected = ii2 == 3 ? 1 : 0;
            Assert.assertEquals("ii=" + ii2, numExpected, this.conHolderArr[ii2].update.waitOnUpdate(sleep, "ptpTestMessage", "OK"));
            this.conHolderArr[ii2].update.clear();
            ++ii2;
        }
        SessionName sessionName1 = this.conHolderArr[1].connectReturnQos.getSessionName();
        SessionName sessionName32 = this.conHolderArr[3].connectReturnQos.getSessionName();
        this.log.info(ME, "TEST #3: Sending PtP message to session " + sessionName32.getAbsoluteName() + " and " + sessionName1.getAbsoluteName());
        SessionName[] sessionNameArr3 = new SessionName[]{sessionName32, sessionName1};
        this.publish(this.conHolderArr[0], "ptpTestMessage", sessionNameArr3);
        int ii3 = 0;
        while (ii3 < this.conHolderArr.length) {
            int numExpected = ii3 == 1 || ii3 == 3 ? 1 : 0;
            Assert.assertEquals("ii=" + ii3, numExpected, this.conHolderArr[ii3].update.waitOnUpdate(sleep, "ptpTestMessage", "OK"));
            this.conHolderArr[ii3].update.clear();
            ++ii3;
        }
        this.log.info(ME, "Success in testPtSession()");
    }

    protected void tearDown() {
        int ii = 0;
        while (ii < this.conHolderArr.length) {
            this.conHolderArr[ii].con.disconnect(null);
            ++ii;
        }
        this.conHolderArr = null;
        if (this.startEmbedded) {
            EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
            this.serverThread = null;
            Util.resetPorts();
            this.serverThread = null;
        }
        this.log.error(ME, "DEBUG ONLY: tearDown() all resources released");
        this.glob = null;
        this.log = null;
        Global.instance().shutdown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "PtSession";
        suite.addTest(new TestPtSession(Global.instance(), "testPtSession", "PtSession"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.exit(0);
        }
        TestPtSession testSub = new TestPtSession(glob, "TestPtSession", "TestPtSession");
        testSub.setUp();
        testSub.testPtSession();
        testSub.tearDown();
    }

    class ConHolder {
        public I_XmlBlasterAccess con;
        public MsgInterceptor update;
        public ConnectReturnQos connectReturnQos;

        ConHolder() {
        }
    }
}

