/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class TestPubBurstMode
extends TestCase {
    private static String ME = "TestPubBurstMode";
    private final Global glob;
    private final LogChannel log;
    private boolean messageArrived = false;
    private String subscribeOid;
    private String publishOid = "AMessage";
    private I_XmlBlasterAccess senderConnection;
    private String senderName;
    private int numPublish;
    private final String contentMime = "text/xml";
    private final String contentMimeExtended = "1.0";
    private StopWatch stopWatch = new StopWatch();

    public TestPubBurstMode(Global glob, String testName, String loginName) {
        super(testName);
        this.glob = glob;
        this.log = this.glob.getLog("test");
        this.senderName = loginName;
    }

    protected void setUp() {
        try {
            this.numPublish = this.glob.getProperty().get("numPublish", 100);
            this.senderConnection = this.glob.getXmlBlasterAccess();
            String passwd = "secret";
            ConnectQos connectQos = new ConnectQos(this.glob, this.senderName, passwd);
            this.senderConnection.connect(connectQos, null);
        }
        catch (Exception e) {
            this.log.error(ME, e.toString());
            e.printStackTrace();
        }
    }

    protected void tearDown() {
        String xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='" + this.publishOid + "' queryType='EXACT'>\n" + "</key>";
        String qos = "<qos></qos>";
        try {
            EraseReturnQos[] arr = this.senderConnection.erase(xmlKey, qos);
            Assert.assertEquals("Erase", 1, arr.length);
        }
        catch (XmlBlasterException e) {
            Assert.fail("Erase XmlBlasterException: " + e.getMessage());
        }
        this.senderConnection.disconnect(null);
    }

    public void testPublish() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Publishing messages ...");
        }
        String xmlKey = "<key oid='" + this.publishOid + "' contentMime='" + "text/xml" + "' contentMimeExtended='" + "1.0" + "'>\n" + "   <TestPubBurstMode-AGENT id='192.168.124.10' subId='1' type='generic'>" + "   </TestPubBurstMode-AGENT>" + "</key>";
        PublishQos qosWrapper = new PublishQos(this.glob);
        String qos = qosWrapper.toXml();
        MsgUnit[] msgUnitArr = new MsgUnit[this.numPublish];
        try {
            int ii = 0;
            while (ii < this.numPublish) {
                String senderContent = ME + ii;
                msgUnitArr[ii] = new MsgUnit(xmlKey, senderContent.getBytes(), qos);
                ++ii;
            }
        }
        catch (XmlBlasterException e) {
            Assert.fail(e.getMessage());
        }
        PublishReturnQos[] publishOidArr = null;
        try {
            this.log.info(ME, "Publishing " + this.numPublish + " messages in burst mode ...");
            this.stopWatch = new StopWatch();
            publishOidArr = this.senderConnection.publishArr(msgUnitArr);
            double elapsed = (double)this.stopWatch.elapsed() / 1000.0;
            this.log.info(ME, "Published " + this.numPublish + " messages in burst mode in " + elapsed + " sec: " + (long)((double)this.numPublish / elapsed) + " messages/sec");
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
        Assert.assertTrue("returned publishOidArr == null", publishOidArr != null);
        Assert.assertEquals("returned publishOidArr", this.numPublish, publishOidArr.length);
    }

    public void testPublishMany() {
        this.testPublish();
        this.log.plain(ME, "");
        this.testPublish();
        this.log.plain(ME, "");
        this.testPublish();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "Tim";
        suite.addTest(new TestPubBurstMode(new Global(), "testPublishMany", loginName));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.err.println(ME + ": Init failed");
            System.exit(1);
        }
        TestPubBurstMode testPub = new TestPubBurstMode(glob, "TestPubBurstMode", "Tim");
        testPub.setUp();
        testPub.testPublishMany();
        testPub.tearDown();
    }
}

